/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.mmcompiler.parser;

import mulesoft.lexer.TokenType;
import mulesoft.mmcompiler.ast.MMToken;
import mulesoft.mmcompiler.parser.DatabaseObjectParser;
import mulesoft.mmcompiler.parser.MetaModelParser;
import mulesoft.parser.Parser;
import mulesoft.type.MetaModelKind;

class ViewParser
extends DatabaseObjectParser {
    private boolean asView;

    private ViewParser(MetaModelParser parent) {
        super(parent);
    }

    @Override
    public void parse() {
        this.parseLabeledId(false);
        this.parseViewOptions();
        this.parseViewElements();
        this.endTree(MMToken.VIEW);
    }

    private void parseAs() {
        this.beginTree();
        this.consume();
        this.match(MMToken.STRING_LITERAL);
        this.endTree(MMToken.AS);
        this.asView = true;
    }

    private void parseBatchSize() {
        this.beginTree();
        this.discard();
        this.parseOptionalInteger();
        this.endTree(MMToken.BATCH_SIZE);
    }

    private void parseViewElements() {
        if (!this.parseList(MMToken.LIST, MMToken.LEFT_BRACE, null, MMToken.RIGHT_BRACE, new ViewElementParser())) {
            this.discardOrError(MMToken.SEMICOLON);
        }
    }

    private void parseViewOptions() {
        this.currentByTextAnyOfOrError(new MMToken[]{MMToken.OF, MMToken.AS});
        block14: while (this.notCurrentAnyOf(new MMToken[]{MMToken.LEFT_BRACE})) {
            this.loopCheck();
            MMToken token = (MMToken)this.getAnyOf(new MMToken[]{MMToken.OF, MMToken.DESCRIBED_BY, MMToken.IMAGE, MMToken.SEARCHABLE, MMToken.UPDATABLE, MMToken.INDEX, MMToken.UNIQUE, MMToken.AS, MMToken.PRIMARY_KEY, MMToken.REMOTABLE, MMToken.OPTIMISTIC, MMToken.BATCH_SIZE});
            switch (token) {
                case OF: {
                    this.parseOptionWithRefsExpecting(MMToken.OF, MMToken.DATAOBJECT_REF);
                    continue block14;
                }
                case PRIMARY_KEY: {
                    this.parseOptionWithFields(MMToken.PRIMARY_KEY, new MMToken[0]);
                    continue block14;
                }
                case DESCRIBED_BY: {
                    this.parseOptionWithFields(MMToken.DESCRIBED_BY, new MMToken[0]);
                    continue block14;
                }
                case IMAGE: {
                    this.parseOptionWithField(MMToken.IMAGE, new MMToken[0]);
                    continue block14;
                }
                case UPDATABLE: {
                    this.parseOptionWithoutFields(MMToken.UPDATABLE);
                    continue block14;
                }
                case BATCH_SIZE: {
                    this.parseBatchSize();
                    continue block14;
                }
                case REMOTABLE: {
                    this.parseOptionWithoutFields(MMToken.REMOTABLE);
                    continue block14;
                }
                case OPTIMISTIC: {
                    this.parseOptionWithoutFields(MMToken.OPTIMISTIC);
                    continue block14;
                }
                case SEARCHABLE: {
                    this.parseSearchable();
                    continue block14;
                }
                case UNIQUE: {
                    this.parseIndex(MMToken.UNIQUE);
                    continue block14;
                }
                case INDEX: {
                    this.parseIndex(MMToken.INDEX);
                    continue block14;
                }
                case AS: {
                    this.parseAs();
                    continue block14;
                }
            }
            this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.LEFT_BRACE});
        }
    }

    static void register() {
        ViewParser.registerDefinitionParser(MMToken.VIEW, ViewParser::new);
    }

    private final class ViewElementParser
    implements Parser {
        private ViewElementParser() {
        }

        public void parse() {
            ViewParser.this.beginTree();
            ViewParser.this.parseLabeledId(false);
            if (ViewParser.this.currentOrError(MMToken.COLON)) {
                if (ViewParser.this.asView) {
                    this.parseFieldDefinition(false);
                } else {
                    ViewParser.this.discard((TokenType)MMToken.COLON);
                    if (ViewParser.this.current((TokenType)MMToken.IDENTIFIER)) {
                        if (ViewParser.this.lookAhead(1) == MMToken.COMMA || ViewParser.this.lookAhead(2) == MMToken.COMMA) {
                            this.parseFieldDefinition(true);
                        } else {
                            ViewParser.this.parseId(MMToken.FIELD_REF);
                            ViewParser.this.discardOrError(MMToken.SEMICOLON);
                        }
                    } else {
                        ViewParser.this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
                    }
                }
            } else {
                ViewParser.this.advanceTo(new MMToken[]{MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
                ViewParser.this.discard(MMToken.SEMICOLON);
            }
            ViewParser.this.endTree(MMToken.FIELD);
        }

        private void parseFieldDefinition(boolean allowTypeCardinality) {
            ViewParser.this.discard(MMToken.COLON);
            if (ViewParser.this.current(MMToken.IDENTIFIER)) {
                ViewParser.this.parseType(true, allowTypeCardinality, MMToken.TYPE_REF);
            } else {
                ViewParser.this.unexpectedAndAdvanceTo(new MMToken[]{MMToken.COMMA, MMToken.SEMICOLON, MMToken.RIGHT_BRACE});
            }
            ViewParser.this.parseFieldOptions(MetaModelKind.ENTITY, false);
            ViewParser.this.discardOrError(MMToken.SEMICOLON);
        }
    }
}

