/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityInstanceBaseImpl;
import mulesoft.persistence.EntityTable;
import org.jetbrains.annotations.NotNull;

public abstract class CachedEntityInstanceImpl<This extends EntityInstance<This, K>, K>
extends EntityInstanceBaseImpl<This, K> {
    private final Function<CachedEntityInstanceImpl<This, K>, AbstractData<This, K>> getData;
    private final BiConsumer<CachedEntityInstanceImpl<This, K>, AbstractData<This, K>> setData;

    protected CachedEntityInstanceImpl(Function<CachedEntityInstanceImpl<This, K>, AbstractData<This, K>> getData, BiConsumer<CachedEntityInstanceImpl<This, K>, AbstractData<This, K>> setData) {
        this.getData = getData;
        this.setData = setData;
    }

    @Override
    @NotNull
    public String keyAsString() {
        return this._data().keyAsString();
    }

    @Override
    @NotNull
    public K keyObject() {
        return this._data().keyObject();
    }

    @Override
    public boolean modified() {
        return this._data().modified;
    }

    protected AbstractData<This, K> data() {
        AbstractData<This, K> d = this._data();
        if (((AbstractData)d).cached) {
            return d;
        }
        if (d.hasEmptyKey() || d.modified) {
            d.onLoad((EntityInstance)Predefined.cast((Object)this));
            return d;
        }
        return this.cacheAndLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsModified(AbstractData<This, K> d) {
        if (!d.modified) {
            CachedEntityInstanceImpl cachedEntityInstanceImpl = this;
            synchronized (cachedEntityInstanceImpl) {
                this._data().markAsModified(this);
            }
        }
    }

    @NotNull
    AbstractData<This, K> _data() {
        return this.getData.apply(this);
    }

    @Override
    void resetModified() {
        this._data().resetModified();
    }

    private synchronized AbstractData<This, K> cacheAndLoad() {
        AbstractData<This, K> d = this._data();
        if (((AbstractData)d).cached) {
            return d;
        }
        EntityInstance cached = this.table().entityTable().getStoreHandler().cache((EntityInstance)Predefined.cast((Object)this), true);
        this.setData.accept(this, CachedEntityInstanceImpl.dataField(cached));
        return this._data();
    }

    static <T extends EntityInstance<T, K>, K> AbstractData<T, K> dataField(@NotNull T instance) {
        CachedEntityInstanceImpl base = (CachedEntityInstanceImpl)Predefined.cast(instance);
        return base._data();
    }

    public static abstract class AbstractData<I extends EntityInstance<I, K>, K>
    implements Cloneable {
        boolean modified = false;
        private boolean cached = false;

        public boolean equals(Object o) {
            if (!this.getClass().isInstance(o)) {
                return false;
            }
            AbstractData that = (AbstractData)Predefined.cast((Object)o);
            return this.keyObject().equals(that.keyObject());
        }

        public int hashCode() {
            return this.keyObject().hashCode();
        }

        public void onLoad(I instance) {
        }

        protected boolean hasEmptyKey() {
            return false;
        }

        protected abstract String keyAsString();

        protected abstract K keyObject();

        void markAsModified(CachedEntityInstanceImpl<I, K> instance) {
            if (!this.cached || this.modified) {
                this.modified = true;
                return;
            }
            try {
                AbstractData dirtyData = (AbstractData)Predefined.cast((Object)this.clone());
                dirtyData.modified = true;
                dirtyData.cached = false;
                EntityTable et = instance.table().entityTable();
                EntityInstance self = (EntityInstance)Predefined.cast(instance);
                et.getStoreHandler().cache(self, false);
                ((CachedEntityInstanceImpl)instance).setData.accept(instance, dirtyData);
            }
            catch (CloneNotSupportedException e) {
                throw Predefined.unreachable();
            }
        }

        void resetModified() {
            this.modified = false;
        }

        void setCached(boolean b) {
            if (b == this.cached) {
                return;
            }
            this.cached = b;
        }
    }
}

