/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import mulesoft.common.Predefined;
import mulesoft.common.annotation.Pure;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.persistence.expr.Case;
import mulesoft.persistence.expr.Const;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import mulesoft.persistence.expr.Operation;
import org.jetbrains.annotations.NotNull;

public interface Criteria
extends Expr<Boolean> {
    public static final Criteria EMPTY = new Empty();
    public static final Criteria FALSE = new Empty(){

        @Override
        public Criteria and(Criteria right) {
            return FALSE;
        }

        @Override
        public Criteria not() {
            return TRUE;
        }

        @Override
        public <Q> Q accept(ExprVisitor<Q> visitor) {
            return Const.acceptBoolean(visitor, false);
        }
    };
    public static final Criteria TRUE = new Empty(){

        @Override
        public Criteria or(Criteria right) {
            return TRUE;
        }

        @Override
        public Criteria not() {
            return FALSE;
        }

        @Override
        public <Q> Q accept(ExprVisitor<Q> visitor) {
            return Const.acceptBoolean(visitor, true);
        }
    };

    @Pure
    default public Criteria and(Criteria right) {
        return right.isConst() ? right.and(this) : this.bool(ExprOperator.AND, right);
    }

    @Pure
    default public Criteria not() {
        return this.bool(ExprOperator.NOT, new Expr[0]);
    }

    @Pure
    default public Criteria or(Criteria right) {
        return right.isConst() ? right.or(this) : this.bool(ExprOperator.OR, right);
    }

    @Pure
    default public <E extends Expr<T>, T> Case.SearchedBuilder<E, T> then(E then) {
        return new Case.SearchedBuilder(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Decimal, BigDecimal> then(Expr.Decimal then) {
        return new Case.SearchedBuilder<Expr.Decimal, BigDecimal>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Int, Integer> then(Expr.Int then) {
        return new Case.SearchedBuilder<Expr.Int, Integer>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Long, Long> then(Expr.Long then) {
        return new Case.SearchedBuilder<Expr.Long, Long>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Real, Double> then(Expr.Real then) {
        return new Case.SearchedBuilder<Expr.Real, Double>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Str, String> then(Expr.Str then) {
        return new Case.SearchedBuilder<Expr.Str, String>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.Date, DateOnly> then(Expr.Date then) {
        return new Case.SearchedBuilder<Expr.Date, DateOnly>(this, then);
    }

    @Pure
    default public Case.SearchedBuilder<Expr.DTime, DateTime> then(Expr.DTime then) {
        return new Case.SearchedBuilder<Expr.DTime, DateTime>(this, then);
    }

    @Pure
    default public <T extends Enum<T>, I> Case.SearchedBuilder<Expr.Enum<T, I>, T> then(Expr.Enum<T, I> then) {
        return new Case.SearchedBuilder(this, then);
    }

    @Pure
    default public <E extends Expr<T>, T> Case.SearchedBuilder<E, T> then(T then) {
        return this.then((T)((Expr)Predefined.cast(Expr.constant(then))));
    }

    @Override
    default public Expr<Boolean> unary(ExprOperator operator) {
        return this.bool(operator, this);
    }

    @Pure
    default public Criteria isFalse() {
        return this.eq(FALSE);
    }

    @Pure
    default public Criteria isTrue() {
        return this.eq(TRUE);
    }

    default public boolean isConst() {
        return false;
    }

    @Override
    @NotNull
    default public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    default public Boolean getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
        boolean b = rs.getBoolean(columnIndex);
        return rs.wasNull() ? null : Boolean.valueOf(b);
    }

    public static Criteria allOf(Iterable<Criteria> criteriaList) {
        return Operation.boolOperation(ExprOperator.AND, criteriaList);
    }

    public static Criteria allOf(Criteria ... criteriaList) {
        return Operation.boolOperation(ExprOperator.AND, (Iterable<Criteria>)ImmutableList.fromArray((Object[])criteriaList));
    }

    public static Criteria anyOf(Iterable<Criteria> criteriaList) {
        return Operation.boolOperation(ExprOperator.OR, criteriaList);
    }

    public static Criteria anyOf(Criteria ... criteriaList) {
        return Operation.boolOperation(ExprOperator.OR, (Iterable<Criteria>)ImmutableList.fromArray((Object[])criteriaList));
    }

    public static class Empty
    extends ExprImpl<Boolean>
    implements Criteria {
        @Override
        public <Q> Q accept(ExprVisitor<Q> visitor) {
            throw new IllegalStateException();
        }

        @Override
        public Criteria and(Criteria right) {
            return right;
        }

        @Override
        public Criteria not() {
            return this;
        }

        @Override
        public Criteria or(Criteria right) {
            return right;
        }

        @Override
        public final boolean isConst() {
            return true;
        }
    }
}

