/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.HashMap;
import java.util.Map;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.StoreHandler;

public class DbStoreHandlerFactory
implements StoreHandler.Factory {
    private final StoreHandler.Factory defaultFactory;
    private final Map<String, StoreHandler.Factory> factoryMap;

    public DbStoreHandlerFactory(StoreHandler.Factory defaultFactory) {
        this.defaultFactory = defaultFactory;
        this.factoryMap = new HashMap<String, StoreHandler.Factory>();
    }

    @Override
    public <I extends EntityInstance<I, K>, K> StoreHandler<I, K> createHandler(String storeType, DbTable<I, K> dbTable) {
        return this.findFactory(storeType).createHandler(storeType, dbTable);
    }

    public void register(String type, StoreHandler.Factory factory) {
        this.factoryMap.put(type, factory);
    }

    private StoreHandler.Factory findFactory(String storeType) {
        StoreHandler.Factory f = this.factoryMap.get(storeType);
        return f == null ? this.defaultFactory : f;
    }
}

