/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;
import mulesoft.cache.CacheType;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.util.Reflection;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.Select;
import mulesoft.persistence.TableFactory;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableLike;
import mulesoft.persistence.TableMetadata;
import mulesoft.persistence.expr.Expr;
import mulesoft.type.IntType;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;

public abstract class DbTable<I extends EntityInstance<I, K>, K>
extends TableLike<I>
implements Cloneable {
    private String alias = "";
    private EntityTable<I, K> impl = null;
    private final TableMetadata<I, K> metadata;
    private ImmutableList<TableField<?>> primaryKey = ImmutableList.empty();
    private ImmutableList<ImmutableList<TableField<?>>> secondaryKeys = ImmutableList.empty();

    protected DbTable(Class<I> entityClass, String schemaName, String tableName, String sequenceName, EnumSet<Modifier> modifiers, CacheType cacheType) {
        this.metadata = new TableMetadata<I, K>(entityClass, schemaName, tableName, sequenceName, modifiers, cacheType){

            @Override
            @NotNull
            public ImmutableList<ImmutableList<TableField<?>>> getSecondaryKeys() {
                return DbTable.this.secondaryKeys;
            }

            @Override
            @NotNull
            public ImmutableList<TableField<?>> getPrimaryKey() {
                return DbTable.this.primaryKey;
            }

            @Override
            @NotNull
            public K keyFromString(String s) {
                return DbTable.this.strToKey(s);
            }
        };
    }

    public abstract DbTable<I, K> as(String var1);

    @Override
    public String asTableExpression() {
        return "QName(" + this.metadata.getSchemaName() + ", " + this.metadata.getTableName() + ")" + (this.alias.isEmpty() ? "" : " " + this.alias);
    }

    public TableMetadata<I, K> metadata() {
        return this.metadata;
    }

    public String toString() {
        return this.metadata.getTableName();
    }

    protected TableField.Bool boolField(String fieldName, String columnName) {
        return this.metadata.addField(new TableField.Bool(this, this.fieldFor(fieldName), columnName));
    }

    protected TableField.Clob clobField(String fieldName, String columnName, int length) {
        return this.metadata.addField(new TableField.Clob(this, this.fieldFor(fieldName), columnName, length));
    }

    protected <T extends DbTable<I, K>> T createAlias(T t, String aliasName) {
        T dbTable = t;
        dbTable.alias = aliasName;
        dbTable.impl = this.entityTable();
        return t;
    }

    protected abstract EntityTable<I, K> createEntityTable();

    protected TableField.Date dateField(String fieldName, String columnName) {
        return this.metadata.addField(new TableField.Date(this, this.fieldFor(fieldName), columnName));
    }

    protected TableField.Decimal decimalField(String fieldName, String columnName, boolean signed, int precision, int length) {
        return this.metadata.addField(new TableField.Decimal(this, this.fieldFor(fieldName), columnName, signed, precision, length));
    }

    protected TableField.DTime dTimeField(String fieldName, String columnName) {
        return this.metadata.addField(new TableField.DTime(this, this.fieldFor(fieldName), columnName));
    }

    @NotNull
    protected final EntityTable<I, K> entityTable() {
        return this.impl != null ? this.impl : this.bindTable();
    }

    protected <E extends Enum<E>, ID> TableField.Enum<E, ID> enumField(String fieldName, String columnName, Class<E> clazz) {
        return this.metadata.addField(new TableField.Enum(this, this.fieldFor(fieldName), columnName, clazz));
    }

    protected <E extends Enum<E>, ID> TableField.EnumerationSet<E, ID> enumSetField(String fieldName, String columnName, Class<E> clazz) {
        return this.metadata.addField(new TableField.EnumerationSet(this, this.fieldFor(fieldName), columnName, clazz));
    }

    protected TableField.Int intField(String fieldName, String columnName) {
        return this.intField(fieldName, columnName, false, IntType.MAX_INT_LENGTH);
    }

    protected TableField.Int intField(String fieldName, String columnName, boolean signed, int length) {
        return this.metadata.addField(new TableField.Int(this, this.fieldFor(fieldName), columnName, signed, length));
    }

    protected TableField.LongFld longField(String fieldName, String columnName, boolean signed, int length) {
        return this.metadata.addField(new TableField.LongFld(this, this.fieldFor(fieldName), columnName, signed, length));
    }

    protected final void primaryKey(ImmutableList<TableField<?>> pkFields) {
        pkFields.forEach(TableField::primaryKey);
        this.primaryKey = pkFields;
    }

    protected TableField.Real realField(String fieldName, String columnName, boolean signed) {
        return this.metadata.addField(new TableField.Real(this, this.fieldFor(fieldName), columnName, signed));
    }

    protected TableField.Res resourceField(String fieldName, String columnName) {
        return this.metadata.addField(new TableField.Res(this, this.fieldFor(fieldName), columnName));
    }

    protected final void secondaryKeys(ImmutableList<ImmutableList<TableField<?>>> keys) {
        this.secondaryKeys = keys;
    }

    protected TableField.Str strField(String fieldName, String columnName, int length) {
        return this.metadata.addField(new TableField.Str(this, this.fieldFor(fieldName), columnName, length));
    }

    protected TableField.Str strInternField(String fieldName, String columnName, int length) {
        return this.metadata.addField(new TableField.StrIntern(this, this.fieldFor(fieldName), columnName, length));
    }

    protected abstract K strToKey(String var1);

    String alias() {
        return this.alias;
    }

    void doBind() {
        this.impl = this.createEntityTable();
        TableFactory.bind(this);
    }

    @Override
    Collection<TableField<?>> fields() {
        return this.metadata.fieldMap().values();
    }

    @Override
    <I1 extends EntityInstance<I1, K1>, K1> DbTable<I1, K1> getDbTable() {
        return (DbTable)Predefined.cast((Object)this);
    }

    @Override
    boolean isSingleTable() {
        return true;
    }

    @Override
    Expr<?>[] getExpressions() {
        return Select.EMPTY_EXPR;
    }

    @Override
    Class<I> getType() {
        return this.metadata.getType();
    }

    private synchronized EntityTable<I, K> bindTable() {
        if (this.impl == null) {
            this.doBind();
        }
        return this.impl;
    }

    private Field fieldFor(String fieldName) {
        return Reflection.findFieldOrFail(this.metadata.getDataClass(), (String)fieldName);
    }

    public static <I extends EntityInstance<I, K>, K> DbTable<I, K> forName(String instanceClassName) {
        return ((EntityInstance)Reflection.construct((String)instanceClassName, (Object[])new Object[0])).table();
    }
}

