/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.List;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.Select;
import mulesoft.persistence.SetClause;
import mulesoft.persistence.StoreHandler;
import mulesoft.persistence.TableField;
import org.jetbrains.annotations.NotNull;

public class DelegatingStoreHandler<T extends EntityInstance<T, K>, K>
extends StoreHandler<T, K> {
    public DelegatingStoreHandler(@NotNull StoreHandler<T, K> delegate) {
        super(delegate.getDbTable(), delegate);
    }

    @Override
    public void delete(T instance) {
        this.getDelegate().delete(instance);
    }

    @Override
    public void delete(Iterable<K> keys) {
        this.getDelegate().delete(keys);
    }

    @Override
    public void deleteWhere(Criteria ... condition) {
        this.getDelegate().deleteWhere(condition);
    }

    @Override
    public T find(K key) {
        return this.getDelegate().find(key);
    }

    @Override
    public T findPersisted(K key) {
        return this.getDelegate().findPersisted(key);
    }

    @Override
    public int insert(List<SetClause<?>> setClauses) {
        return this.getDelegate().insert(setClauses);
    }

    @Override
    public void insert(T instance, boolean generateKey) {
        this.getDelegate().insert(instance, generateKey);
    }

    @Override
    public int insertOrUpdate(List<SetClause<?>> insertSetClauses, TableField<?>[] keyColumns, List<SetClause<?>> setClauses, Criteria[] criteria) {
        return this.getDelegate().insertOrUpdate(insertSetClauses, keyColumns, setClauses, criteria);
    }

    @Override
    public ImmutableList<T> list(Iterable<K> keys) {
        return this.getDelegate().list(keys);
    }

    @Override
    public void merge(@NotNull T instance) {
        this.getDelegate().merge(instance);
    }

    @Override
    public <E> Select.Handler<E> select(Select<E> select) {
        return this.getDelegate().select(select);
    }

    @Override
    public void update(T instance) {
        this.getDelegate().update(instance);
    }

    @Override
    public int update(List<SetClause<?>> setClauses, Criteria[] criteria) {
        return this.getDelegate().update(setClauses, criteria);
    }

    @Override
    public void updateLocking(T instance) {
        this.getDelegate().updateLocking(instance);
    }

    @Override
    protected T cache(T instance, boolean cached) {
        return this.getDelegate().cache(instance, cached);
    }

    @NotNull
    protected StoreHandler<T, K> getDelegate() {
        return (StoreHandler)Predefined.ensureNotNull(this.getParent());
    }

    public static class ByThread<T extends EntityInstance<T, K>, K>
    extends DelegatingStoreHandler<T, K> {
        private StoreHandler<T, K> defaultDelegate;
        private final ThreadLocal<StoreHandler<T, K>> delegate;

        public ByThread(@NotNull StoreHandler<T, K> parent) {
            super(parent);
            this.defaultDelegate = parent;
            this.delegate = ThreadLocal.withInitial(() -> this.defaultDelegate);
        }

        public void resetDelegate() {
            this.delegate.remove();
        }

        public void setDefaultDelegate(@NotNull StoreHandler<T, K> delegate) {
            this.defaultDelegate = delegate;
        }

        public void setDelegate(StoreHandler<T, K> delegate) {
            this.delegate.set(delegate);
        }

        @Override
        @NotNull
        protected StoreHandler<T, K> getDelegate() {
            return this.delegate.get();
        }
    }
}

