/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mulesoft.common.collections.Colls;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityListener;
import mulesoft.persistence.EntityListenerType;
import org.jetbrains.annotations.Nullable;

class EntityListenerMap<T extends EntityInstance<T, ?>> {
    private final ThreadLocal<Set<T>> activeInstances = ThreadLocal.withInitial(HashSet::new);
    private boolean hasUpdateListener;
    private EnumMap<EntityListenerType, List<EntityListener<T>>> listeners = null;

    EntityListenerMap() {
    }

    synchronized void add(EntityListenerType type, EntityListener<T> listener) {
        List<EntityListener<T>> ls;
        if (this.listeners == null) {
            this.listeners = new EnumMap(EntityListenerType.class);
        }
        if ((ls = this.listeners.get((Object)type)) == null) {
            ls = new ArrayList<EntityListener<T>>();
            this.listeners.put(type, ls);
        }
        if (!ls.contains(listener)) {
            ls.add(listener);
        }
        if (listener instanceof EntityListener.Update) {
            this.hasUpdateListener = true;
        }
    }

    boolean apply(EnumSet<EntityListenerType> types, T instance) {
        return this.doApply(this.getAll(types), null, instance);
    }

    boolean apply(EntityListenerType type, T instance) {
        List<EntityListener<T>> ls;
        return this.listeners == null || (ls = this.listeners.get((Object)type)) == null || this.doApply(ls, null, instance);
    }

    boolean apply(EnumSet<EntityListenerType> types, @Nullable T oldInstance, T newInstance) {
        return this.doApply(this.getAll(types), oldInstance, newInstance);
    }

    boolean hasUpdateListener() {
        return this.hasUpdateListener;
    }

    synchronized void remove(EntityListenerType type, EntityListener<T> listener) {
        List<EntityListener<T>> ls;
        if (this.listeners != null && (ls = this.listeners.get((Object)type)) != null) {
            ls.remove(listener);
            if (listener instanceof EntityListener.Update) {
                this.hasUpdateListener = Colls.exists(ls, l -> l instanceof EntityListener.Update);
            }
        }
    }

    synchronized void removeAll() {
        this.listeners = null;
    }

    synchronized void removeAll(EntityListenerType type) {
        if (this.listeners != null) {
            this.listeners.remove((Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doApply(List<EntityListener<T>> ls, @Nullable T oldInstance, T newInstance) {
        if (ls.isEmpty()) {
            return true;
        }
        Set<T> actives = this.activeInstances.get();
        if (!actives.add(newInstance)) {
            return false;
        }
        try {
            boolean bl = this.invokeAll(ls, oldInstance, newInstance);
            return bl;
        }
        finally {
            actives.remove(newInstance);
        }
    }

    private boolean invokeAll(List<EntityListener<T>> ls, @Nullable T oldInstance, T instance) {
        for (EntityListener<T> l : ls) {
            boolean vetted = !(oldInstance == null || !(l instanceof EntityListener.Update) ? l.invoke(instance) : ((EntityListener.Update)l).invoke(oldInstance, instance));
            if (!vetted) continue;
            return false;
        }
        return true;
    }

    private List<EntityListener<T>> getAll(EnumSet<EntityListenerType> types) {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        List<EntityListener<T>> result = Collections.emptyList();
        int sets = 0;
        for (EntityListenerType type : types) {
            List<EntityListener<T>> ls = this.listeners.get((Object)type);
            if (ls == null) continue;
            if (sets == 0) {
                result = ls;
            } else {
                if (sets == 1) {
                    result = new ArrayList<EntityListener<T>>(result);
                }
                result.addAll(ls);
            }
            ++sets;
        }
        return result;
    }
}

