/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.common.util.Reflection;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntitySeq;
import mulesoft.persistence.EntityTable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRef<T extends EntityInstance<T, K>, K> {
    private final Function<T, EntitySeq<?>> getReverseRef;
    private SoftReference<Option<T>> referenceHolder;
    @NotNull
    private final EntityTable<T, K> table;

    public EntityRef(DbTable<T, K> dbTable) {
        this(dbTable, null);
    }

    public EntityRef(@NotNull DbTable<T, K> table, @Nullable Function<T, EntitySeq<?>> getReverseRef) {
        this.table = table.entityTable();
        this.getReverseRef = getReverseRef;
        this.referenceHolder = new SoftReference<Object>(null);
    }

    public static <C extends EntityInstance<C, CK>, CK, P extends EntityInstance<P, PK>, PK> Function<C, EntityRef<P, PK>> getRefFunction(Class<C> childClass, String reverseFieldName) {
        Field refField = Reflection.findFieldOrFail(childClass, (String)reverseFieldName);
        return c -> (EntityRef)Predefined.ensureNotNull((Object)Reflection.getFieldValue((Object)c, (Field)refField), (String)"Cannot get reverse field value");
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    public T initialize(@Nullable T ref) {
        this.referenceHolder = new SoftReference<Option>(Option.option(ref));
        return ref;
    }

    public synchronized void invalidate() {
        this.referenceHolder.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@Nullable T newRef) {
        Option<T> r = this.referenceHolder.get();
        if (r != null && r.getOrNull() == newRef) {
            return;
        }
        EntityRef entityRef = this;
        synchronized (entityRef) {
            Option<T> ref = this.referenceHolder.get();
            if (ref != null && ref.getOrNull() == newRef) {
                return;
            }
            if (this.getReverseRef != null) {
                if (ref != null && ref.isPresent()) {
                    this.getReverseRef.apply(ref.get()).invalidate();
                }
                if (newRef != null) {
                    this.getReverseRef.apply(newRef).invalidate();
                }
            }
            this.initialize(newRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T solve(@Nullable K key) {
        Option<T> r = this.referenceHolder.get();
        if (r != null) {
            return (T)((EntityInstance)r.getOrNull());
        }
        EntityRef entityRef = this;
        synchronized (entityRef) {
            Option<T> ref = this.referenceHolder.get();
            return (T)(ref != null ? (EntityInstance)ref.getOrNull() : this.initialize(key == null ? null : (T)this.table.find(key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T solveOrFail(@NotNull K key) {
        Option<T> r = this.referenceHolder.get();
        if (r != null && r.isPresent()) {
            return (T)((EntityInstance)r.get());
        }
        EntityRef entityRef = this;
        synchronized (entityRef) {
            Option<T> ref = this.referenceHolder.get();
            return (T)(ref != null && ref.isPresent() ? (EntityInstance)ref.get() : this.initialize(this.table.findOrFail(key)));
        }
    }

    public boolean isUndefined() {
        return this.referenceHolder.get() == null;
    }
}

