/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.function.Function;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityRef;
import mulesoft.persistence.EntitySeqImpl;
import mulesoft.persistence.InnerEntitySeq;
import mulesoft.persistence.InnerEntitySeqForUpdate;
import mulesoft.persistence.InnerEntitySeqImpl;
import mulesoft.persistence.InnerInstance;
import mulesoft.persistence.TableField;
import org.jetbrains.annotations.NotNull;

public interface EntitySeq<E extends EntityInstance<E, ?>>
extends Seq<E> {
    public E get(int var1);

    public void invalidate();

    public boolean isUndefined();

    @NotNull
    public static <C extends EntityInstance<C, CK>, CK, P extends EntityInstance<P, PK>, PK> EntitySeq<C> createEntitySeq(@NotNull DbTable<C, CK> table, @NotNull P owner, @NotNull Function<C, EntityRef<P, PK>> getParentRef, ImmutableList<TableField<?>> foreignColumns) {
        return new EntitySeqImpl<C, CK, P, PK>(table, owner, getParentRef, foreignColumns);
    }

    @NotNull
    public static <C extends InnerInstance<C, CK, P, PK>, CK, P extends EntityInstance<P, PK>, PK> InnerEntitySeq<C> createInnerEntitySeq(@NotNull DbTable<C, CK> table, @NotNull P parent, @NotNull Function<C, EntityRef<P, PK>> getParentRef) {
        return new InnerEntitySeqImpl.Base<C, CK, P, PK>(table, parent, getParentRef);
    }

    @NotNull
    public static <UC extends C, C extends InnerInstance<C, CK, P, PK>, CK, P extends EntityInstance<P, PK>, PK> InnerEntitySeqForUpdate<UC, C> createInnerEntitySeq(Function<C, UC> forUpdate, @NotNull DbTable<C, CK> table, @NotNull P parent, @NotNull Function<C, EntityRef<P, PK>> getParentRef) {
        return new InnerEntitySeqImpl.ForUpdate<UC, C, CK, P, PK>(forUpdate, table, parent, getParentRef);
    }

    public static interface Inner<E extends EntityInstance<E, ?>>
    extends EntitySeq<E> {
        public void deleteAll();

        public void persist();
    }
}

