/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Tuple;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityRef;
import mulesoft.persistence.EntitySeq;
import mulesoft.persistence.Sql;
import mulesoft.persistence.TableField;
import mulesoft.persistence.expr.Expr;
import org.jetbrains.annotations.NotNull;

public final class EntitySeqImpl<C extends EntityInstance<C, K>, K, P extends EntityInstance<P, PK>, PK>
implements EntitySeq<C> {
    private final List<C> current = new ArrayList<C>();
    private final Function<C, EntityRef<P, PK>> getParentRef;
    private final ImmutableList<TableField<?>> keyFields;
    private final P owner;
    @NotNull
    private final transient DbTable<C, K> table;
    private boolean unDefined = true;

    EntitySeqImpl(@NotNull DbTable<C, K> table, P owner, @NotNull Function<C, EntityRef<P, PK>> getParentRef, ImmutableList<TableField<?>> foreignColumns) {
        this.table = table;
        this.owner = owner;
        this.keyFields = foreignColumns;
        this.getParentRef = getParentRef;
    }

    @Override
    public C get(int index) {
        return (C)((EntityInstance)this.getCurrent().get(index));
    }

    @Override
    public void invalidate() {
        this.unDefined = true;
    }

    @NotNull
    public ImmutableIterator<C> iterator() {
        return Colls.immutable(this.getCurrent().iterator());
    }

    public int size() {
        return this.getCurrent().size();
    }

    public String toString() {
        return this.unDefined ? "undefined" : Colls.mkString(this.getCurrent());
    }

    @Override
    public boolean isUndefined() {
        return this.unDefined;
    }

    public boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    private synchronized void solve() {
        if (this.unDefined) {
            this.current.clear();
            Criteria p = Criteria.allOf((Iterable<Criteria>)this.keyFields.zipWith((a, b) -> a.eq(Expr.constant(b)), (Seq)Tuple.asList(this.owner.keyObject())));
            Sql.selectFrom(this.table).where(p).forEach(c -> {
                this.getParentRef.apply(c).initialize(this.owner);
                this.current.add(c);
            });
        }
        this.unDefined = false;
    }

    private List<C> getCurrent() {
        if (this.unDefined) {
            this.solve();
        }
        return this.current;
    }
}

