/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.util.Reflection;
import mulesoft.database.Database;
import mulesoft.database.Databases;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityInstanceBaseImpl;
import mulesoft.persistence.EntityListener;
import mulesoft.persistence.EntityListenerMap;
import mulesoft.persistence.EntityListenerType;
import mulesoft.persistence.EntitySeq;
import mulesoft.persistence.InnerEntitySeq;
import mulesoft.persistence.PersistableInstance;
import mulesoft.persistence.Select;
import mulesoft.persistence.Sql;
import mulesoft.persistence.StoreHandler;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableMetadata;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTable<T extends EntityInstance<T, K>, K> {
    private static final int MAX_ENTITY_LENGTH = 50;
    @NotNull
    private final DbTable<T, K> dbTable;
    @NotNull
    private final QName entityName;
    @NotNull
    private final LinkedHashMap<String, TableField<?>> fields;
    private final EntityListenerMap<T> listeners;
    private final TableMetadata<T, K> metadata;
    private StoreHandler<T, K> storeHandler;
    private boolean supportsMerge;
    private static final EnumSet<EntityListenerType> BEFORE_PERSIST_OR_INSERT = EnumSet.of(EntityListenerType.BEFORE_PERSIST, EntityListenerType.BEFORE_INSERT);
    private static final EnumSet<EntityListenerType> AFTER_PERSIST_OR_INSERT = EnumSet.of(EntityListenerType.AFTER_PERSIST, EntityListenerType.AFTER_INSERT);
    private static final EnumSet<EntityListenerType> BEFORE_PERSIST_OR_UPDATE = EnumSet.of(EntityListenerType.BEFORE_PERSIST, EntityListenerType.BEFORE_UPDATE);
    private static final EnumSet<EntityListenerType> AFTER_PERSIST_OR_UPDATE = EnumSet.of(EntityListenerType.AFTER_PERSIST, EntityListenerType.AFTER_UPDATE);
    public static final Integer DEFAULT_EMPTY_KEY = -1;

    public EntityTable(@NotNull DbTable<T, K> dbTable) {
        this.dbTable = dbTable;
        this.metadata = dbTable.metadata();
        this.fields = new LinkedHashMap(dbTable.metadata().fieldMap());
        this.entityName = this.metadata.getTypeQName();
        this.storeHandler = null;
        this.listeners = new EntityListenerMap();
    }

    public void addListener(EntityListenerType listenerType, EntityListener<T> listener) {
        this.listeners.add(listenerType, listener);
    }

    public boolean checkAndLock(@NotNull K key, DateTime updateTime) {
        return this.storeHandler.checkAndLock(key, updateTime);
    }

    public T delete(@NotNull T instance) {
        this.deleteInternal(instance, true);
        return instance;
    }

    public void deleteKeys(Iterable<K> keys) {
        this.storeHandler.delete(keys);
    }

    @Nullable
    public T find(@NotNull K key) {
        return this.storeHandler.find(key);
    }

    @Nullable
    public T findByKey(int keyId, @NotNull Object key) {
        this.metadata.validateKeyId(keyId);
        return this.storeHandler.findByKey(keyId, key);
    }

    @Nullable
    public T findByString(@NotNull String key) {
        return this.find(this.metadata.keyFromString(key));
    }

    public final T findOrCreate(@NotNull K key) {
        T result = this.find(key);
        return result != null ? result : this.metadata.createInstance(key);
    }

    @NotNull
    public T findOrCreateByString(@NotNull String key) {
        return this.findOrCreate(this.metadata.keyFromString(key));
    }

    @NotNull
    public T findOrFail(@NotNull K key) {
        return this.storeHandler.findOrFail(key);
    }

    @Nullable
    public T findPersisted(@NotNull K key) {
        return this.storeHandler.findPersisted(key);
    }

    @Nullable
    public T findPersistedOrFail(@NotNull K key) {
        return this.storeHandler.findPersistedOrFail(key);
    }

    @Nullable
    public T findWhere(@NotNull Criteria criteria) {
        return (T)((EntityInstance)Sql.selectFrom(this.dbTable).where(criteria).get());
    }

    public T forcePersist(@NotNull T instance) {
        this.persist(instance, false);
        return instance;
    }

    public T forceUpdate(@NotNull T instance) {
        return this.update(null, instance, false);
    }

    public EntityTable<T, K> init(StoreHandler<?, ?> sh) {
        this.storeHandler = (StoreHandler)Predefined.cast(sh);
        this.supportsMerge = this.storeHandler.supportsMerge();
        return this;
    }

    public T insert(@NotNull T instance) {
        return this.doInsert(instance, this.metadata.hasGeneratedKey());
    }

    public void insertDoNotGenerate(@NotNull T instance) {
        this.doInsert(instance, false);
    }

    @NotNull
    public ImmutableList<T> list(Set<K> keys) {
        return this.storeHandler.list(keys);
    }

    @NotNull
    public ImmutableList<T> listFromStringKeys(Iterable<String> keys) {
        return this.storeHandler.list((Iterable<K>)Colls.map(keys, this.metadata::keyFromString));
    }

    public T merge(@NotNull T instance) {
        if (this.supportsMerge) {
            this.metadata.updateAuditFields(instance, true, false, false);
            this.storeHandler.merge(instance);
            this.resetModified(instance);
        } else {
            this.persist(instance);
        }
        return instance;
    }

    public T persist(@NotNull T instance) {
        return this.persist(instance, this.metadata.hasModifier(Modifier.OPTIMISTIC_LOCKING));
    }

    public void removeListener(EntityListenerType listenerType, EntityListener<T> listener) {
        this.listeners.remove(listenerType, listener);
    }

    public void resetIdentitySequence() {
        if (this.metadata.hasGeneratedKey()) {
            this.getDatabase().resetIdentitySequence(this.metadata.getTableQName(), this.metadata.getSequenceName());
        }
    }

    public Select<T> selectFrom() {
        return new Select.Builder<T>(this.metadata.getType(), Select.EMPTY_EXPR).from(this.dbTable);
    }

    public String toString() {
        return this.getEntityName().toString();
    }

    public T update(@NotNull T instance) {
        return this.update(null, instance, this.metadata.hasModifier(Modifier.OPTIMISTIC_LOCKING));
    }

    public void updateLastDeleted(DateTime lastDeleted) {
        DateTime last = lastDeleted.addMilliseconds(1L);
        String entity = Strings.truncate((String)this.getEntityName().getFullName(), (int)50);
        Integer count = this.getDatabase().sqlStatement("select count(*) from %s.LAST_DELETED where ENTITY = ?", new Object[]{"Schema(SG)"}).onArgs(new Object[]{entity}).getInt();
        if (count == null || count == 0) {
            this.getDatabase().sqlStatement("insert into %s.LAST_DELETED values (?,?)", new Object[]{"Schema(SG)"}).onArgs(new Object[]{entity, last}).execute();
        } else {
            this.getDatabase().sqlStatement("update %s.LAST_DELETED set TS = ? where ENTITY = ?", new Object[]{"Schema(SG)"}).onArgs(new Object[]{last, entity}).execute();
        }
    }

    @Nullable
    public DateTime updateTime(@NotNull K key) {
        return this.storeHandler.updateTime(key);
    }

    @NotNull
    public DbTable<T, K> getDbTable() {
        return this.dbTable;
    }

    @NotNull
    public QName getEntityName() {
        return this.entityName;
    }

    public ImmutableCollection<TableField<?>> getFields() {
        return (ImmutableCollection)Predefined.cast((Object)Colls.immutable(this.fields.values()));
    }

    public Map<String, InnerEntitySeq<?>> getInners(T instance) {
        HashMap map = new HashMap();
        for (Field inner : this.metadata.getInnerFields()) {
            InnerEntitySeq seq = (InnerEntitySeq)Reflection.getNotNullFieldValue(instance, (Field)inner);
            map.put(inner.getName(), seq);
        }
        return map;
    }

    public TableMetadata<T, K> getMetadata() {
        return this.metadata;
    }

    void deleteInternal(T instance, boolean deleteInners) {
        if (this.listeners.apply(EntityListenerType.BEFORE_DELETE, instance)) {
            if (deleteInners) {
                this.persistInners(instance, true);
            }
            this.storeHandler.delete(instance);
            this.listeners.apply(EntityListenerType.AFTER_DELETE, instance);
        }
    }

    T doInsert(T instance, boolean generateKey) {
        if (this.listeners.apply(BEFORE_PERSIST_OR_INSERT, instance)) {
            this.metadata.updateAuditFields(instance, true, false, false);
            this.storeHandler.insert(instance, generateKey);
            this.persistInners(instance, false);
            this.listeners.apply(AFTER_PERSIST_OR_INSERT, instance);
            this.resetModified(instance);
        }
        return instance;
    }

    void persistInners(T instance, boolean delete) {
        for (Field inner : this.metadata.getInnerFields()) {
            EntitySeq.Inner seq = (EntitySeq.Inner)Reflection.getNotNullFieldValue(instance, (Field)inner);
            if (delete) {
                seq.deleteAll();
                continue;
            }
            seq.persist();
        }
    }

    String storeType() {
        return "";
    }

    Database getDatabase() {
        return this.storeHandler.getDatabase();
    }

    StoreHandler<T, K> getStoreHandler() {
        return this.storeHandler;
    }

    private T persist(@NotNull T instance, boolean lock) {
        Object key = instance.keyObject();
        if (!(instance instanceof PersistableInstance)) {
            throw new IllegalArgumentException();
        }
        if (this.metadata.hasGeneratedKey()) {
            PersistableInstance p = (PersistableInstance)Predefined.cast(instance);
            if (key.equals(DEFAULT_EMPTY_KEY)) {
                p.insert();
            } else {
                p.update();
            }
        } else {
            T oldInstance = this.findPersisted(key);
            if (oldInstance == null) {
                this.insert(instance);
            } else {
                this.update(oldInstance, instance, lock);
            }
        }
        return instance;
    }

    private void resetModified(@NotNull T instance) {
        if (instance instanceof EntityInstanceBaseImpl) {
            ((EntityInstanceBaseImpl)instance).resetModified();
        }
    }

    private T update(@Nullable T oldInstance, @NotNull T newInstance, boolean lock) {
        T old;
        T t = old = oldInstance == null && this.listeners.hasUpdateListener() ? this.storeHandler.findPersistedOrFail(newInstance.keyObject()) : oldInstance;
        if (this.listeners.apply(BEFORE_PERSIST_OR_UPDATE, old, newInstance)) {
            this.metadata.updateAuditFields(newInstance, false, false, false);
            if (lock) {
                this.storeHandler.updateLocking(newInstance);
            } else {
                this.storeHandler.update(newInstance);
            }
            this.persistInners(newInstance, false);
            this.listeners.apply(AFTER_PERSIST_OR_UPDATE, old, newInstance);
            this.resetModified(newInstance);
        }
        return newInstance;
    }

    @Nullable
    public static <T extends EntityInstance<T, ?>> T findInstance(String entityName, String key) {
        return (T)((EntityInstance)Predefined.cast(EntityTable.forName(entityName).findByString(key)));
    }

    public static <T extends EntityInstance<T, K>, K> EntityTable<T, K> forName(String entityName) {
        DbTable dt = DbTable.forName(entityName);
        return dt.entityTable();
    }

    public static <T extends EntityInstance<T, K>, K> EntityTable<T, K> forTable(DbTable<T, K> dbTable) {
        return dbTable.entityTable();
    }

    @Nullable
    public static DateTime lastDeletedTime(String entityNameFullName) {
        return (DateTime)Databases.openDefault().sqlStatement("select max(TS) from QName(SG,LAST_DELETED) where ENTITY = '%s'", new Object[]{Strings.truncate((String)entityNameFullName, (int)50)}).get(DateTime.class);
    }

    public static interface DeleteListener<T> {
        public void after(T var1);

        public void before(T var1);
    }
}

