/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import mulesoft.common.env.Environment;
import mulesoft.common.env.context.Context;
import mulesoft.common.env.impl.PropertiesEnvironment;
import mulesoft.database.DatabaseConfig;
import mulesoft.database.DatabaseFactory;
import mulesoft.database.hikari.HikariDatabaseConfig;
import mulesoft.database.hikari.HikariDatabaseFactory;
import mulesoft.persistence.DbStoreHandlerFactory;
import mulesoft.persistence.TableFactory;
import mulesoft.persistence.sql.SqlStoreHandlerFactory;
import mulesoft.transaction.JDBCTransactionManager;
import mulesoft.transaction.Transaction;
import mulesoft.transaction.TransactionManager;

public class Hermes {
    public static void initHermes() {
        PropertiesEnvironment env = new PropertiesEnvironment();
        Hermes.initHermes((Environment)env);
    }

    public static void initHermes(Environment env) {
        Context.getContext().setSingleton(Environment.class, (Object)env);
        HikariDatabaseFactory dbFactory = new HikariDatabaseFactory(env, (TransactionManager)new JDBCTransactionManager());
        HikariDatabaseConfig cfg = (HikariDatabaseConfig)env.get(HikariDatabaseConfig.class);
        Context.getContext().setSingleton(DatabaseFactory.class, (Object)dbFactory);
        Context.getContext().setSingleton(TransactionManager.class, (Object)dbFactory.getTransactionManager());
        Transaction.runInTransaction(() -> dbFactory.initialize("", (DatabaseConfig)cfg, false, new String[0]));
        Hermes.initializeTableFactoryAndCacheManager(dbFactory);
    }

    private static void initializeTableFactoryAndCacheManager(DatabaseFactory<?> dbFactory) {
        SqlStoreHandlerFactory sqlStoreHandlerFactory = new SqlStoreHandlerFactory(dbFactory);
        DbStoreHandlerFactory storeHandlerFactory = new DbStoreHandlerFactory(sqlStoreHandlerFactory);
        TableFactory.setFactory(new TableFactory(storeHandlerFactory));
    }
}

