/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.core.Tuple;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityRef;
import mulesoft.persistence.EntitySeq;
import mulesoft.persistence.InnerEntitySeq;
import mulesoft.persistence.InnerEntitySeqForUpdate;
import mulesoft.persistence.InnerEntityTable;
import mulesoft.persistence.InnerInstance;
import mulesoft.persistence.Sql;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InnerEntitySeqImpl<UC extends C, C extends InnerInstance<C, CK, P, PK>, CK, P extends EntityInstance<P, PK>, PK>
implements EntitySeq.Inner<C> {
    private final List<UC> current = new ArrayList<UC>();
    private final DbTable<C, CK> dbTable;
    @NotNull
    private final InnerEntityTable<C, CK, P, PK> et;
    private final Function<C, UC> forUpdate;
    private final Function<C, EntityRef<P, PK>> getParentRef;
    @NotNull
    private List<UC> original;
    @NotNull
    private final P parent;
    private boolean unDefined = true;

    InnerEntitySeqImpl(Function<C, UC> forUpdate, DbTable<C, CK> dbTable, @NotNull P parent, @NotNull Function<C, EntityRef<P, PK>> getParentRef) {
        this.getParentRef = getParentRef;
        this.et = (InnerEntityTable)Predefined.cast(dbTable.entityTable());
        this.dbTable = dbTable;
        this.parent = parent;
        this.original = this.current;
        this.forUpdate = forUpdate;
    }

    @Override
    public synchronized void deleteAll() {
        if (this.unDefined) {
            this.solve();
        }
        for (InnerInstance e : this.original) {
            this.et.deleteInternal(e, true);
        }
        this.current.clear();
        this.attachCurrent();
    }

    @Override
    public C get(int index) {
        return (C)((InnerInstance)this.getCurrent().get(index));
    }

    @Override
    public void invalidate() {
        this.unDefined = true;
    }

    @NotNull
    public ImmutableIterator<C> iterator() {
        return (ImmutableIterator)Predefined.cast((Object)Colls.immutable(this.getCurrent().iterator()));
    }

    @Override
    public synchronized void persist() {
        if (this.unDefined) {
            return;
        }
        if (this.getCurrent() == this.original) {
            this.updateModified();
            return;
        }
        for (InnerInstance orig : this.original) {
            if (this.current.contains(orig)) continue;
            this.et.deleteInternal(orig, true);
        }
        for (InnerInstance t : this.current) {
            if (!this.original.contains(t)) {
                this.updateKey(t, t.seqId());
                this.et.doInsert(t, false);
                continue;
            }
            this.et.update(t);
        }
        this.attachCurrent();
    }

    public int size() {
        return this.getCurrent().size();
    }

    public String toString() {
        return this.unDefined ? "undefined" : Colls.mkString(this.getCurrent());
    }

    @Override
    public boolean isUndefined() {
        return this.unDefined;
    }

    public boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    @NotNull
    synchronized UC add() {
        this.solve();
        this.detachCurrent();
        return this.createNew();
    }

    C delete(C instance) {
        this.et.deleteInternal(instance, true);
        int seqId = instance.seqId();
        this.original.removeIf(c -> c.seqId() == seqId);
        if (this.original != this.current) {
            this.current.removeIf(c -> c.seqId() == seqId);
        }
        return instance;
    }

    <S> void merge3(Iterable<S> newValues, BiPredicate<C, S> matchPredicate, BiConsumer<UC, S> matchAction, Predicate<UC> deleteAction, BiConsumer<Supplier<UC>, S> createAction) {
        this.solve();
        ArrayList values = (ArrayList)Colls.into(newValues, new ArrayList());
        this.detachCurrent();
        Iterator<UC> iterator = this.current.iterator();
        while (iterator.hasNext()) {
            InnerInstance element = (InnerInstance)iterator.next();
            S s = this.findMatchingElement(values, element, matchPredicate);
            if (s != null) {
                matchAction.accept(element, s);
                continue;
            }
            if (!deleteAction.test(element)) continue;
            iterator.remove();
        }
        for (Object v : values) {
            createAction.accept(this::createNew, v);
        }
    }

    synchronized <S> void mergeSequentially(Iterable<S> newValues, BiConsumer<UC, S> action) {
        this.solve();
        this.detachCurrent();
        int i = 0;
        int size = this.current.size();
        for (S v : newValues) {
            if (i >= size) {
                this.createNew();
            }
            action.accept(this.current.get(i++), v);
        }
        for (int j = size - 1; j >= i; --j) {
            this.current.remove(j);
        }
    }

    UC persist(UC instance, boolean failIfExists) {
        int index = Colls.indexOf(this.original, c -> c.seqId() == instance.seqId());
        if (index != -1) {
            if (failIfExists) {
                throw new IllegalStateException("Inserting existing record");
            }
            this.et.update(instance);
            this.updateCurrent(instance);
        } else {
            this.et.doInsert(instance, false);
            if (this.current == this.original) {
                this.invalidate();
            } else {
                this.updateCurrent(instance);
                this.original.add(instance);
            }
        }
        return instance;
    }

    synchronized void solve() {
        if (this.unDefined) {
            this.current.clear();
            for (InnerInstance element : Sql.selectFrom(this.dbTable).where(this.dbTable.metadata().buildKeyCriteria(Tuple.asList(this.parent.keyObject()))).sorted(Comparator.comparingInt(c -> c.seqId())).map(this.forUpdate)) {
                this.getParentRef.apply(element).initialize(this.parent);
                this.current.add(element);
            }
            this.attachCurrent();
            this.unDefined = false;
        }
    }

    private void attachCurrent() {
        this.original = this.current;
    }

    private UC createNew() {
        InnerInstance element = (InnerInstance)this.forUpdate.apply(this.dbTable.metadata().createInstance());
        int last = this.current.size() - 1;
        this.updateKey(element, last == -1 ? 1 : ((InnerInstance)this.current.get(last)).seqId() + 1);
        this.getParentRef.apply(element).initialize(this.parent);
        this.current.add(element);
        return (UC)element;
    }

    private List<UC> detachCurrent() {
        if (this.current == this.original) {
            this.original = new ArrayList<UC>(this.original);
        }
        return this.current;
    }

    @Nullable
    private <S> S findMatchingElement(ArrayList<S> values, C element, BiPredicate<C, S> matchPredicate) {
        Iterator<S> iterator = values.iterator();
        while (iterator.hasNext()) {
            S value = iterator.next();
            if (!matchPredicate.test(element, value)) continue;
            iterator.remove();
            return value;
        }
        return null;
    }

    private void updateCurrent(UC instance) {
        int currentIndex = Colls.indexOf(this.current, c -> c.seqId() == instance.seqId());
        if (currentIndex != -1) {
            this.current.set(currentIndex, instance);
        } else {
            this.current.add(instance);
        }
    }

    private void updateKey(C element, int seqId) {
        this.et.getMetadata().setKey(element, Tuple.createAppending(this.parent.keyObject(), (Object)seqId));
    }

    private void updateModified() {
        for (InnerInstance t : this.current) {
            if (!t.modified()) continue;
            this.et.update(t);
        }
    }

    private List<UC> getCurrent() {
        if (this.unDefined) {
            this.solve();
        }
        return this.current;
    }

    static class ForUpdate<UC extends C, C extends InnerInstance<C, CK, P, PK>, CK, P extends EntityInstance<P, PK>, PK>
    extends InnerEntitySeqImpl<UC, C, CK, P, PK>
    implements InnerEntitySeqForUpdate<UC, C> {
        ForUpdate(Function<C, UC> forUpdate, DbTable<C, CK> dbTable, @NotNull P parent, @NotNull Function<C, EntityRef<P, PK>> getParentRef) {
            super(forUpdate, dbTable, parent, getParentRef);
        }

        @Override
        @NotNull
        public UC add() {
            return super.add();
        }

        @Override
        public <S> InnerEntitySeqForUpdate<UC, C> merge(Iterable<S> newValues, BiConsumer<UC, S> action) {
            this.mergeSequentially(newValues, action);
            return this;
        }

        @Override
        public <S> InnerEntitySeqForUpdate<UC, C> mergeMatching(Iterable<S> newValues, BiPredicate<C, S> matchPredicate, BiConsumer<UC, S> matchAction, Predicate<UC> deleteAction, BiConsumer<Supplier<UC>, S> createAction) {
            this.merge3(newValues, matchPredicate, matchAction, deleteAction, createAction);
            return this;
        }
    }

    static class Base<C extends InnerInstance<C, CK, P, PK>, CK, P extends EntityInstance<P, PK>, PK>
    extends InnerEntitySeqImpl<C, C, CK, P, PK>
    implements InnerEntitySeq<C> {
        Base(DbTable<C, CK> dbTable, @NotNull P parent, @NotNull Function<C, EntityRef<P, PK>> getParentRef) {
            super(Function.identity(), dbTable, parent, getParentRef);
        }

        @Override
        @NotNull
        public C add() {
            return (C)super.add();
        }

        @Override
        public <S> InnerEntitySeq<C> merge(Iterable<S> newValues, BiConsumer<C, S> action) {
            this.mergeSequentially(newValues, action);
            return this;
        }

        @Override
        public <S> InnerEntitySeq<C> mergeMatching(Iterable<S> newValues, BiPredicate<C, S> matchPredicate, BiConsumer<C, S> matchAction, Predicate<C> deleteAction, BiConsumer<Supplier<C>, S> createAction) {
            this.merge3(newValues, matchPredicate, matchAction, deleteAction, createAction);
            return this;
        }
    }
}

