/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import mulesoft.common.Predefined;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.InnerEntitySeqImpl;
import mulesoft.persistence.InnerInstance;
import org.jetbrains.annotations.NotNull;

public class InnerEntityTable<T extends InnerInstance<T, K, P, PK>, K, P extends EntityInstance<P, PK>, PK>
extends EntityTable<T, K> {
    public InnerEntityTable(DbTable<T, K> dbTable) {
        super(dbTable);
    }

    @Override
    public T delete(@NotNull T instance) {
        if (instance.parent().isUndefined() || instance.siblings().isUndefined()) {
            super.delete(instance);
        } else {
            this.siblingsImpl(instance).delete(instance);
        }
        return instance;
    }

    @Override
    public T insert(@NotNull T instance) {
        if (instance.parent().isUndefined() || instance.siblings().isUndefined()) {
            super.insert(instance);
        } else {
            this.siblingsImpl(instance).persist(instance, true);
        }
        return instance;
    }

    @Override
    public T persist(@NotNull T instance) {
        if (instance.parent().isUndefined() || instance.siblings().isUndefined()) {
            super.persist(instance);
        } else {
            this.siblingsImpl(instance).persist(instance, false);
        }
        return instance;
    }

    @NotNull
    private InnerEntitySeqImpl<T, T, K, P, PK> siblingsImpl(@NotNull T instance) {
        return (InnerEntitySeqImpl)Predefined.cast(instance.siblings());
    }
}

