/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.Option;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Strings;
import mulesoft.common.util.Reflection;
import mulesoft.database.Database;
import mulesoft.database.RowMapper;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.TableField;
import mulesoft.persistence.expr.Expr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryTuple {
    private final Expr<?>[] expressions;

    private QueryTuple(Expr<?>[] es) {
        this.expressions = es;
    }

    @Nullable
    public <T> T get(Expr<T> expr) {
        for (int i = 0; i < this.expressions.length; ++i) {
            if (!this.expressions[i].equals(expr)) continue;
            return this.get(i + 1);
        }
        throw new IllegalArgumentException("Invalid Expression " + expr);
    }

    @Nullable
    public abstract <T> T get(int var1);

    @NotNull
    public <I extends EntityInstance<I, K>, K> Option<I> get(DbTable<I, K> table) {
        EntityTable<I, K> et = table.entityTable();
        HashMap<TableField, Object> valueMap = new HashMap<TableField, Object>();
        for (int i = 0; i < this.expressions.length; ++i) {
            Expr<?> e = this.expressions[i];
            if (!(e instanceof TableField)) continue;
            TableField tf2 = (TableField)Predefined.cast(e);
            if (!table.alias().equals(tf2.alias()) || !tf2.entityTable().equals(et)) continue;
            valueMap.put(tf2, this.get(i + 1));
        }
        if (Colls.forAll(valueMap.values(), Objects::isNull)) {
            return Option.empty();
        }
        try {
            Object result = table.metadata().createInstance();
            valueMap.forEach((tf, v) -> tf.setValue(result, v));
            return Option.of(result);
        }
        catch (IllegalArgumentException e) {
            return Option.empty();
        }
    }

    public int size() {
        return this.expressions.length;
    }

    public Object[] toArray() {
        Object[] a = new Object[this.expressions.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i + 1);
        }
        return a;
    }

    public ImmutableList<Object> toList() {
        ImmutableList.Builder b = ImmutableList.builder((int)this.expressions.length);
        for (int i = 0; i < this.expressions.length; ++i) {
            b.add(this.get(i + 1));
        }
        return b.build();
    }

    public String toString() {
        StrBuilder b = new StrBuilder();
        for (int i = 0; i < this.expressions.length; ++i) {
            b.appendElement((Object)(QueryTuple.exprOrFieldName(this.expressions[i], i) + "=" + this.get(i + 1)));
        }
        return b.toString();
    }

    public int getInt(Expr.Int expr) {
        return this.getOrFail(expr);
    }

    @NotNull
    public <T> Option<T> getOption(Expr<T> expr) {
        return Option.ofNullable(this.get(expr));
    }

    @NotNull
    public <T> T getOrFail(int columnNumber) {
        return (T)Predefined.ensureNotNull(this.get(columnNumber), () -> new IllegalArgumentException("Null value for column number: " + columnNumber));
    }

    @NotNull
    public <T> T getOrFail(Expr<T> expr) {
        return (T)Predefined.ensureNotNull(this.get(expr), () -> new IllegalArgumentException("Null value for: " + expr));
    }

    public static <I extends EntityInstance<I, K>, K> Function<I, QueryTuple> fromEntityInstance(final Expr<?>[] expressions) {
        return new Function<I, QueryTuple>(){

            @Override
            public QueryTuple apply(I instance) {
                return new ArrayQueryTuple(expressions, this.getObjects(instance));
            }

            private Object[] getObjects(I instance) {
                Object[] vs = new Object[expressions.length];
                for (int i = 0; i < expressions.length; ++i) {
                    Expr e = expressions[i];
                    if (!(e instanceof TableField)) continue;
                    TableField tf = (TableField)Predefined.cast((Object)e);
                    vs[i] = tf.getValue(instance);
                }
                return vs;
            }
        };
    }

    public static QueryTuple fromResultSet(final ResultSet rs, final Expr<?>[] expressions, final @Nullable Database db) {
        return new QueryTuple(expressions){

            @Override
            @Nullable
            public <T> T get(int columnNumber) {
                try {
                    return (T)Predefined.cast(expressions[columnNumber - 1].getValueFromResultSet(rs, columnNumber));
                }
                catch (SQLException e) {
                    if (db == null) {
                        throw new RuntimeException(e);
                    }
                    throw db.getDatabaseType().getSqlExceptionTranslator().translate(e);
                }
            }
        };
    }

    public static <R> RowMapper<R> rowMapper(Class<R> type, final Expr<?>[] expressions) {
        if (type.equals(QueryTuple.class)) {
            return (RowMapper)Predefined.cast((Object)new RowMapper<QueryTuple>(){

                public QueryTuple mapRow(ResultSet rs) throws SQLException {
                    return new ArrayQueryTuple(expressions, this.getObjects(rs));
                }

                private Object[] getObjects(ResultSet rs) throws SQLException {
                    Object[] vs = new Object[expressions.length];
                    for (int i = 0; i < expressions.length; ++i) {
                        vs[i] = expressions[i].getValueFromResultSet(rs, i + 1);
                    }
                    return vs;
                }
            });
        }
        return new ReflectiveMapper(type, expressions);
    }

    private static String exprOrFieldName(Expr<?> expr, int i) {
        String name = expr instanceof TableField ? ((TableField)expr).getFieldName() : expr.getName();
        return name.isEmpty() ? String.valueOf(i + 1) : name;
    }

    private static class ReflectiveMapper<T>
    implements RowMapper<T> {
        @NotNull
        private final Class<T> clazz;
        @NotNull
        private final Expr<?>[] expressions;
        @NotNull
        private final Field[] mapping;

        private ReflectiveMapper(@NotNull Class<T> clazz, @NotNull Expr<?>[] expressions) {
            this.clazz = clazz;
            this.expressions = expressions;
            this.mapping = ReflectiveMapper.fieldMapping(clazz, expressions);
        }

        public T mapRow(@NotNull ResultSet rs) throws SQLException {
            Object result = Reflection.construct(this.clazz, (Object[])new Object[0]);
            for (int i = 0; i < this.expressions.length; ++i) {
                Field field = this.mapping[i];
                Reflection.setFieldValue((Object)result, (Field)field, this.expressions[i].getValueFromResultSet(rs, i + 1));
            }
            return (T)result;
        }

        @NotNull
        private static Field fieldFor(Map<String, Field> fields, Expr<?> e) {
            Field f;
            Field fc = fields.get(e.getName());
            if (fc != null) {
                return fc;
            }
            if (e instanceof TableField && (f = fields.get(((TableField)e).getFieldName())) != null) {
                return f;
            }
            throw new IllegalArgumentException("Cannot map: " + e);
        }

        private static Field[] fieldMapping(Class<?> clazz, Expr<?>[] es) {
            HashMap<String, Field> fields = new HashMap<String, Field>();
            for (Field fld : Reflection.getFields(clazz)) {
                String name = fld.getName();
                fields.put(name, fld);
                fields.put(Strings.fromCamelCase((String)name), fld);
            }
            Field[] m = new Field[es.length];
            for (int i = 0; i < es.length; ++i) {
                m[i] = ReflectiveMapper.fieldFor(fields, es[i]);
            }
            return m;
        }
    }

    private static class ArrayQueryTuple
    extends QueryTuple {
        private final Object[] vs;

        ArrayQueryTuple(Expr<?>[] es, Object[] vs) {
            super(es);
            this.vs = vs;
        }

        @Override
        @Nullable
        public <T> T get(int columnNumber) {
            return (T)Predefined.cast((Object)this.vs[columnNumber - 1]);
        }
    }
}

