/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.collections.Traversable;
import mulesoft.common.core.Option;
import mulesoft.common.core.StepResult;
import mulesoft.database.DbMacro;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.OrderSpec;
import mulesoft.persistence.QueryTuple;
import mulesoft.persistence.StoreHandler;
import mulesoft.persistence.SubQuery;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableLike;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.sql.SqlBaseSelectHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Select<T>
extends TableLike<T>
implements Traversable<T> {
    private final long cacheTime;
    private final Expr<?>[] expressions;
    private final EnumSet<Flag> flags;
    private final TableLike<?> from;
    private final Expr<?>[] groupBy;
    private final Criteria[] having;
    private final Seq<Join> joins;
    private final long limit;
    private final long offset;
    private final OrderSpec<?>[] orderBy;
    private final boolean singleTable;
    private final Class<T> type;
    private final Seq<Union> unions;
    private final Criteria[] where;
    private static final OrderSpec<?>[] EMPTY_ORDER = new OrderSpec[0];
    static final Criteria[] EMPTY_CRITERIA = new Criteria[0];
    static final Expr<?>[] EMPTY_EXPR = new Expr[0];

    protected Select(Select<T> s, @Nullable Join join, @Nullable Union union) {
        this.type = s.type;
        this.from = s.from;
        this.expressions = s.expressions;
        this.having = s.having;
        this.orderBy = s.orderBy;
        this.groupBy = s.groupBy;
        this.where = s.where;
        this.offset = s.offset;
        this.limit = s.limit;
        this.flags = s.flags;
        this.cacheTime = s.cacheTime;
        this.unions = union == null ? s.unions : s.unions.append((Object)union);
        this.joins = join == null ? s.joins : s.joins.append((Object)join);
        this.singleTable = s.singleTable && this.joins.isEmpty();
    }

    private Select(TableLike<?> from, Class<T> type, Expr<?>[] es) {
        this.type = type;
        this.from = from;
        this.singleTable = from.isSingleTable();
        this.expressions = es;
        this.offset = 0L;
        this.limit = Long.MAX_VALUE;
        this.cacheTime = 0L;
        this.flags = EnumSet.noneOf(Flag.class);
        this.having = EMPTY_CRITERIA;
        this.joins = Colls.emptyIterable();
        this.unions = Colls.emptyIterable();
        this.orderBy = EMPTY_ORDER;
        this.groupBy = EMPTY_EXPR;
        this.where = EMPTY_CRITERIA;
    }

    private Select(Select<T> s, long offset, long limit, long cacheTime, EnumSet<Flag> flags) {
        this.type = s.type;
        this.from = s.from;
        this.expressions = s.expressions;
        this.having = s.having;
        this.joins = s.joins;
        this.unions = s.unions;
        this.orderBy = s.orderBy;
        this.groupBy = s.groupBy;
        this.where = s.where;
        this.offset = offset;
        this.limit = limit;
        this.cacheTime = cacheTime;
        this.singleTable = s.singleTable;
        this.flags = flags;
    }

    private Select(Select<T> s, Criteria[] where, Expr<?>[] groupBy, Criteria[] having, OrderSpec<?>[] orderBy) {
        this.type = s.type;
        this.from = s.from;
        this.expressions = s.expressions;
        this.offset = s.offset;
        this.limit = s.limit;
        this.flags = s.flags;
        this.joins = s.joins;
        this.unions = s.unions;
        this.cacheTime = s.cacheTime;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.singleTable = s.singleTable;
    }

    public SubQuery<T> as(String aliasName) {
        return new SubQuery(this, aliasName);
    }

    public String asSql() {
        return Predefined.notNull((String)SqlBaseSelectHandler.asSql(this));
    }

    @NotNull
    public Select<T> cache(int seconds) {
        return this.cache(seconds, TimeUnit.SECONDS);
    }

    @NotNull
    public Select<T> cache(int n, TimeUnit timeUnit) {
        return new Select<T>(this, this.offset, this.limit, timeUnit.toMillis(n), this.flags);
    }

    public long count() {
        return this.storeHandler().select(this).count();
    }

    @NotNull
    public Select<T> distinct() {
        return new Select<T>(this, this.offset, this.limit, this.cacheTime, Select.addFlag(this.flags, Flag.DISTINCT));
    }

    public boolean exists() {
        return this.storeHandler().select(this).exists();
    }

    public void forEach(@NotNull Consumer<? super T> consumer) {
        super.forEach(consumer);
    }

    public <R> Option<R> forEachReturning(@NotNull Function<? super T, StepResult<R>> step, Option<R> finalValue) {
        return this.storeHandler().select(this).forEachReturning(step, finalValue);
    }

    @NotNull
    public Select<T> forUpdate(ForUpdateFlag ... forUpdateFlags) {
        EnumSet<Flag> fs = Select.addFlag(this.flags, Flag.FOR_UPDATE);
        for (ForUpdateFlag forUpdateFlag : forUpdateFlags) {
            fs.add(forUpdateFlag.selectFlag);
        }
        return new Select<T>(this, this.offset, this.limit, this.cacheTime, fs);
    }

    @Nullable
    public T get() {
        return (T)this.storeHandler().select(this).get();
    }

    @NotNull
    public Select<T> groupBy(Expr<?> ... groupByExpressions) {
        return new Select<T>(this, this.where, groupByExpressions, this.having, this.orderBy);
    }

    @NotNull
    public Select<T> having(Criteria ... havingCriteria) {
        return new Select<T>(this, this.where, this.groupBy, havingCriteria, this.orderBy);
    }

    @NotNull
    public Select<T> join(TableLike<?> table, Criteria ... joinCondition) {
        return new Select<T>(this, new Join(table, joinCondition, false), null);
    }

    @NotNull
    public Select<T> leftOuterJoin(TableLike<?> table, Criteria ... joinCondition) {
        return new Select<T>(this, new Join(table, joinCondition, true), null);
    }

    @NotNull
    public Select<T> limit(long size) {
        return new Select<T>(this, this.offset, size, this.cacheTime, this.flags);
    }

    @NotNull
    public ImmutableList<T> list() {
        return this.limit == 0L ? Colls.emptyList() : this.storeHandler().select(this).list();
    }

    @NotNull
    public Select<T> offset(long l) {
        return new Select<T>(this, l, this.limit, this.cacheTime, this.flags);
    }

    @NotNull
    public Select<T> orderBy(OrderSpec<?> ... orderByExpressions) {
        return new Select<T>(this, this.where, this.groupBy, this.having, orderByExpressions);
    }

    @NotNull
    public ImmutableList<T> toList() {
        return this.list();
    }

    @NotNull
    public Select<T> union(Select<?> target) {
        return new Select<T>(this, null, new Union(target, false));
    }

    @NotNull
    public Select<T> unionAll(Select<?> target) {
        return new Select<T>(this, null, new Union(target, true));
    }

    @NotNull
    public Select<T> where(Criteria ... allOff) {
        return new Select<T>(this, allOff, this.groupBy, this.having, this.orderBy);
    }

    @NotNull
    public T getOrElse(T defaultValue) {
        return (T)Predefined.notNull(this.get(), defaultValue);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    String alias() {
        return this.from.getDbTable().metadata().getTableName();
    }

    @Override
    String asTableExpression() {
        return "(" + this.asSql() + ") " + this.alias();
    }

    @Override
    Collection<TableField<?>> fields() {
        return this.from.fields();
    }

    @Override
    <I extends EntityInstance<I, K>, K> DbTable<I, K> getDbTable() {
        return this.from.getDbTable();
    }

    @Override
    boolean isSingleTable() {
        return this.singleTable;
    }

    @Override
    Expr<?>[] getExpressions() {
        return this.expressions;
    }

    private boolean cacheEnabled() {
        return this.storeHandler().getDatabase().getConfiguration().selectCacheEnabled;
    }

    private <I extends EntityInstance<I, K>, K> StoreHandler<I, K> storeHandler() {
        DbTable f = this.from.getDbTable();
        return EntityTable.forTable(f).getStoreHandler();
    }

    @NotNull
    private static EnumSet<Flag> addFlag(EnumSet<Flag> flags, Flag flag) {
        EnumSet<Flag> c = EnumSet.copyOf(flags);
        c.add(flag);
        return c;
    }

    public static class Union {
        public final boolean all;
        private final Select<?> target;

        Union(Select<?> target, boolean all) {
            this.target = target;
            this.all = all;
        }

        public String getTarget() {
            return "(" + this.target.asSql() + ")";
        }
    }

    public static class Join {
        public final Criteria[] criteria;
        public final boolean left;
        private final TableLike<?> target;

        Join(TableLike<?> target, Criteria[] criteria, boolean left) {
            this.target = target;
            this.left = left;
            this.criteria = criteria;
        }

        public String getTarget() {
            return this.target.asTableExpression();
        }
    }

    public static abstract class Handler<T> {
        private final Select<T> select;

        protected Handler(Select<T> select) {
            this.select = select;
        }

        protected abstract long count();

        protected abstract boolean exists();

        protected abstract <R> Option<R> forEachReturning(Function<? super T, StepResult<R>> var1, Option<R> var2);

        protected String from() {
            return ((Select)this.select).from.asTableExpression();
        }

        protected Iterable<TableField<?>> fromFields() {
            return ((Select)this.select).from.fields();
        }

        @Nullable
        protected abstract T get();

        protected abstract ImmutableList<T> list();

        protected boolean qualify() {
            return !((Select)this.select).singleTable;
        }

        protected long getCacheTime() {
            return ((Select)this.select).cacheEnabled() ? ((Select)this.select).cacheTime : -1L;
        }

        protected Expr<?>[] getExpressions() {
            return ((Select)this.select).expressions;
        }

        protected EnumSet<Flag> getFlags() {
            return ((Select)this.select).flags;
        }

        protected Expr<?>[] getGroupBy() {
            return ((Select)this.select).groupBy;
        }

        protected Criteria[] getHaving() {
            return ((Select)this.select).having;
        }

        protected Seq<Join> getJoins() {
            return ((Select)this.select).joins;
        }

        protected long getLimit() {
            return ((Select)this.select).limit;
        }

        protected long getOffset() {
            return ((Select)this.select).offset;
        }

        protected OrderSpec<?>[] getOrderBy() {
            return ((Select)this.select).orderBy;
        }

        protected Class<T> getType() {
            return ((Select)this.select).type;
        }

        protected Seq<Union> getUnions() {
            return ((Select)this.select).unions;
        }

        protected Criteria[] getWhere() {
            return ((Select)this.select).where;
        }
    }

    public static class Builder<T> {
        private final Expr<?>[] expr;
        private final Class<T> type;

        Builder(Class<T> clazz, Expr<?> ... expr) {
            this.expr = expr;
            this.type = clazz;
        }

        public Builder<QueryTuple> andAllOf(TableLike<?> tableLike) {
            Collection<TableField<?>> fields = tableLike.fields();
            int i = this.expr.length;
            Expr[] newExpr = new Expr[i + fields.size()];
            System.arraycopy(this.expr, 0, newExpr, 0, i);
            for (TableField<?> field : fields) {
                newExpr[i++] = field;
            }
            return new Builder<QueryTuple>(QueryTuple.class, newExpr);
        }

        public <E> Builder<E> as(Class<E> clazz) {
            return new Builder<E>(clazz, this.expr);
        }

        public Select<T> from(TableLike<?> tableLike) {
            return new Select(tableLike, this.type, this.expr);
        }
    }

    public static enum Flag {
        DISTINCT(DbMacro.Distinct),
        NO_WAIT(DbMacro.NoWait),
        SKIP_LOCKED(DbMacro.SkipLocked),
        FOR_UPDATE(DbMacro.ForUpdate);

        private final String txt;

        private Flag(DbMacro m) {
            this.txt = m.toString();
        }

        public String asStringIfPresent(EnumSet<Flag> flags) {
            return flags.contains((Object)this) ? this.txt + " " : "";
        }
    }

    public static enum ForUpdateFlag {
        NO_WAIT(Flag.NO_WAIT),
        SKIP_LOCKED(Flag.SKIP_LOCKED);

        private final Flag selectFlag;

        private ForUpdateFlag(Flag selectFlag) {
            this.selectFlag = selectFlag;
        }
    }
}

