/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import mulesoft.database.Database;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.QueryTuple;
import mulesoft.persistence.Select;
import mulesoft.persistence.SqlDelete;
import mulesoft.persistence.SqlInsert;
import mulesoft.persistence.SqlUpdate;
import mulesoft.persistence.TableLike;
import mulesoft.persistence.expr.Expr;

public class Sql {
    private Sql() {
    }

    public static Database databaseFor(DbTable<?, ?> table) {
        return table.entityTable().getDatabase();
    }

    public static SqlDelete deleteFrom(DbTable<?, ?> table) {
        return new SqlDelete(EntityTable.forTable(table).getStoreHandler());
    }

    public static SqlInsert.Builder insertInto(DbTable<?, ?> table) {
        return new SqlInsert.Builder(new SqlInsert(EntityTable.forTable(table).getStoreHandler()));
    }

    public static <T> Select.Builder<T> select(Expr<T> expr) {
        return new Select.Builder<T>(expr.getType(), expr);
    }

    public static <T> Select.Builder<T> select(TableLike<T> tableLike) {
        return new Select.Builder<T>(tableLike.getType(), tableLike.getExpressions());
    }

    public static Select.Builder<QueryTuple> select(Expr<?> first, Expr<?> ... rest) {
        Expr[] expr = new Expr[rest.length + 1];
        expr[0] = first;
        System.arraycopy(rest, 0, expr, 1, rest.length);
        return new Select.Builder<QueryTuple>(QueryTuple.class, expr);
    }

    public static <T> Select<T> selectFrom(TableLike<T> tableLike) {
        return Sql.select(tableLike).from(tableLike);
    }

    public static SqlUpdate.Builder update(DbTable<?, ?> table) {
        return new SqlUpdate(EntityTable.forTable(table).getStoreHandler()).new SqlUpdate.Builder();
    }
}

