/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.util.List;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.DateTime;
import mulesoft.database.Database;
import mulesoft.persistence.CachedEntityInstanceImpl;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.Select;
import mulesoft.persistence.SetClause;
import mulesoft.persistence.Sql;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableMetadata;
import mulesoft.persistence.exception.EntityNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StoreHandler<I extends EntityInstance<I, K>, K> {
    private final DbTable<I, K> dbTable;
    private final EntityTable<I, K> entityTable;
    private final StoreHandler<I, K> parent;
    private static final Factory NULL_FACTORY = new Factory(){

        public <T extends EntityInstance<T, L>, L> StoreHandler<T, L> createHandler(String storeType, DbTable<T, L> table) {
            return null;
        }
    };

    protected StoreHandler(@NotNull DbTable<I, K> dbTable, @Nullable StoreHandler<I, K> parent) {
        this.parent = parent;
        this.dbTable = dbTable;
        this.entityTable = dbTable.entityTable();
    }

    public boolean checkAndLock(K key, DateTime updateTime) {
        return this.getParent().checkAndLock(key, updateTime);
    }

    public abstract void delete(I var1);

    public abstract void delete(Iterable<K> var1);

    public abstract void deleteWhere(Criteria ... var1);

    @Nullable
    public abstract I find(K var1);

    @Nullable
    public I findByKey(int keyId, Object key) {
        return this.getParent().findByKey(keyId, key);
    }

    @NotNull
    public final I findOrFail(@NotNull K key) {
        I result = this.find(key);
        if (result != null) {
            return result;
        }
        throw EntityNotFoundException.notFound(this.getEntityName(), key.toString());
    }

    @Nullable
    public I findPersisted(K key) {
        return this.getParent().findPersisted(key);
    }

    @NotNull
    public final I findPersistedOrFail(@NotNull K key) {
        I result = this.findPersisted(key);
        if (result != null) {
            return result;
        }
        throw EntityNotFoundException.notFound(this.getEntityName(), key.toString());
    }

    public int insert(List<SetClause<?>> setClauses) {
        throw Predefined.notImplemented((String)"insert-set-where");
    }

    public abstract void insert(I var1, boolean var2);

    public int insertOrUpdate(List<SetClause<?>> insertSetClauses, TableField<?>[] keyColumns, List<SetClause<?>> setClauses, Criteria[] criteria) {
        throw Predefined.notImplemented((String)"insertOrUpdate");
    }

    public abstract ImmutableList<I> list(Iterable<K> var1);

    public abstract void merge(@NotNull I var1);

    public <E> Select.Handler<E> select(Select<E> select) {
        return this.getParent().select(select);
    }

    public boolean supportsMerge() {
        return true;
    }

    public String toString() {
        return this.getEntityName();
    }

    public abstract void update(I var1);

    public int update(List<SetClause<?>> setClauses, Criteria[] criteria) {
        throw Predefined.notImplemented((String)"update-set-where");
    }

    public abstract void updateLocking(I var1);

    @Nullable
    public DateTime updateTime(K key) {
        return this.getParent().updateTime(key);
    }

    public Database getDatabase() {
        return this.getParent().getDatabase();
    }

    @NotNull
    public String getEntityName() {
        return this.entityTable.getEntityName().getFullName();
    }

    public TableMetadata<I, K> getMetadata() {
        return this.dbTable.metadata();
    }

    @NotNull
    public StoreHandler<I, K> getParent() {
        return (StoreHandler)Predefined.ensureNotNull(this.parent, (String)"Top level Store Handler");
    }

    public Class<I> getType() {
        return this.getMetadata().getType();
    }

    protected I cache(I instance, boolean cached) {
        CachedEntityInstanceImpl.AbstractData data = CachedEntityInstanceImpl.dataField(instance);
        data.setCached(cached);
        data.onLoad(instance);
        return instance;
    }

    protected ImmutableList<I> listAll() {
        return this.select(Sql.selectFrom(this.dbTable)).list();
    }

    protected void setCached(CachedEntityInstanceImpl.AbstractData<I, K> data, boolean b) {
        data.setCached(b);
    }

    @NotNull
    protected final DbTable<I, K> getDbTable() {
        return this.dbTable;
    }

    @NotNull
    protected final EntityTable<I, K> getEntityTable() {
        return this.entityTable;
    }

    public static abstract class DefaultFactory
    implements Factory {
        private final Factory parentFactory;

        protected DefaultFactory(Factory parentFactory) {
            this.parentFactory = parentFactory;
        }

        @Override
        @NotNull
        public final Factory getParentFactory() {
            return this.parentFactory;
        }
    }

    public static interface Factory {
        @Nullable
        public <I extends EntityInstance<I, K>, K> StoreHandler<I, K> createHandler(String var1, DbTable<I, K> var2);

        @NotNull
        default public Factory getParentFactory() {
            return NULL_FACTORY;
        }
    }
}

