/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import mulesoft.common.Predefined;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.logging.Logger;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInitializer;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.Initialize;
import mulesoft.persistence.StoreHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableFactory {
    private final MultiMap<Class<?>, EntityInitializer> initializer;
    private final StoreHandler.Factory storeHandlerFactory;
    private static final Set<DbTable<?, ?>> boundTables = new LinkedHashSet();
    @Nullable
    private static TableFactory instance = null;

    public TableFactory(StoreHandler.Factory storeHandlerFactory) {
        this.storeHandlerFactory = storeHandlerFactory;
        this.initializer = MultiMap.createMultiMap();
        for (EntityInitializer i : ServiceLoader.load(EntityInitializer.class)) {
            this.initializer.put(i.getEntityType(), (Object)i);
        }
    }

    <T extends EntityTable<I, K>, I extends EntityInstance<I, K>, K> void createEntityTable(DbTable<I, K> t, String storeType) {
        StoreHandler<I, K> handler = this.storeHandlerFactory.createHandler(storeType, t);
        t.entityTable().init((StoreHandler)Predefined.ensureNotNull(handler, (String)"Cannot create Handler"));
        this.initialize(t.getType());
    }

    private void initialize(Class<?> clazz) {
        try {
            for (EntityInitializer i : this.initializer.get(clazz)) {
                i.initialize();
            }
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.getDeclaredAnnotation(Initialize.class) == null) continue;
                m.setAccessible(true);
                m.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TableFactory.class).error((Throwable)e);
        }
    }

    @NotNull
    public static <I extends EntityInstance<I, K>, K> EntityTable<I, K> bind(DbTable<I, K> dbTable) {
        EntityTable<I, K> entityTable = dbTable.entityTable();
        TableFactory.factory().createEntityTable(dbTable, entityTable.storeType());
        boundTables.add(dbTable);
        return entityTable;
    }

    public static void setFactory(TableFactory factory) {
        instance = factory;
        boundTables.forEach(DbTable::doBind);
    }

    private static TableFactory factory() {
        if (instance == null) {
            throw new IllegalStateException("Factory not initialized");
        }
        return instance;
    }
}

