/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Decimals;
import mulesoft.common.core.Enumeration;
import mulesoft.common.core.Integers;
import mulesoft.common.core.Reals;
import mulesoft.common.core.Resource;
import mulesoft.common.core.Strings;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.common.util.Conversions;
import mulesoft.database.Database;
import mulesoft.database.DatabaseType;
import mulesoft.database.SqlConstants;
import mulesoft.database.SqlStatement;
import mulesoft.database.exception.DatabaseException;
import mulesoft.database.support.JdbcUtils;
import mulesoft.persistence.CachedEntityInstanceImpl;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import mulesoft.persistence.resource.DbResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableField<T>
extends ExprImpl<T> {
    @NotNull
    private final Field field;
    private final String fieldName;
    private boolean primaryKey;
    @NotNull
    private final DbTable<?, ?> table;

    protected TableField(@NotNull DbTable<?, ?> table, @NotNull Field field, String columnName) {
        super(columnName);
        this.table = (DbTable)Predefined.cast(table);
        this.field = field;
        this.fieldName = field.getName();
    }

    @Override
    public <Q> Q accept(ExprVisitor<Q> visitor) {
        return visitor.visit(this);
    }

    public String alias() {
        return this.table.alias();
    }

    @Override
    public String asSql(boolean qualify) {
        if (!qualify) {
            return this.getName();
        }
        String alias = this.table.alias();
        return (alias.isEmpty() ? this.table.metadata().getTableName() : alias) + "." + this.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableField)) {
            return false;
        }
        TableField tf = (TableField)obj;
        return tf.table.equals(this.table) && tf.fieldName.equals(this.fieldName);
    }

    @Nullable
    public abstract T fromString(@NotNull String var1);

    public int hashCode() {
        return this.fieldName.hashCode() + 31 * this.table.hashCode();
    }

    @SafeVarargs
    public final Criteria in(T first, T ... rest) {
        return this.in(Colls.listOf(first).append((Object[])rest));
    }

    @SafeVarargs
    public final Criteria in(Expr<T> first, Expr<T> ... rest) {
        int n = rest.length;
        if (n == 0) {
            return this.eq(first);
        }
        Expr[] ops = new Expr[n + 1];
        ops[0] = first;
        System.arraycopy(rest, 0, ops, 1, n);
        return this.bool(ExprOperator.IN, ops);
    }

    @SafeVarargs
    public final Criteria notIn(T first, T ... rest) {
        return this.in(first, rest).not();
    }

    @Override
    public String toString() {
        return this.table.toString() + "." + this.fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public <I extends EntityInstance<I, K>, K> void setFromResultSet(I instance, ResultSet rs, int columnIndex) {
        try {
            Object value = this.getValueFromResultSet(rs, columnIndex);
            this.setRawValue(instance, value);
        }
        catch (SQLException e) {
            throw this.translateException(e);
        }
    }

    public void setParameter(SqlStatement.Prepared stmt, int i, @Nullable T value) {
        PreparedStatement p = stmt.getPreparedStatement();
        try {
            if (value == null) {
                p.setObject(i, null);
            } else {
                this.doSetParameter(p, i, value, this.getDatabase().getDatabaseType());
            }
        }
        catch (SQLException e) {
            throw this.translateException(e);
        }
    }

    public <I extends EntityInstance<I, K>, K> void setParameterFromInstance(SqlStatement.Prepared stmt, int i, @NotNull I instance) {
        this.setParameter(stmt, i, this.getValue(instance));
    }

    @NotNull
    public EntityTable<?, ?> getTable() {
        return this.table.entityTable();
    }

    @Nullable
    public final <I extends EntityInstance<I, K>, K> T getValue(@NotNull I instance) {
        try {
            return (T)Predefined.cast((Object)this.field.get(this.field.getDeclaringClass().isInstance(instance) ? instance : CachedEntityInstanceImpl.dataField(instance)));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable T value) {
        this.setRawValue(instance, value);
    }

    public <I extends EntityInstance<I, K>, K> void setValue(I instance, @Nullable String value) {
        this.setRawValue(instance, value == null ? null : this.fromString(value));
    }

    public String getValueAsSqlConstant(T value) {
        return value.toString();
    }

    @Nullable
    public <I extends EntityInstance<I, K>, K> String getValueAsString(I instance) {
        return Strings.valueOf(this.getValue(instance));
    }

    public final boolean isPrimaryKey() {
        return this.primaryKey;
    }

    protected abstract void doSetParameter(PreparedStatement var1, int var2, T var3, DatabaseType var4) throws SQLException;

    @NotNull
    protected <I extends EntityInstance<I, K>, K> EntityTable<I, K> entityTable() {
        return (EntityTable)Predefined.cast(this.table.entityTable());
    }

    protected Database getDatabase() {
        return this.entityTable().getDatabase();
    }

    protected final <I extends EntityInstance<I, K>, K> void setRawValue(@NotNull I instance, @Nullable Object value) {
        try {
            this.field.set(this.field.getDeclaringClass().isInstance(instance) ? instance : CachedEntityInstanceImpl.dataField(instance), value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    void primaryKey() {
        this.primaryKey = true;
    }

    private DatabaseException translateException(SQLException e) {
        return this.getDatabase().getDatabaseType().getSqlExceptionTranslator().translate(e);
    }

    public static class StrIntern
    extends Str {
        public StrIntern(DbTable<?, ?> t, Field field, String columnName, int length) {
            super(t, field, columnName, length);
        }

        @Override
        public String fromString(@NotNull String value) {
            return Strings.truncate((String)value, (int)this.length).intern();
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable String value) {
            this.setRawValue(instance, value == null ? null : (!value.isEmpty() && value.charAt(0) == '\u00a0' ? "" : Strings.truncate((String)value, (int)this.length).intern()));
        }

        @Override
        @Nullable
        public String getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            Object s = super.getValueFromResultSet(rs, columnIndex);
            return Predefined.isNotEmpty(s) ? ((String)s).intern() : s;
        }
    }

    public static class Str
    extends TableField<String>
    implements Expr.Str {
        protected final int length;

        public Str(DbTable<?, ?> t, Field field, String columnName, int length) {
            super(t, field, columnName);
            this.length = length;
        }

        @Override
        public String fromString(@NotNull String value) {
            return Strings.truncate((String)value, (int)this.length);
        }

        public int maxLength() {
            return this.length;
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable String value) {
            this.setRawValue(instance, value == null ? null : (!value.isEmpty() && value.charAt(0) == '\u00a0' ? "" : Strings.truncate((String)value, (int)this.length)));
        }

        @Override
        public String getValueAsSqlConstant(String value) {
            return SqlConstants.asSqlConstant((String)value);
        }

        @Override
        @Nullable
        public <I extends EntityInstance<I, K>, K> String getValueAsString(I instance) {
            return (String)this.getValue(instance);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, String value, DatabaseType databaseType) throws SQLException {
            if ("".equals(value)) {
                p.setString(i, databaseType.supportsEmptyString() ? "" : String.valueOf('\u00a0'));
            } else {
                p.setString(i, value);
            }
        }
    }

    public static class Res
    extends TableField<Resource> {
        public Res(DbTable<?, ?> t, Field field, String columnName) {
            super(t, field, columnName);
        }

        @Override
        public Resource fromString(@NotNull String value) {
            throw new IllegalStateException("Should not be called directly");
        }

        @Override
        public Expr<Resource> unary(ExprOperator operator) {
            throw Predefined.notImplemented((String)"Not implemented");
        }

        @Override
        @NotNull
        public Class<Resource> getType() {
            return Resource.class;
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Resource value) {
            this.setRawValue(instance, value == null || value instanceof DbResource ? value : this.create(value.toString()));
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(I instance, @Nullable String value) {
            this.setRawValue(instance, (Object)(Predefined.isEmpty((String)value) ? null : this.create(value)));
        }

        @Override
        @Nullable
        public Resource getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            String str = rs.getString(columnIndex);
            return rs.wasNull() ? null : new DbResource(this.getDatabase(), str);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, Resource value, DatabaseType databaseType) throws SQLException {
            p.setString(i, value.getUuid());
        }

        private DbResource create(String str) {
            return new DbResource(this.entityTable().getDatabase(), str);
        }
    }

    public static class Real
    extends TableField<Double>
    implements Expr.Real {
        private final boolean signed;

        Real(DbTable<?, ?> t, Field field, String columnName, boolean signed) {
            super(t, field, columnName);
            this.signed = signed;
        }

        @Override
        @Nullable
        public Double fromString(@NotNull String value) {
            return Reals.checkSigned((String)this.toString(), (Double)Conversions.toDouble((String)value), (boolean)this.signed);
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Double value) {
            this.setRawValue(instance, Reals.checkSigned((String)this.toString(), (Double)value, (boolean)this.signed));
        }

        @Override
        public String getValueAsSqlConstant(Double value) {
            return SqlConstants.asSqlConstant((Double)value);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, Double value, DatabaseType databaseType) throws SQLException {
            p.setDouble(i, value);
        }
    }

    public static abstract class Num<T extends Number, ET extends Expr.Comp<T>>
    extends TableField<T>
    implements Expr.Num<T, ET> {
        protected Num(@NotNull DbTable<?, ?> table, @NotNull Field field, String columnName) {
            super(table, field, columnName);
        }

        @Override
        public abstract <I extends EntityInstance<I, K>, K> void setValue(@NotNull I var1, @Nullable Number var2);
    }

    public static class LongFld
    extends Num<Long, Expr.Long>
    implements Expr.Long {
        private final int length;
        private final boolean signed;

        LongFld(DbTable<?, ?> t, Field field, String name, boolean signed, int length) {
            super(t, field, name);
            this.signed = signed;
            this.length = length;
        }

        @Override
        @Nullable
        public Long fromString(@NotNull String value) {
            return Integers.checkSignedLength((String)this.toString(), (Long)Conversions.toLong((String)value), (boolean)this.signed, (int)this.length);
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Long value) {
            this.setRawValue(instance, Integers.checkSignedLength((String)this.toString(), (Long)value, (boolean)this.signed, (int)this.length));
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Number number) {
            if (number instanceof Long || number == null) {
                this.setValue(instance, (Long)number);
            } else {
                this.setValue(instance, number.longValue());
            }
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, Long value, DatabaseType databaseType) throws SQLException {
            p.setLong(i, value);
        }
    }

    public static class Int
    extends Num<Integer, Expr.Int>
    implements Expr.Int {
        private final int length;
        private final boolean signed;

        Int(DbTable<?, ?> t, Field field, String name, boolean signed, int length) {
            super(t, field, name);
            this.signed = signed;
            this.length = length;
        }

        @Override
        @Nullable
        public Integer fromString(@NotNull String value) {
            return Integers.checkSignedLength((String)this.toString(), (Integer)Conversions.toInt((String)value), (boolean)this.signed, (int)this.length);
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Integer value) {
            this.setRawValue(instance, Integers.checkSignedLength((String)this.toString(), (Integer)value, (boolean)this.signed, (int)this.length));
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable Number number) {
            if (number instanceof Integer || number == null) {
                this.setValue(instance, (Integer)number);
            } else {
                this.setValue(instance, number.intValue());
            }
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, Integer value, DatabaseType databaseType) throws SQLException {
            p.setInt(i, value);
        }
    }

    public static class EnumerationSet<T extends java.lang.Enum<T>, I>
    extends TableField<EnumSet<T>>
    implements Expr.EnumerationSet<T, I> {
        private final Class<T> enumType;

        EnumerationSet(DbTable<?, ?> t, Field field, String columnName, Class<T> enumType) {
            super(t, field, columnName);
            this.enumType = enumType;
        }

        @Override
        public EnumSet<T> fromString(@NotNull String value) {
            return Enumerations.enumSet(this.enumType, (String)value);
        }

        @Override
        @NotNull
        public Class<T> getEnumType() {
            return this.enumType;
        }

        @Override
        public String getValueAsSqlConstant(EnumSet<T> value) {
            return String.valueOf(Enumerations.asLong(value));
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, EnumSet<T> value, DatabaseType databaseType) throws SQLException {
            p.setObject(i, Enumerations.asLong(value));
        }
    }

    public static class Enum<T extends java.lang.Enum<T>, I>
    extends TableField<T>
    implements Expr.Enum<T, I> {
        private final Class<T> enumType;

        Enum(DbTable<?, ?> t, Field field, String columnName, Class<T> enumType) {
            super(t, field, columnName);
            this.enumType = enumType;
        }

        @Override
        public T fromString(@NotNull String value) {
            java.lang.Enum r = (java.lang.Enum)Predefined.cast((Object)Enumerations.enumerationValueOf(this.getType(), (Object)value));
            if (r != null) {
                return (T)r;
            }
            Class t = (Class)Predefined.cast(this.getType());
            return (T)Enumerations.valueOf((Class)t, (String)value);
        }

        @Override
        @NotNull
        public Class<T> getType() {
            return this.enumType;
        }

        @Override
        public String getValueAsSqlConstant(T value) {
            return SqlConstants.asSqlConstant((Enumeration)((Enumeration)value));
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, T value, DatabaseType databaseType) throws SQLException {
            p.setObject(i, ((Enumeration)value).key());
        }
    }

    public static class DTime
    extends TableField<DateTime>
    implements Expr.DTime {
        DTime(DbTable<?, ?> t, Field field, String columnName) {
            super(t, field, columnName);
        }

        @Override
        public DateTime fromString(@NotNull String value) {
            return DateTime.fromString((String)value);
        }

        @Override
        public String getValueAsSqlConstant(DateTime value) {
            return SqlConstants.asSqlConstant((DateTime)value);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, DateTime value, DatabaseType databaseType) throws SQLException {
            p.setTimestamp(i, JdbcUtils.toTimestamp((DateTime)value));
        }
    }

    public static class Decimal
    extends TableField<BigDecimal>
    implements Expr.Decimal {
        private final int decimals;
        private final int precision;
        private final boolean signed;

        Decimal(DbTable<?, ?> t, Field field, String columnName, boolean signed, int precision, int decimals) {
            super(t, field, columnName);
            this.signed = signed;
            this.precision = precision;
            this.decimals = decimals;
        }

        @Override
        @Nullable
        public BigDecimal fromString(@NotNull String value) {
            return Decimals.scaleAndCheck((String)this.toString(), (BigDecimal)Conversions.toDecimal((String)value), (boolean)this.signed, (int)this.precision, (int)this.decimals);
        }

        @Override
        public int getDecimals() {
            return this.decimals;
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, BigDecimal value) {
            this.setRawValue(instance, Decimals.scaleAndCheck((String)this.toString(), (BigDecimal)value, (boolean)this.signed, (int)this.precision, (int)this.decimals));
        }

        @Override
        @Nullable
        public <I extends EntityInstance<I, K>, K> String getValueAsString(I instance) {
            BigDecimal value = (BigDecimal)super.getValue(instance);
            return value == null ? null : value.setScale(this.decimals, 6).toPlainString();
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, BigDecimal value, DatabaseType databaseType) throws SQLException {
            p.setBigDecimal(i, value);
        }
    }

    public static class Date
    extends TableField<DateOnly>
    implements Expr.Date {
        Date(DbTable<?, ?> t, Field field, String columnName) {
            super(t, field, columnName);
        }

        @Override
        public DateOnly fromString(@NotNull String value) {
            return DateOnly.fromString((String)value);
        }

        @Override
        public String getValueAsSqlConstant(DateOnly value) {
            return SqlConstants.asSqlConstant((DateOnly)value);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, DateOnly value, DatabaseType databaseType) throws SQLException {
            p.setDate(i, new java.sql.Date(value.toDate().getTime()));
        }
    }

    public static class Clob
    extends TableField<String> {
        private final int length;

        public Clob(DbTable<?, ?> t, Field field, String columnName, int length) {
            super(t, field, columnName);
            this.length = length;
        }

        @Override
        @Nullable
        public String fromString(@NotNull String value) {
            return Strings.truncate((String)value, (int)this.length);
        }

        @Override
        @NotNull
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public <I extends EntityInstance<I, K>, K> void setValue(@NotNull I instance, @Nullable String value) {
            String finalValue = value;
            if (Predefined.isNotEmpty((String)finalValue) && finalValue.charAt(0) == '\u00a0') {
                finalValue = "";
            }
            this.setRawValue(instance, Strings.truncate((String)finalValue, (int)this.length));
        }

        @Override
        @Nullable
        public <I extends EntityInstance<I, K>, K> String getValueAsString(I instance) {
            return (String)this.getValue(instance);
        }

        @Override
        @Nullable
        public String getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            String string;
            if (this.getDatabase().getDatabaseType().supportsLobs()) {
                java.sql.Clob clob = rs.getClob(columnIndex);
                if (clob != null) {
                    int read;
                    char[] chars = new char[(int)clob.length()];
                    try {
                        read = clob.getCharacterStream().read(chars);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    string = read > 0 ? String.valueOf(chars, 0, read) : "";
                } else {
                    string = null;
                }
            } else {
                string = rs.getString(columnIndex);
            }
            return Predefined.isNotEmpty((String)string) && string.charAt(0) == '\u00a0' ? "" : string;
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, String value, DatabaseType databaseType) throws SQLException {
            if (!databaseType.supportsEmptyString() && "".equals(value)) {
                p.setString(i, String.valueOf('\u00a0'));
            } else if (databaseType.supportsLobs()) {
                p.setClob(i, new StringReader(value), value.length());
            } else {
                p.setString(i, value);
            }
        }
    }

    public static class Bool
    extends TableField<Boolean>
    implements Criteria {
        Bool(DbTable<?, ?> t, Field field, String columnName) {
            super(t, field, columnName);
        }

        @Override
        public Boolean fromString(@NotNull String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public String getValueAsSqlConstant(Boolean value) {
            return SqlConstants.asSqlConstant((Boolean)value);
        }

        @Override
        protected void doSetParameter(PreparedStatement p, int i, Boolean value, DatabaseType databaseType) throws SQLException {
            p.setBoolean(i, value);
        }
    }
}

