/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.cache.CacheType;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.ImmutableSet;
import mulesoft.common.collections.Maps;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.common.env.Environment;
import mulesoft.common.util.Reflection;
import mulesoft.common.util.Resources;
import mulesoft.database.RowMapper;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntitySeq;
import mulesoft.persistence.InnerEntitySeq;
import mulesoft.persistence.InnerInstance;
import mulesoft.persistence.TableField;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.properties.SchemaProps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableMetadata<I extends EntityInstance<I, K>, K> {
    private final CacheType cacheType;
    private final Class<?> dataClass;
    private final Map<String, TableField<?>> fieldMap;
    private final ImmutableList<Field> innerFields;
    private final EnumSet<mulesoft.type.Modifier> modifiers;
    private final String sequenceName;
    private final QName tableQName;
    private final Class<I> type;
    @Nullable
    private TableField.DTime creationTimeField;
    @Nullable
    private TableField.Str creationUserField;
    @Nullable
    private TableField.DTime deprecationTimeField;
    @Nullable
    private TableField.Str deprecationUserField;
    @Nullable
    private TableField.DTime updateTimeField;
    @Nullable
    private TableField.Str updateUserField;
    @Nullable
    private TableField.LongFld versionField;

    TableMetadata(Class<I> type, String schemaName, String tableName, String sequenceName, EnumSet<mulesoft.type.Modifier> modifiers, CacheType cacheType) {
        this.type = type;
        this.dataClass = (Class)Reflection.findField(type, (String)"_data").map(Field::getType).orElse(type);
        this.tableQName = QName.createQName((String)schemaName, (String)tableName);
        this.cacheType = cacheType;
        this.sequenceName = sequenceName;
        this.modifiers = modifiers;
        this.fieldMap = new LinkedHashMap();
        this.innerFields = TableMetadata.solveInners(type);
        this.creationTimeField = null;
        this.creationUserField = null;
        this.deprecationTimeField = null;
        this.deprecationUserField = null;
        this.updateTimeField = null;
        this.updateUserField = null;
        this.versionField = null;
    }

    public Criteria buildKeyCriteria(K key) {
        return this.buildKeyCriteria(Tuple.asList(key));
    }

    public Criteria buildKeyCriteriaGT(K key) {
        ImmutableList values = Tuple.asList(key);
        ImmutableList<TableField<?>> keys = this.getPrimaryKey();
        return Criteria.anyOf((Iterable<Criteria>)Seq.fromTo((int)0, (int)(keys.size() - 1)).map(n -> ((TableField)keys.get(n.intValue())).bool(ExprOperator.GT, Expr.constant(values.get(n.intValue()))).and(n == 0 ? Criteria.EMPTY : Criteria.allOf((Iterable<Criteria>)keys.slice(0, n.intValue()).zipWith(this::eq, (Seq)values.slice(0, n.intValue()))))));
    }

    public I createInstance() {
        return (I)((EntityInstance)Reflection.construct(this.getType(), (Object[])new Object[0]));
    }

    public I createInstance(K key) {
        return this.setKey(this.createInstance(), key);
    }

    public boolean hasGeneratedKey() {
        return !this.sequenceName.isEmpty();
    }

    public boolean hasModifier(mulesoft.type.Modifier mod) {
        return this.modifiers.contains(mod);
    }

    public abstract K keyFromString(String var1);

    @Nullable
    public <SK> SK keyObject(I instance, int keyId) {
        this.validateKeyId(keyId);
        ImmutableList keyFields = (ImmutableList)this.getSecondaryKeys().get(keyId);
        if (keyFields.size() == 1) {
            return (SK)Predefined.cast(((TableField)keyFields.get(0)).getValue(instance));
        }
        ImmutableList kvs = keyFields.map(kf -> kf.getValue(instance)).toList();
        return (SK)(kvs.size() == keyFields.size() ? Tuple.tupleFromList((List)kvs) : null);
    }

    public I updateAuditFields(@NotNull I instance, boolean create, boolean deprecate, boolean restore) {
        if (this.hasModifier(mulesoft.type.Modifier.REMOTE)) {
            return instance;
        }
        if (restore) {
            if (this.deprecationTimeField != null) {
                this.deprecationTimeField.setValue(instance, (DateTime)null);
            }
            return instance;
        }
        DateTime now = DateTime.current();
        if (this.updateTimeField != null) {
            this.updateTimeField.setValue(instance, now);
        }
        if (create) {
            if (this.creationTimeField != null) {
                this.creationTimeField.setValue(instance, now);
            }
        } else if (deprecate && this.deprecationTimeField != null) {
            this.deprecationTimeField.setValue(instance, now);
        }
        return instance;
    }

    @NotNull
    public CacheType getCacheType() {
        return this.cacheType;
    }

    @Nullable
    public TableField.DTime getCreationTimeField() {
        return this.creationTimeField;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public boolean isRemotable() {
        return this.hasModifier(mulesoft.type.Modifier.REMOTABLE);
    }

    @NotNull
    public <F extends TableField<?>> Option<F> getField(@NotNull String fieldName) {
        return Option.ofNullable((Object)Predefined.cast(this.fieldMap.get(fieldName)));
    }

    @NotNull
    public <F extends TableField<?>> Option<F> getField(@NotNull String fieldName, Class<F> fieldType) {
        return this.getField(fieldName).castTo(fieldType);
    }

    @NotNull
    public <F extends TableField<?>> F getFieldOrFail(String fieldName) {
        return (F)((TableField)this.getField(fieldName).orElseThrow(() -> new IllegalStateException("Invalid field: " + fieldName)));
    }

    @NotNull
    public ImmutableCollection<TableField<?>> getFields() {
        return Colls.immutable(this.fieldMap.values());
    }

    public <E extends InnerInstance<E, EK, ?, ?>, EK> InnerEntitySeq<E> getInner(I instance, String fieldName) {
        for (Field inner : this.innerFields) {
            if (!inner.getName().equals(fieldName)) continue;
            return (InnerEntitySeq)Reflection.getNotNullFieldValue(instance, (Field)inner);
        }
        throw new IllegalArgumentException("Inner field not found: " + fieldName);
    }

    public ImmutableList<Field> getInnerFields() {
        return this.innerFields;
    }

    public I setKey(I instance, K key) {
        this.getPrimaryKey().zip((Seq)Tuple.asList(key)).forEach(t -> ((TableField)t._1()).setRawValue(instance, t._2()));
        return instance;
    }

    @NotNull
    public abstract ImmutableList<TableField<?>> getPrimaryKey();

    public RowMapper<I> getRowMapper() {
        return rs -> {
            I result = this.createInstance();
            for (TableField<?> f : this.fieldMap.values()) {
                f.setFromResultSet(result, rs, rs.findColumn(f.getName()));
            }
            return result;
        };
    }

    @NotNull
    public String getSchemaName() {
        return this.tableQName.getQualification();
    }

    @NotNull
    public abstract ImmutableList<ImmutableList<TableField<?>>> getSecondaryKeys();

    @NotNull
    public String getSequenceName() {
        return this.sequenceName;
    }

    @NotNull
    public String getTableName() {
        return this.tableQName.getName();
    }

    @NotNull
    public QName getTableQName() {
        return this.tableQName;
    }

    @NotNull
    public final Class<I> getType() {
        return this.type;
    }

    @NotNull
    public String getTypeName() {
        return this.getType().getName();
    }

    @NotNull
    public QName getTypeQName() {
        return QName.createQName((String)this.getTypeName());
    }

    @Nullable
    public TableField.DTime getUpdateTimeField() {
        return this.updateTimeField;
    }

    @Nullable
    public TableField.LongFld getVersionField() {
        return this.versionField;
    }

    @NotNull
    <F extends TableField<?>> F addField(F tableField) {
        String fieldName = tableField.getFieldName();
        this.fieldMap.put(fieldName, tableField);
        switch (fieldName) {
            case "updateTime": {
                this.updateTimeField = (TableField.DTime)tableField;
                break;
            }
            case "creationTime": {
                this.creationTimeField = (TableField.DTime)tableField;
                break;
            }
            case "instanceVersion": {
                this.versionField = (TableField.LongFld)tableField;
                break;
            }
            case "deprecationTime": {
                this.deprecationTimeField = (TableField.DTime)tableField;
            }
        }
        return tableField;
    }

    Criteria buildKeyCriteria(ImmutableList<?> that) {
        return Criteria.allOf((Iterable<Criteria>)this.getPrimaryKey().zipWith(this::eq, that));
    }

    @NotNull
    final Map<String, TableField<?>> fieldMap() {
        return this.fieldMap;
    }

    void validateKeyId(int keyId) {
        if (keyId < 0 || keyId >= this.getSecondaryKeys().size()) {
            throw new IllegalArgumentException(String.format("Illegal key Id %d for entity %s", keyId, this.getTypeName()));
        }
    }

    private Criteria eq(TableField<?> f, Object k) {
        return f.eq(Expr.constant(k));
    }

    public static <T extends EntityInstance<T, K>, K> void copyFields(T from, T to) {
        for (TableField f : from.metadata().getFields()) {
            TableField field = (TableField)Predefined.cast((Object)f);
            if (field.isPrimaryKey()) continue;
            field.setValue(to, field.getValue(from));
        }
    }

    public static <T extends EntityInstance<T, K>, K> void copyInners(T from, T to) {
        from.metadata().getInnerFields().forEach(field -> TableMetadata.copyInnerFields((InnerEntitySeq)Reflection.getNotNullFieldValue((Object)from, (Field)field), (InnerEntitySeq)Reflection.getNotNullFieldValue((Object)to, (Field)field)));
    }

    public static ImmutableCollection<String> entities() {
        return Colls.immutable(TablesHolder.tables.keySet());
    }

    public static <I extends EntityInstance<I, K>, K> TableMetadata<I, K> forName(String instanceClassName) {
        return DbTable.forName(instanceClassName).metadata();
    }

    @NotNull
    public static Seq<String> localEntities(Environment env) {
        return TableMetadata.entities().filter(s -> !((SchemaProps)env.get((String)TablesHolder.schemaFor((String)s), SchemaProps.class)).remote);
    }

    @NotNull
    public static ImmutableSet<String> localSchemas(Environment env) {
        return TableMetadata.localEntities(env).map(TablesHolder::schemaFor).toSet();
    }

    public static Map<String, String> tablesByEntity() {
        return TablesHolder.tables;
    }

    private static <T extends InnerInstance<T, K, ?, ?>, K> void copyInnerFields(InnerEntitySeq<T> fromInner, InnerEntitySeq<T> toInner) {
        ImmutableIterator immutableIterator = fromInner.iterator();
        while (immutableIterator.hasNext()) {
            InnerInstance from = (InnerInstance)immutableIterator.next();
            T to = toInner.add();
            TableMetadata.copyFields(from, to);
            TableMetadata.copyInners(from, to);
        }
    }

    private static ImmutableList<Field> solveInners(Class<?> type) {
        return ImmutableList.build(b -> {
            for (Field field : Reflection.getFields((Class)type)) {
                if (Modifier.isStatic(field.getModifiers()) || !EntitySeq.Inner.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                b.add((Object)field);
            }
        });
    }

    private static interface TablesHolder {
        public static final Map<String, String> tables = Maps.map((Iterable)Resources.readResources((String)"META-INF/entity-list"), value -> Strings.splitToTuple((String)value, (String)" "));

        public static String schemaFor(String entityName) {
            return QName.extractQualification((String)TablesHolder.tableFor(entityName));
        }

        public static String tableFor(String entityName) {
            return tables.getOrDefault(entityName, "");
        }
    }
}

