/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.annotation.Pure;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Option;
import mulesoft.common.core.Tuple;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import mulesoft.persistence.expr.ExpressionBuilder;
import mulesoft.persistence.expr.Operation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Case<V extends Expr<?>, E extends Expr<T>, T>
extends ExprImpl<T> {
    private final Map<V, E> cases;
    private final Option<V> column;
    private final Option<E> otherwise;
    private final Class<T> type;

    Case(Class<T> type, @NotNull Map<V, E> cases, @NotNull Option<E> otherwise, @NotNull Option<V> column) {
        this.cases = cases;
        this.otherwise = otherwise;
        this.column = column;
        this.type = type;
    }

    @Override
    public <Q> Q accept(ExprVisitor<Q> visitor) {
        return visitor.visit(this);
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public T getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
        return null;
    }

    String asSql(ExpressionBuilder b) {
        StringBuilder s = new StringBuilder();
        if (this.column.isPresent()) {
            s.append(((Expr)this.column.get()).accept(b));
        }
        for (Map.Entry<V, E> e : this.cases.entrySet()) {
            s.append(" when ").append(((Expr)e.getKey()).accept(b));
            s.append(" then ").append(((Expr)e.getValue()).accept(b));
        }
        if (this.otherwise.isPresent()) {
            s.append(" else ").append(((Expr)this.otherwise.get()).accept(b));
        }
        s.append(" end");
        return s.toString();
    }

    public static class TypedCaseValue<V extends Expr<?>, E extends Expr<T>, T, B extends CaseBuilder<V, E, T>> {
        private final B builder;
        private final V when;

        TypedCaseValue(B builder, V when) {
            this.builder = builder;
            this.when = when;
        }

        @Pure
        public B then(E then) {
            ((CaseBuilder)this.builder).put(this.when, then);
            return this.builder;
        }

        @Pure
        public B then(T then) {
            return this.then((T)((Expr)Predefined.cast(Expr.constant(then))));
        }
    }

    public static class SimpleCaseValue<V extends Expr<C>, C> {
        private final V column;
        private final V when;

        public SimpleCaseValue(V column, V when) {
            this.column = column;
            this.when = when;
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Decimal, BigDecimal> then(Expr.Decimal then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Int, Integer> then(Expr.Int then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Real, Double> then(Expr.Real then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Long, Long> then(Expr.Long then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Date, DateOnly> then(Expr.Date then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.DTime, DateTime> then(Expr.DTime then) {
            return this.build((Object)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Str, String> then(Expr.Str then) {
            return this.build((Object)then);
        }

        @Pure
        public <T extends Enum<T>, I> SimpleBuilder<V, C, Expr.Enum<T, I>, T> then(Expr.Enum<T, I> then) {
            return this.build((T)then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Decimal, BigDecimal> then(BigDecimal then) {
            return this.build((Object)Expr.constant(then));
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Int, Integer> then(Integer then) {
            return this.build(then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Real, Double> then(Double then) {
            return this.build(then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Long, Long> then(Long then) {
            return this.build(then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Date, DateOnly> then(DateOnly then) {
            return this.build(then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.DTime, DateTime> then(DateTime then) {
            return this.build(then);
        }

        @Pure
        public SimpleBuilder<V, C, Expr.Str, String> then(String then) {
            return this.build(then);
        }

        @Pure
        public <T extends Enum<T>, I> SimpleBuilder<V, C, Expr.Enum<T, I>, T> then(T then) {
            return this.build(then);
        }

        @NotNull
        @Pure
        private <E extends Expr<T>, T> SimpleBuilder<V, C, E, T> build(E then) {
            return new SimpleBuilder(this.column, this.when, then);
        }

        @NotNull
        @Pure
        private <E extends Expr<T>, T> SimpleBuilder<V, C, E, T> build(T then) {
            Expr constant = (Expr)Predefined.cast(Expr.constant(then));
            return this.build((T)constant);
        }
    }

    public static class SimpleBuilder<V extends Expr<C>, C, E extends Expr<T>, T>
    extends CaseBuilder<V, E, T> {
        private final V column;

        SimpleBuilder(V column, V when, E then) {
            super((Expr)when, (Expr)then, null);
            this.column = column;
        }

        @Pure
        public TypedCaseValue<V, E, T, SimpleBuilder<V, C, E, T>> when(C value) {
            Expr constant = (Expr)Predefined.cast(Expr.constant(value));
            return new TypedCaseValue(this, constant);
        }

        @Override
        @NotNull
        Option<V> column() {
            return Option.some(this.column);
        }
    }

    public static class SearchedBuilder<E extends Expr<T>, T>
    extends CaseBuilder<Criteria, E, T> {
        public SearchedBuilder(Criteria when, E then) {
            super(when, (Expr)then, null);
        }

        @Pure
        public TypedCaseValue<Criteria, E, T, SearchedBuilder<E, T>> elseIf(Criteria value) {
            return new TypedCaseValue(this, value);
        }
    }

    public static abstract class CaseBuilder<V extends Expr<?>, E extends Expr<T>, T> {
        private final Map<V, E> cases;
        private final E firstThen;
        private Option<E> otherwise = Option.empty();

        private CaseBuilder(V when, E then) {
            this.firstThen = then;
            this.cases = Maps.linkedHashMap((Tuple)Tuple.tuple(when, then), (Tuple[])new Tuple[0]);
        }

        @Pure
        public E end() {
            return this.overrideAndGetReturnOperation();
        }

        @Pure
        public E otherwise(E o) {
            this.otherwise = Option.some(o);
            return this.overrideAndGetReturnOperation();
        }

        @Pure
        public E otherwise(T o) {
            return this.otherwise((T)((Expr)Predefined.cast(Expr.constant(o))));
        }

        @NotNull
        Option<V> column() {
            return Option.empty();
        }

        void put(V when, E then) {
            this.cases.put(when, then);
        }

        @NotNull
        final Case<V, E, T> getCaseExpression() {
            return new Case(this.firstThen.getType(), this.cases, this.otherwise, this.column());
        }

        Map<V, E> getCases() {
            return this.cases;
        }

        @NotNull
        private E overrideAndGetReturnOperation() {
            Operation op = (Operation)Predefined.cast(this.firstThen.unary(ExprOperator.CASE));
            op.overrideOperand(this.getCaseExpression());
            return (E)((Expr)Predefined.cast((Object)op));
        }

        /* synthetic */ CaseBuilder(Expr x0, Expr x1, 1 x2) {
            this(x0, x1);
        }
    }
}

