/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.math.BigDecimal;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class Column<E>
extends ExprImpl<E> {
    private final String alias;

    Column(String alias, String name) {
        super(name);
        this.alias = alias;
    }

    @Override
    public <Q> Q accept(ExprVisitor<Q> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSql(boolean qualify) {
        return (qualify ? this.alias + "." : "") + this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return this.alias.equals(that.alias) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.alias.hashCode() + 31 * this.getName().hashCode();
    }

    public static class Str
    extends Column<String>
    implements Expr.Str {
        public Str(String alias, String columnName) {
            super(alias, columnName);
        }
    }

    public static class Real
    extends Column<Double>
    implements Expr.Real {
        public Real(String alias, String columnName) {
            super(alias, columnName);
        }
    }

    public static class Long
    extends Column<java.lang.Long>
    implements Expr.Long {
        public Long(String alias, String name) {
            super(alias, name);
        }
    }

    public static class Int
    extends Column<Integer>
    implements Expr.Int {
        public Int(String alias, String name) {
            super(alias, name);
        }
    }

    public static class Enum<T extends java.lang.Enum<T>, I>
    extends Column<T>
    implements Expr.Enum<T, I> {
        private final Class<T> enumType;

        public Enum(String alias, String columnName, Class<T> enumType) {
            super(alias, columnName);
            this.enumType = enumType;
        }

        @Override
        @NotNull
        public Class<T> getType() {
            return this.enumType;
        }
    }

    public static class DTime
    extends Column<DateTime>
    implements Expr.DTime {
        public DTime(String alias, String columnName) {
            super(alias, columnName);
        }
    }

    public static class Decimal
    extends Column<BigDecimal>
    implements Expr.Decimal {
        private final int decimals;

        public Decimal(String alias, String columnName, int decimals) {
            super(alias, columnName);
            this.decimals = decimals;
        }

        @Override
        public int getDecimals() {
            return this.decimals;
        }
    }

    public static class Date
    extends Column<DateOnly>
    implements Expr.Date {
        public Date(String alias, String columnName) {
            super(alias, columnName);
        }
    }

    public static class Bool
    extends Column<Boolean>
    implements Criteria {
        public Bool(String alias, String name) {
            super(alias, name);
        }
    }
}

