/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Enumeration;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.database.SqlConstants;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Const<T>
extends ExprImpl<T> {
    private final T value;
    private static final Map<Object, Expr<Object>> cached = new HashMap<Object, Expr<Object>>();
    static final Expr.Int ZERO;

    private Const(T value) {
        this.value = value;
    }

    @Override
    public <Q> Q accept(ExprVisitor<Q> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSql(boolean qualify) {
        return SqlConstants.sqlValue(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Const && ((Const)obj).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return Const.typeFor(this.value);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public T getValueFromResultSet(ResultSet rs, int columnIndex) {
        return this.value;
    }

    public static <Q> Q acceptBoolean(ExprVisitor<Q> visitor, boolean b) {
        return visitor.visit(new Const<Boolean>(b));
    }

    static <E extends Expr<T>, T> E make(T value) {
        return (E)((Expr)Predefined.cast(Const.build(value)));
    }

    @NotNull
    private static Expr<?> build(Object v) {
        Expr<Object> c = cached.get(v);
        if (c != null) {
            return c;
        }
        if (v instanceof String) {
            return new Str((String)v);
        }
        if (v instanceof Integer) {
            return new Int((Integer)v);
        }
        if (v instanceof Double) {
            return new Real((Double)v);
        }
        if (v instanceof BigDecimal) {
            return new Decimal((BigDecimal)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? Criteria.TRUE : Criteria.FALSE;
        }
        if (v instanceof java.lang.Long) {
            return new Long((java.lang.Long)v);
        }
        if (v instanceof DateOnly) {
            return new Date((DateOnly)v);
        }
        if (v instanceof DateTime) {
            return new DTime((DateTime)v);
        }
        if (v instanceof Enumeration) {
            return new Enum((Enumeration)v);
        }
        if (v instanceof EnumSet) {
            EnumSet v1 = (EnumSet)Predefined.cast((Object)v);
            return new EnumerationSet(v1);
        }
        return new Const<Object>(v);
    }

    private static void cache(@Nullable Object v) {
        cached.put(v, v == null ? Expr.NULL : Const.make(v));
    }

    private static <T> Class<T> typeFor(T value) {
        return (Class)Predefined.cast(value.getClass());
    }

    static {
        for (int i = 0; i <= 10; ++i) {
            Const.cache(i);
        }
        Const.cache(BigDecimal.ONE);
        Const.cache(BigDecimal.TEN);
        Const.cache("");
        Const.cache(null);
        ZERO = (Expr.Int)Const.make(0);
    }

    static class Str
    extends Const<String>
    implements Expr.Str {
        Str(String value) {
            super(value);
        }
    }

    static class Real
    extends Const<Double>
    implements Expr.Real {
        Real(Double value) {
            super(value);
        }
    }

    static class Long
    extends Const<java.lang.Long>
    implements Expr.Long {
        Long(java.lang.Long value) {
            super(value);
        }
    }

    static class Int
    extends Const<Integer>
    implements Expr.Int {
        Int(Integer value) {
            super(value);
        }
    }

    static class EnumerationSet<T extends java.lang.Enum<T>, I>
    extends Const<EnumSet<T>>
    implements Expr.EnumerationSet<T, I> {
        private final Class<T> enumType;

        EnumerationSet(EnumSet<T> value) {
            super(value);
            this.enumType = Enumerations.typeOfSet(value);
        }

        @Override
        public String asSql(boolean qualify) {
            return SqlConstants.asSqlConstant((EnumSet)((EnumSet)this.getValue()));
        }

        @Override
        @NotNull
        public Class<T> getEnumType() {
            return this.enumType;
        }
    }

    static class Enum<T extends java.lang.Enum<T>, I>
    extends Const<T>
    implements Expr.Enum<T, I> {
        Enum(Enumeration<?, ?> value) {
            super(Predefined.cast(value));
        }
    }

    static class DTime
    extends Const<DateTime>
    implements Expr.DTime {
        DTime(DateTime value) {
            super(value);
        }
    }

    static class Decimal
    extends Const<BigDecimal>
    implements Expr.Decimal {
        Decimal(BigDecimal value) {
            super(value);
        }

        @Override
        public int getDecimals() {
            return ((BigDecimal)this.getValue()).scale();
        }
    }

    static class Date
    extends Const<DateOnly>
    implements Expr.Date {
        Date(DateOnly value) {
            super(value);
        }
    }
}

