/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.util.function.Predicate;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.TableField;
import mulesoft.persistence.expr.Const;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCriteriaPredicate<T extends EntityInstance<T, K>, K>
implements Predicate<T> {
    private final ImmutableList<Criteria> criteriaSet;

    public EntityCriteriaPredicate(Criteria ... criteria) {
        this.criteriaSet = ImmutableList.fromArray((Object[])criteria);
    }

    @Override
    public boolean test(@Nullable T instance) {
        if (instance == null) {
            return false;
        }
        ExprVisitor<Object> visitor = this.createVisitor(instance);
        return this.criteriaSet.forAll(c -> EntityCriteriaPredicate.bool(c, visitor));
    }

    @NotNull
    private ExprVisitor<Object> createVisitor(final @NotNull T instance) {
        return new ExprVisitor<Object>(){

            @Override
            @Nullable
            public Object visit(TableField<?> e) {
                return e.getValue(instance);
            }

            @Override
            public Object visit(Const<?> e) {
                return e.getValue();
            }

            @Override
            public boolean supportsLaziness() {
                return true;
            }

            @Override
            public Object visit(ExprOperator operator, Object[] operands) {
                switch (operator) {
                    case AND: {
                        for (Object op : operands) {
                            if (EntityCriteriaPredicate.bool(op, this)) continue;
                            return false;
                        }
                        return true;
                    }
                    case OR: {
                        for (Object op : operands) {
                            if (!EntityCriteriaPredicate.bool(op, this)) continue;
                            return true;
                        }
                        return false;
                    }
                    case NOT: {
                        return !Boolean.TRUE.equals(operands[0]);
                    }
                    case EQ: {
                        return Predefined.equal((Object)operands[0], (Object)operands[1]);
                    }
                    case NE: {
                        return !Predefined.equal((Object)operands[0], (Object)operands[1]);
                    }
                    case GE: {
                        return this.cmp(operands) >= 0;
                    }
                    case GT: {
                        return this.cmp(operands) > 0;
                    }
                    case LE: {
                        return this.cmp(operands) <= 0;
                    }
                    case LT: {
                        return this.cmp(operands) < 0;
                    }
                    case IS_NULL: {
                        return operands[0] == null;
                    }
                }
                throw new UnsupportedOperationException(operator.name() + " expression not supported.");
            }

            private int cmp(Object[] op) {
                Comparable b;
                Comparable a = (Comparable)Predefined.cast((Object)op[0]);
                return a == (b = (Comparable)Predefined.cast((Object)op[1])) ? 0 : (a == null ? -1 : (b == null ? 1 : a.compareTo(b)));
            }
        };
    }

    private static boolean bool(Object o, ExprVisitor<Object> visitor) {
        return Boolean.TRUE.equals(((Expr)o).accept(visitor));
    }
}

