/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import mulesoft.common.Predefined;
import mulesoft.common.annotation.Pure;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.DateTimeBase;
import mulesoft.common.core.enumeration.Enumerations;
import mulesoft.database.support.JdbcUtils;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.OrderSpec;
import mulesoft.persistence.Select;
import mulesoft.persistence.expr.Alias;
import mulesoft.persistence.expr.Case;
import mulesoft.persistence.expr.Const;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import mulesoft.persistence.expr.NestedQuery;
import mulesoft.persistence.expr.Operation;
import mulesoft.persistence.expr.OrderSpecImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Expr<T>
extends OrderSpec<T> {
    public static final Long COUNT_ALL = new Operation.Long(ExprOperator.COUNT_ALL, new Expr[0]);
    public static final DTime CURRENT_TIME = new Operation.DTime(ExprOperator.CURRENT_TIME, new Expr[0]);
    public static final Null NULL = new Null();

    public <Q> Q accept(ExprVisitor<Q> var1);

    @Pure
    default public Expr<T> as(String newName) {
        return new Alias(newName, this);
    }

    @Override
    public String asSql(boolean var1);

    @NotNull
    @Pure
    default public Criteria bool(ExprOperator operator, Expr<?> ... args) {
        return new Operation.Bool(operator, (Expr<?>)this, args);
    }

    @Pure
    default public Str concat(Expr<?> ... expressions) {
        return new Operation.Str(ExprOperator.CONCAT, (Expr<?>)this, expressions);
    }

    @Pure
    default public Long count() {
        return new Operation.Long(ExprOperator.COUNT, this);
    }

    @Override
    @Pure
    default public OrderSpec<T> descending() {
        return new OrderSpecImpl(this, true, null, null);
    }

    @Pure
    default public Criteria eq(Expr<? super T> right) {
        return this.bool(ExprOperator.EQ, right);
    }

    @Pure
    default public Criteria eq(@Nullable T right) {
        return right == null ? Criteria.EMPTY : this.eq((T)Expr.constant(right));
    }

    @Pure
    default public Criteria in(Iterable<T> values) {
        return Predefined.isEmpty(values) ? Criteria.FALSE : this.bool(ExprOperator.IN_VALUES, Expr.constant(values));
    }

    @Pure
    default public Criteria in(Select<T> nestedQuery) {
        return this.bool(ExprOperator.IN, new NestedQuery<T>(nestedQuery));
    }

    @Pure
    default public Criteria like(@Nullable String value) {
        return value == null ? Criteria.EMPTY : this.bool(ExprOperator.LIKE, Expr.constant(value));
    }

    @Pure
    default public Criteria like(Expr<Str> expr) {
        return this.bool(ExprOperator.LIKE, expr);
    }

    @Pure
    default public Criteria ne(Expr<? super T> right) {
        return this.bool(ExprOperator.NE, right);
    }

    @Pure
    default public Criteria ne(@Nullable T right) {
        return right == null ? Criteria.EMPTY : this.ne((T)Expr.constant(right));
    }

    @Override
    @Pure
    default public OrderSpec<T> nlsSort(String sort) {
        return this;
    }

    @Pure
    default public Criteria notIn(Iterable<T> values) {
        return this.in(values).not();
    }

    @Pure
    default public Criteria notLike(@Nullable String value) {
        return value == null ? Criteria.EMPTY : this.bool(ExprOperator.NOT_LIKE, Expr.constant(value));
    }

    @Pure
    default public Criteria notLike(Expr<Str> expr) {
        return this.bool(ExprOperator.NOT_LIKE, expr);
    }

    @Override
    @Pure
    default public OrderSpec<T> nullsFirst() {
        return new OrderSpecImpl(this, false, true, null);
    }

    @Override
    @Pure
    default public OrderSpec<T> nullsLast() {
        return new OrderSpecImpl(this, false, false, null);
    }

    @Pure
    default public Expr<T> unary(ExprOperator operator) {
        throw Predefined.notImplemented((String)"unary");
    }

    @Pure
    default public <E extends Expr<T>> Case.SimpleCaseValue<E, T> when(T value) {
        Expr constant = (Expr)Predefined.cast(Expr.constant(value));
        return new Case.SimpleCaseValue((Expr)Predefined.cast((Object)this), constant);
    }

    @Pure
    default public Criteria isNotNull() {
        return this.bool(ExprOperator.IS_NOT_NULL, new Expr[0]);
    }

    @Pure
    default public Criteria isNull() {
        return this.bool(ExprOperator.IS_NULL, new Expr[0]);
    }

    public String getName();

    @NotNull
    public Class<T> getType();

    @Nullable
    public T getValueFromResultSet(ResultSet var1, int var2) throws SQLException;

    public static <T> Expr<T> constant(T value) {
        return Const.make(value);
    }

    public static <T extends Number> Num<T, ?> constant(T value) {
        return (Num)Const.make(value);
    }

    public static Int constant(Integer value) {
        return (Int)Const.make(value);
    }

    public static Long constant(java.lang.Long value) {
        return (Long)Const.make(value);
    }

    public static Real constant(Double value) {
        return (Real)Const.make(value);
    }

    public static Decimal constant(BigDecimal value) {
        return (Decimal)Const.make(value);
    }

    public static Criteria constant(Boolean value) {
        return (Criteria)Const.make(value);
    }

    public static Str constant(String value) {
        return (Str)Const.make(value);
    }

    public static DTime constant(DateTime value) {
        return (DTime)Const.make(value);
    }

    public static Date constant(DateOnly value) {
        return (Date)Const.make(value);
    }

    public static <T extends java.lang.Enum<T>, I> Enum<T, I> constant(T value) {
        return (Enum)Const.make(value);
    }

    public static <T extends java.lang.Enum<T>, I> EnumerationSet<T, I> constant(EnumSet<T> value) {
        return (EnumerationSet)Const.make(value);
    }

    public static class Null
    extends Operation<Object> {
        Null() {
            super(ExprOperator.NULL, new Expr[0]);
        }

        @Override
        @NotNull
        public Class<Object> getType() {
            return Object.class;
        }

        @Override
        @Nullable
        public Object getValueFromResultSet(ResultSet rs, int columnIndex) {
            return null;
        }
    }

    public static interface Temporal<T extends DateTimeBase<T>>
    extends Comp<T> {
        @Pure
        default public Int day() {
            return new Operation.Int(ExprOperator.DAY, this);
        }

        @Pure
        default public Int month() {
            return new Operation.Int(ExprOperator.MONTH, this);
        }

        @Pure
        default public Int year() {
            return new Operation.Int(ExprOperator.YEAR, this);
        }
    }

    public static interface Str
    extends Comp<String> {
        @Pure
        default public Criteria contains(@Nullable String str) {
            return str == null ? Criteria.EMPTY : this.bool(ExprOperator.LIKE, Expr.constant("%" + str + "%"));
        }

        @Pure
        default public Criteria equalsIgnoreCase(Str right) {
            return this.lower().eq(right.lower());
        }

        @Pure
        default public Criteria equalsIgnoreCase(String right) {
            return this.lower().eq(right);
        }

        @Pure
        default public Int length() {
            return new Operation.Int(ExprOperator.STRING_LENGTH, this);
        }

        @Pure
        default public Str lower() {
            return this.unary(ExprOperator.LOWER);
        }

        @Override
        default public OrderSpec<String> nlsSort(String sort) {
            return new OrderSpecImpl<String>(this, false, null, sort);
        }

        @Pure
        default public Criteria startsWith(@Nullable String str) {
            return str == null ? Criteria.EMPTY : this.bool(ExprOperator.LIKE, Expr.constant(str + "%"));
        }

        @Pure
        default public Str substr(int startingPosition) {
            return new Operation.Str(ExprOperator.SUBSTR1, (Expr<?>)this, (Expr<?>[])new Expr[]{Expr.constant(startingPosition)});
        }

        @Pure
        default public Str substr(Num<?, ?> startingPosition) {
            return new Operation.Str(ExprOperator.SUBSTR1, (Expr<?>)this, (Expr<?>[])new Expr[]{startingPosition});
        }

        @Pure
        default public Str substr(int startingPosition, int length) {
            return new Operation.Str(ExprOperator.SUBSTR, (Expr<?>)this, (Expr<?>[])new Expr[]{Expr.constant(startingPosition), Expr.constant(length)});
        }

        @Pure
        default public Str substr(Num<?, ?> startingPosition, Num<?, ?> length) {
            return new Operation.Str(ExprOperator.SUBSTR, (Expr<?>)this, (Expr<?>[])new Expr[]{startingPosition, length});
        }

        @Override
        default public Str unary(ExprOperator operator) {
            return new Operation.Str(operator, (Expr<?>)this, (Expr<?>[])new Expr[0]);
        }

        default public Str upper() {
            return this.unary(ExprOperator.UPPER);
        }

        @Override
        @NotNull
        default public Class<String> getType() {
            return String.class;
        }

        @Override
        @Nullable
        default public String getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            String string = rs.getString(columnIndex);
            return string != null && !string.isEmpty() && string.charAt(0) == '\u00a0' ? "" : string;
        }

        @Pure
        default public Criteria isEmpty() {
            return this.isNull().or(this.eq(new Operation.Str(ExprOperator.EMPTY_STRING)));
        }

        @Pure
        default public Criteria isNotEmpty() {
            return this.isNotNull().and(this.ne(new Operation.Str(ExprOperator.EMPTY_STRING)));
        }
    }

    public static interface Real
    extends Num<Double, Real> {
        @Override
        default public Real binary(ExprOperator operator, Expr<?> right) {
            return new Operation.Real(operator, new Expr[]{this, right});
        }

        @Override
        default public Real fromNumber(Number n) {
            return Expr.constant(n.doubleValue());
        }

        @Override
        default public Real unary(ExprOperator operator) {
            return new Operation.Real(operator, this);
        }

        @Override
        @NotNull
        default public Class<Double> getType() {
            return Double.class;
        }

        @Override
        default public Double getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            double d = rs.getDouble(columnIndex);
            return rs.wasNull() ? null : Double.valueOf(d);
        }
    }

    public static interface Num<T extends Number, ET extends Comp<T>>
    extends Comp<T> {
        @Pure
        default public ET abs() {
            return (ET)this.unary(ExprOperator.ABS);
        }

        @Pure
        default public <N extends Number> ET add(Expr<N> right) {
            return this.binary(ExprOperator.ADD, right);
        }

        @Pure
        default public <N extends Number> ET add(N right) {
            return this.binary(ExprOperator.ADD, Expr.constant(right));
        }

        @Pure
        default public ET avg() {
            return (ET)this.unary(ExprOperator.AVG);
        }

        @Pure
        public ET binary(ExprOperator var1, Expr<?> var2);

        @Pure
        default public ET ceil() {
            return (ET)this.unary(ExprOperator.CEIL);
        }

        @Pure
        default public <N extends Number> ET div(Expr<N> right) {
            return this.binary(ExprOperator.DIV, right);
        }

        @Pure
        default public <N extends Number> ET div(N right) {
            return this.binary(ExprOperator.DIV, Expr.constant(right));
        }

        @Override
        default public Criteria eq(Number right) {
            return this.bool(ExprOperator.EQ, new Expr[]{this.fromNumber(right)});
        }

        @Pure
        default public <N extends Number> ET exp() {
            return (ET)this.unary(ExprOperator.EXP);
        }

        @Pure
        default public ET floor() {
            return (ET)this.unary(ExprOperator.FLOOR);
        }

        public ET fromNumber(Number var1);

        @Override
        default public Criteria ge(Number right) {
            return this.bool(ExprOperator.GE, new Expr[]{this.fromNumber(right)});
        }

        @Override
        default public Criteria gt(Number right) {
            return this.bool(ExprOperator.GT, new Expr[]{this.fromNumber(right)});
        }

        @Override
        default public Criteria le(Number right) {
            return this.bool(ExprOperator.LE, new Expr[]{this.fromNumber(right)});
        }

        @Pure
        default public <N extends Number> ET ln() {
            return (ET)this.unary(ExprOperator.LN);
        }

        @Override
        default public Criteria lt(Number right) {
            return this.bool(ExprOperator.LT, new Expr[]{this.fromNumber(right)});
        }

        default public ET max() {
            return (ET)this.unary(ExprOperator.MAX);
        }

        default public ET min() {
            return (ET)this.unary(ExprOperator.MIN);
        }

        @Pure
        default public <N extends Number> ET mod(Expr<N> right) {
            return this.binary(ExprOperator.MOD, right);
        }

        @Pure
        default public <N extends Number> ET mod(N right) {
            return this.binary(ExprOperator.MOD, Expr.constant(right));
        }

        @Pure
        default public <N extends Number> ET mul(Expr<N> right) {
            return this.binary(ExprOperator.MUL, right);
        }

        @Pure
        default public <N extends Number> ET mul(N right) {
            return this.binary(ExprOperator.MUL, Expr.constant(right));
        }

        @Override
        default public Criteria ne(Number right) {
            return this.bool(ExprOperator.NE, new Expr[]{this.fromNumber(right)});
        }

        @Pure
        default public ET negate() {
            return (ET)this.unary(ExprOperator.NEGATE);
        }

        @Pure
        default public <N extends Number> ET pow(Expr<N> right) {
            return this.binary(ExprOperator.POW, right);
        }

        @Pure
        default public <N extends Number> ET pow(N right) {
            return this.binary(ExprOperator.POW, Expr.constant(right));
        }

        @Pure
        default public ET round() {
            return this.binary(ExprOperator.ROUND, Const.ZERO);
        }

        @Pure
        default public ET round(int precision) {
            return this.binary(ExprOperator.ROUND, Expr.constant(precision));
        }

        @Pure
        default public <N extends Number> ET sub(Expr<N> right) {
            return this.binary(ExprOperator.SUB, right);
        }

        @Pure
        default public <N extends Number> ET sub(N right) {
            return this.binary(ExprOperator.SUB, Expr.constant(right));
        }

        @Pure
        default public ET sum() {
            return (ET)this.unary(ExprOperator.SUM);
        }

        @Pure
        default public ET trunc() {
            return this.binary(ExprOperator.TRUNC, Const.ZERO);
        }

        @Pure
        default public ET trunc(int precision) {
            return this.binary(ExprOperator.TRUNC, Expr.constant(precision));
        }

        public ET unary(ExprOperator var1);
    }

    public static interface Long
    extends Num<java.lang.Long, Long> {
        @Override
        default public Long binary(ExprOperator operator, Expr<?> right) {
            return new Operation.Long(operator, new Expr[]{this, right});
        }

        @Override
        default public Long fromNumber(Number n) {
            return Expr.constant(n.longValue());
        }

        @Override
        default public Long unary(ExprOperator operator) {
            return new Operation.Long(operator, this);
        }

        @Override
        @NotNull
        default public Class<java.lang.Long> getType() {
            return java.lang.Long.class;
        }

        @Override
        default public java.lang.Long getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            long l = rs.getLong(columnIndex);
            return rs.wasNull() ? null : java.lang.Long.valueOf(l);
        }
    }

    public static interface Int
    extends Num<Integer, Int> {
        @Override
        default public Int binary(ExprOperator operator, Expr<?> right) {
            return new Operation.Int(operator, new Expr[]{this, right});
        }

        @Override
        default public Int fromNumber(Number n) {
            return Expr.constant(n.intValue());
        }

        @Override
        default public Int unary(ExprOperator operator) {
            return new Operation.Int(operator, this);
        }

        @Override
        @NotNull
        default public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        default public Integer getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            int i = rs.getInt(columnIndex);
            return rs.wasNull() ? null : Integer.valueOf(i);
        }
    }

    public static interface EnumerationSet<T extends java.lang.Enum<T>, I>
    extends Expr<EnumSet<T>> {
        @Pure
        default public Criteria contains(T value) {
            return this.bool(ExprOperator.ENUM_CONTAINS, Expr.constant(1 << ((java.lang.Enum)value).ordinal()));
        }

        @Pure
        default public Criteria containsAllOf(EnumSet<T> values) {
            EnumerationSet vs = Expr.constant(values);
            return this.bool(ExprOperator.ENUM_CONTAINS_ALL, vs, vs);
        }

        @Pure
        default public Criteria containsAllOf(T first, T ... values) {
            return this.containsAllOf(EnumSet.of(first, values));
        }

        @Pure
        default public Criteria containsAnyOf(EnumSet<T> values) {
            return this.bool(ExprOperator.ENUM_CONTAINS, Expr.constant(values));
        }

        @Pure
        default public Criteria containsAnyOf(T first, T ... values) {
            return this.containsAnyOf(EnumSet.of(first, values));
        }

        @Pure
        default public Criteria doesNotContain(T value) {
            return this.contains(value).not();
        }

        @Override
        default public Expr<EnumSet<T>> unary(ExprOperator operator) {
            return new Operation.EnumerationSet(operator, this.getEnumType(), this);
        }

        @NotNull
        public Class<T> getEnumType();

        @Override
        @NotNull
        default public Class<EnumSet<T>> getType() {
            return (Class)Predefined.cast(EnumSet.class);
        }

        @Override
        @Nullable
        default public EnumSet<T> getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            long elements = rs.getLong(columnIndex);
            return Enumerations.longToSet(this.getEnumType(), (java.lang.Long)(rs.wasNull() ? null : java.lang.Long.valueOf(elements)));
        }
    }

    public static interface Enum<T extends java.lang.Enum<T>, I>
    extends Comp<T> {
        @Override
        default public Enum<T, I> unary(ExprOperator operator) {
            return new Operation.Enum(operator, this.getType(), this);
        }

        @Override
        @Nullable
        default public T getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            Object key = rs.getObject(columnIndex);
            if (key == null) {
                return null;
            }
            return (T)((java.lang.Enum)Predefined.cast((Object)Enumerations.enumerationValueOf(this.getType(), (Object)key)));
        }
    }

    public static interface DTime
    extends Temporal<DateTime> {
        @Pure
        default public DTime add(int n, TimeUnit timeUnit) {
            return new Operation.DTime(ExprOperator.ADD_SECONDS, new Expr[]{this, Expr.constant(timeUnit.toSeconds(n))});
        }

        @Override
        @Pure
        default public Criteria between(@NotNull DateTimeBase<?> from, @NotNull DateTimeBase<?> to) {
            return this.between(from.toDateTime(), to.toDateTime());
        }

        @Pure
        default public Int hour() {
            return new Operation.Int(ExprOperator.HOUR, this);
        }

        @Pure
        default public Int minute() {
            return new Operation.Int(ExprOperator.MINUTE, this);
        }

        @Pure
        default public Real second() {
            return new Operation.Real(ExprOperator.SECOND, this);
        }

        @Pure
        default public DTime sub(int n, TimeUnit timeUnit) {
            return new Operation.DTime(ExprOperator.SUB_SECONDS, new Expr[]{this, Expr.constant(timeUnit.toSeconds(n))});
        }

        @Override
        default public DTime unary(ExprOperator operator) {
            return new Operation.DTime(operator, this);
        }

        @Override
        @NotNull
        default public Class<DateTime> getType() {
            return DateTime.class;
        }

        @Override
        default public DateTime getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(columnIndex);
            return JdbcUtils.fromTimestamp((Timestamp)timestamp);
        }
    }

    public static interface Decimal
    extends Num<BigDecimal, Decimal> {
        @Override
        @Pure
        default public Decimal binary(ExprOperator operator, Expr<?> right) {
            return new Operation.Decimal(operator, this.getDecimals(), this, right);
        }

        @Override
        @Pure
        default public Decimal fromNumber(Number n) {
            return Expr.constant(n instanceof BigDecimal ? (BigDecimal)n : BigDecimal.valueOf(n.doubleValue()));
        }

        @Override
        default public Decimal unary(ExprOperator operator) {
            return new Operation.Decimal(operator, this.getDecimals(), this);
        }

        public int getDecimals();

        @Override
        @NotNull
        default public Class<BigDecimal> getType() {
            return BigDecimal.class;
        }

        @Override
        @Nullable
        default public BigDecimal getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            BigDecimal value = rs.getBigDecimal(columnIndex);
            return value == null ? null : value.setScale(this.getDecimals(), 6);
        }
    }

    public static interface Date
    extends Temporal<DateOnly> {
        @Pure
        default public Date add(int days) {
            return new Operation.Date(ExprOperator.ADD_SECONDS, new Expr[]{this, Expr.constant(TimeUnit.DAYS.toSeconds(days))});
        }

        @Override
        @Pure
        default public Criteria between(@NotNull DateTimeBase<?> from, @NotNull DateTimeBase<?> to) {
            return this.between(from.toDateOnly(), to.toDateOnly());
        }

        @Pure
        default public Date sub(int days) {
            return new Operation.Date(ExprOperator.SUB_SECONDS, new Expr[]{this, Expr.constant(TimeUnit.DAYS.toSeconds(days))});
        }

        @Override
        default public Date unary(ExprOperator operator) {
            return new Operation.Date(operator, this);
        }

        @Override
        @NotNull
        default public Class<DateOnly> getType() {
            return DateOnly.class;
        }

        @Override
        default public DateOnly getValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return JdbcUtils.fromSqlDate((java.sql.Date)rs.getDate(columnIndex));
        }
    }

    public static interface Comp<T extends Comparable<T>>
    extends Expr<T> {
        @Pure
        default public Criteria between(@NotNull T from, @NotNull T to) {
            return this.bool(ExprOperator.BETWEEN, Expr.constant(from), Expr.constant(to));
        }

        @Pure
        default public Criteria between(@NotNull Expr<T> from, @NotNull Expr<T> to) {
            return this.bool(ExprOperator.BETWEEN, from, to);
        }

        @Pure
        default public Criteria ge(@Nullable T right) {
            return right == null ? Criteria.EMPTY : this.ge(Expr.constant(right));
        }

        @Pure
        default public Criteria ge(Expr<T> right) {
            return this.bool(ExprOperator.GE, right);
        }

        @Pure
        default public Criteria gt(@Nullable T right) {
            return right == null ? Criteria.EMPTY : this.gt(Expr.constant(right));
        }

        @Pure
        default public Criteria gt(Expr<T> right) {
            return this.bool(ExprOperator.GT, right);
        }

        @Pure
        default public Criteria le(@Nullable T right) {
            return right == null ? Criteria.EMPTY : this.le(Expr.constant(right));
        }

        @Pure
        default public Criteria le(Expr<T> right) {
            return this.bool(ExprOperator.LE, right);
        }

        @Pure
        default public Criteria lt(@Nullable T right) {
            return right == null ? Criteria.EMPTY : this.lt(Expr.constant(right));
        }

        @Pure
        default public Criteria lt(Expr<T> right) {
            return this.bool(ExprOperator.LT, right);
        }

        @Pure
        default public Comp<T> max() {
            return this.unary(ExprOperator.MAX);
        }

        @Pure
        default public Comp<T> min() {
            return this.unary(ExprOperator.MIN);
        }

        @Override
        public Comp<T> unary(ExprOperator var1);
    }
}

