/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.StrBuilder;
import mulesoft.database.DbMacro;
import mulesoft.database.SqlConstants;
import mulesoft.persistence.expr.Const;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ExprOperator {
    NULL("null", 0),
    AND("%s", 0, " and "){

        @Override
        public boolean isStrict() {
            return false;
        }
    }
    ,
    OR("(%s)", 0, " or "){

        @Override
        public boolean isStrict() {
            return false;
        }
    }
    ,
    NOT("not (%s)", 1),
    EQ("%s = %s", 2),
    NE("%s != %s", 2),
    GE("%s >= %s", 2),
    GT("%s > %s", 2),
    LE("%s <= %s", 2),
    LT("%s < %s", 2),
    BETWEEN("%s between %s and %s", 3),
    LIKE("%s like %s", 2),
    NOT_LIKE("%s not like %s", 2),
    CASE("case %s", 1),
    IN("%s in (%s)", 1, ","),
    IN_VALUES("%s in (%s)", 2){

        @Override
        int operandsToVisit(int operands) {
            return 1;
        }

        @Override
        String asSql(Object[] operands) {
            String var = (String)operands[0];
            Iterable values = (Iterable)((Const)operands[1]).getValue();
            StrBuilder condition = new StrBuilder().startCollection(" or ");
            StrBuilder clause = new StrBuilder();
            boolean split = false;
            int i = 0;
            for (Object e : values) {
                if (++i >= 1000) {
                    condition.appendFormat(IN.template, new Object[]{var, clause});
                    split = true;
                    clause = new StrBuilder();
                    i = 0;
                }
                clause.appendElement((Object)SqlConstants.sqlValue(e));
            }
            condition.appendFormat(IN.template, new Object[]{var, clause});
            return split ? "(" + condition + ")" : condition.toString();
        }
    }
    ,
    IS_NOT_NULL("%s is not null", 1),
    IS_NULL("%s is null", 1),
    MAX("max(%s)", 1),
    MIN("min(%s)", 1),
    SUM("sum(%s)", 1),
    AVG("avg(%s)", 1),
    COUNT("count(%s)", 1),
    COUNT_DISTINCT("count(distinct %s)", 1),
    COUNT_ALL("count(*)", 0),
    CURRENT_TIME(DbMacro.CurrentTime, 0),
    CURRENT_DATE(DbMacro.CurrentDate, 0),
    ABS("abs(%s)", 1),
    ADD("(%s + %s)", 2),
    CEIL("ceil(%s)", 1),
    DIV("%s / %s", 2),
    EXP("exp(%s)", 1),
    FLOOR("floor(%s)", 1),
    LN("ln(%s)", 1),
    MOD("mod(%s, %s)", 2),
    MUL("%s * %s", 2),
    NEGATE("-(%s)", 1),
    POW("power(%s, %s)", 2),
    ROUND("round(%s, %s)", 2),
    SUB("(%s - %s)", 2),
    TRUNC("trunc(%s, %s)", 2),
    STRING_LENGTH("length(%s)", 1),
    LOWER("lower(%s)", 1),
    UPPER("upper(%s)", 1),
    SUBSTR("substr(%s,%s,%s)", 3),
    SUBSTR1("substr(%s,%s)", 2),
    CONCAT("%s", 0, " || "),
    EMPTY_STRING(DbMacro.EmptyString.id(), 0),
    DAY("extract(day from %s)", 1),
    MONTH("extract(month from %s)", 1),
    YEAR("extract(year from %s)", 1),
    HOUR("extract(hour from %s)", 1),
    MINUTE("extract(minute from %s)", 1),
    SECOND("extract(second from %s)", 1),
    ADD_SECONDS("(%s + interval '%s' second)", 2),
    SUB_SECONDS("(%s - interval '%s' second)", 2),
    ENUM_CONTAINS("bitand(%s, %s) != 0", 2),
    ENUM_CONTAINS_ALL("bitand(%s, %s) = %s", 3);

    private final int arity;
    private final String separator;
    @NotNull
    private final String template;

    private ExprOperator(String template, int arity) {
        this(template, arity, (String)null);
    }

    private ExprOperator(DbMacro macro, int arity) {
        this(macro.name(), arity);
    }

    private ExprOperator(@Nullable String template, int arity, String separator) {
        this.template = template;
        this.arity = arity;
        this.separator = separator;
    }

    public boolean hasVarArgs() {
        return this.separator != null;
    }

    public boolean supportsNull() {
        return false;
    }

    public int validateArity(Object[] operands) {
        int n = operands.length;
        if (this.hasVarArgs()) {
            return n;
        }
        if (this.arity != n) {
            throw new IllegalArgumentException(String.format("Invalid number of operands %d vs %d", n, this.arity));
        }
        return this.arity;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isStrict() {
        return true;
    }

    String asSql(Object[] operands) {
        return String.format(this.template, this.processOperands(operands));
    }

    int operandsToVisit(int operands) {
        return operands;
    }

    private Object[] processOperands(Object[] operands) {
        if (this.separator == null) {
            return operands;
        }
        Object[] args = new Object[this.arity + 1];
        System.arraycopy(operands, 0, args, 0, this.arity);
        args[this.arity] = ImmutableList.fromArray((Object[])operands).drop(this.arity).mkString(this.separator);
        return args;
    }
}

