/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumSet;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.DateOnly;
import mulesoft.common.core.DateTime;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.expr.ExprImpl;
import mulesoft.persistence.expr.ExprOperator;
import mulesoft.persistence.expr.ExprVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class Operation<T>
extends ExprImpl<T> {
    private final Expr<?>[] operands;
    private final ExprOperator operator;

    Operation(ExprOperator operator, Expr<?> ... operands) {
        this.operator = operator;
        this.operands = operands;
    }

    Operation(ExprOperator operator, Expr<?> first, Expr<?> ... rest) {
        this.operator = operator;
        this.operands = new Expr[rest.length + 1];
        this.operands[0] = first;
        System.arraycopy(rest, 0, this.operands, 1, rest.length);
    }

    @Override
    public <Q> Q accept(ExprVisitor<Q> visitor) {
        return visitor.visit(this.operator, this.visitOperands(visitor));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)obj;
        return this.operator == op.operator && Arrays.equals(this.operands, op.operands);
    }

    public int hashCode() {
        return Predefined.hashCodeAll((Object)((Object)this.operator), (Object[])this.operands);
    }

    @NotNull
    public <Q> Object[] visitOperands(ExprVisitor<Q> visitor) {
        int n = this.operator.validateArity(this.operands);
        int m = this.operator.operandsToVisit(n);
        Object[] ops = new Object[n];
        for (int i = 0; i < n; ++i) {
            ops[i] = i < m && (this.operator.isStrict() || !visitor.supportsLaziness()) ? this.operands[i].accept(visitor) : this.operands[i];
        }
        return ops;
    }

    public Expr<?>[] getOperands() {
        return this.operands;
    }

    public ExprOperator getOperator() {
        return this.operator;
    }

    void overrideOperand(Expr<T> operand) {
        if (this.operands.length == 1) {
            this.operands[0] = operand;
        }
    }

    public static Criteria boolOperation(ExprOperator operator, Iterable<Criteria> criteriaList) {
        Seq cs = Colls.immutable(criteriaList).filter(c -> c != null && c != Criteria.EMPTY);
        return (Criteria)cs.getFirst().map(first -> Operation.boolOperation(operator, first, (Criteria[])cs.drop(1).toArray(Criteria[]::new))).orElse((Object)Criteria.TRUE);
    }

    public static Criteria boolOperation(ExprOperator operator, Criteria first, Criteria[] rest) {
        return rest.length == 0 ? first : first.bool(operator, rest);
    }

    static class Str
    extends Operation<String>
    implements Expr.Str {
        Str(ExprOperator operator) {
            super(operator, new Expr[0]);
        }

        Str(ExprOperator operator, Expr<?> first, Expr<?> ... rest) {
            super(operator, first, rest);
        }
    }

    static class Real
    extends Operation<Double>
    implements Expr.Real {
        Real(ExprOperator operator, Expr<?> ... operands) {
            super(operator, operands);
        }
    }

    static class Long
    extends Operation<java.lang.Long>
    implements Expr.Long {
        Long(ExprOperator operator, Expr<?> ... operands) {
            super(operator, operands);
        }
    }

    static class Int
    extends Operation<Integer>
    implements Expr.Int {
        Int(ExprOperator operator, Expr<?> ... operands) {
            super(operator, operands);
        }
    }

    static class EnumerationSet<T extends java.lang.Enum<T>, I>
    extends Operation<EnumSet<T>>
    implements Expr.EnumerationSet<T, I> {
        private final Class<T> enumType;

        EnumerationSet(ExprOperator operator, Class<T> enumType, Expr<?> ... operands) {
            super(operator, operands);
            this.enumType = enumType;
        }

        @Override
        @NotNull
        public Class<T> getEnumType() {
            return this.enumType;
        }
    }

    static class Enum<T extends java.lang.Enum<T>, I>
    extends Operation<T>
    implements Expr.Enum<T, I> {
        private final Class<T> enumType;

        Enum(ExprOperator operator, Class<T> enumType, Expr<?> ... operands) {
            super(operator, operands);
            this.enumType = enumType;
        }

        @Override
        @NotNull
        public Class<T> getType() {
            return this.enumType;
        }
    }

    static class DTime
    extends Operation<DateTime>
    implements Expr.DTime {
        DTime(ExprOperator operator, Expr<?> ... operands) {
            super(operator, operands);
        }
    }

    static class Decimal
    extends Operation<BigDecimal>
    implements Expr.Decimal {
        private final int decimals;

        Decimal(ExprOperator operator, int decimals, Expr<?> ... operands) {
            super(operator, operands);
            this.decimals = decimals;
        }

        @Override
        public int getDecimals() {
            return this.decimals;
        }
    }

    static class Date
    extends Operation<DateOnly>
    implements Expr.Date {
        Date(ExprOperator operator, Expr<?> ... operands) {
            super(operator, operands);
        }
    }

    static class Bool
    extends Operation<Boolean>
    implements Criteria {
        Bool(ExprOperator operator, Expr<?> first, Expr<?>[] expr) {
            super(operator, first, expr);
        }
    }
}

