/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.expr;

import mulesoft.common.core.Option;
import mulesoft.database.DbMacro;
import mulesoft.persistence.OrderSpec;
import mulesoft.persistence.expr.Expr;
import org.jetbrains.annotations.Nullable;

class OrderSpecImpl<T>
implements OrderSpec<T> {
    private final boolean descending;
    private final Option<String> nlsSort;
    @Nullable
    private final Boolean nullsFirst;
    private final Expr<T> target;

    OrderSpecImpl(Expr<T> target, boolean descending, @Nullable Boolean nullsFirst, @Nullable String nlsSort) {
        this.target = target;
        this.descending = descending;
        this.nullsFirst = nullsFirst;
        this.nlsSort = Option.option((Object)nlsSort);
    }

    @Override
    public String asSql(boolean qualify) {
        String sql = this.target.asSql(qualify);
        StringBuilder s = new StringBuilder(this.nlsSort.isPresent() ? DbMacro.NlsSort.id() + "(" + sql + "," + (String)this.nlsSort.get() + ")" : sql);
        if (this.descending) {
            s.append(" desc");
        }
        if (this.nullsFirst != null) {
            s.append(this.nullsFirst != false ? " nulls first" : " nulls last");
        }
        return s.toString();
    }

    @Override
    public OrderSpec<T> descending() {
        return new OrderSpecImpl<T>(this.target, true, this.nullsFirst, (String)this.nlsSort.getOrNull());
    }

    @Override
    public OrderSpec<T> nlsSort(String sort) {
        return new OrderSpecImpl<T>(this.target, this.descending, this.nullsFirst, sort);
    }

    @Override
    public OrderSpec<T> nullsFirst() {
        return new OrderSpecImpl<T>(this.target, this.descending, true, (String)this.nlsSort.getOrNull());
    }

    @Override
    public OrderSpec<T> nullsLast() {
        return new OrderSpecImpl<T>(this.target, this.descending, false, (String)this.nlsSort.getOrNull());
    }
}

