/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.resource;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Metadata;
import mulesoft.common.core.Resource;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.Mimes;
import mulesoft.common.util.Files;
import mulesoft.common.util.Sha;
import mulesoft.database.Database;
import mulesoft.database.SqlStatement;
import mulesoft.database.type.Lob;
import mulesoft.persistence.exception.ResourceException;
import mulesoft.persistence.resource.ResourcesConstants;
import mulesoft.transaction.Transaction;
import mulesoft.type.resource.AbstractResource;
import mulesoft.type.resource.SimpleResourceImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbResource
extends AbstractResource {
    private final Database db;
    private Map<String, Resource.Entry> entries;
    @NonNls
    public static final String UNNAMED = "unnamed";
    private static final Logger logger = Logger.getLogger(DbResource.class);
    private static final long serialVersionUID = -8067556336370518474L;

    public DbResource(Database db, String uuid) {
        super(uuid);
        this.db = db;
        this.entries = null;
    }

    public Resource.Factory addLarge() {
        return this.addVariant("LARGE");
    }

    public Resource.Factory addThumb() {
        return this.addVariant("THUMB");
    }

    public Resource.Factory addVariant(String variant) {
        return new DbFactory(this, variant);
    }

    public SimpleResourceImpl asSimple() {
        return new SimpleResourceImpl(this.getUuid(), this.entries());
    }

    @NotNull
    protected Map<String, Resource.Entry> entries() {
        if (this.entries != null) {
            return this.entries;
        }
        return this.loadEntries();
    }

    private void addEntry(@NotNull String variant, boolean external, @NotNull String name, @NotNull String url, @NotNull String mimeType, @NotNull Metadata metadata) {
        DbEntry e = new DbEntry(variant, external, name, url, mimeType, metadata);
        this.entries().put(e.getVariant(), (Resource.Entry)e);
    }

    private HashMap<String, Resource.Entry> buildEntryMap(Seq<EntryInfo> es) {
        HashMap<String, Resource.Entry> entriesMap = new HashMap<String, Resource.Entry>();
        for (EntryInfo e : es) {
            entriesMap.put(e.variant, (Resource.Entry)new DbEntry(e.variant, e.external, e.name, e.url, e.mimeType, e.metadata));
        }
        return entriesMap;
    }

    private SqlStatement insertInto(String table, String ... columns) {
        StrBuilder cols = new StrBuilder();
        StrBuilder values = new StrBuilder();
        for (String c : columns) {
            cols.appendElement((Object)c);
            values.appendElement((Object)"?");
        }
        return this.db.sqlStatement("insert into Schema(SG).%s (%s) values (%s)", new Object[]{table, cols.toString(), values.toString()});
    }

    @NotNull
    private synchronized Map<String, Resource.Entry> loadEntries() {
        if (this.entries == null) {
            this.entries = this.buildEntryMap((Seq<EntryInfo>)DbResource.loadEntries(this.db, (Seq<String>)Colls.listOf((Object)this.getUuid())));
        }
        return this.entries;
    }

    private Resource upload(@NotNull String name, @NotNull String mimeType, @NotNull ContentData content, @NotNull String variant) {
        if (!DbResource.exists(this.db, content.sha)) {
            this.insertInto("RESOURCE_CONTENT", ResourcesConstants.SHA, ResourcesConstants.SIZE, ResourcesConstants.MIME_TYPE, content.lob.isClob() ? ResourcesConstants.TEXT_DATA : ResourcesConstants.BINARY_DATA).onArgs(new Object[]{content.sha, content.getSize(), mimeType, content.lob}).executeDml();
        }
        Lob lob = Lob.createClob((String)DbResource.clobToString(content.getMetadata()));
        this.insertInto("RESOURCE_INDEX", ResourcesConstants.UUID, ResourcesConstants.VARIANT, ResourcesConstants.EXTERNAL, ResourcesConstants.NAME, ResourcesConstants.URL, ResourcesConstants.INFO).onArgs(new Object[]{this.getUuid(), variant, false, name, content.sha, lob}).executeDml();
        this.addEntry(variant, false, name, content.sha, mimeType, content.getMetadata());
        return this;
    }

    private Resource upload(@NotNull String name, @NotNull String url, @NotNull String variant, boolean external, @NotNull String mimeType) {
        this.insertInto("RESOURCE_INDEX", ResourcesConstants.UUID, ResourcesConstants.VARIANT, ResourcesConstants.EXTERNAL, ResourcesConstants.NAME, ResourcesConstants.URL).onArgs(new Object[]{this.getUuid(), variant, external, name, url}).executeDml();
        this.addEntry(variant, external, name, url, mimeType, Metadata.empty());
        return this;
    }

    private Object writeReplace() {
        return new SimpleResourceImpl(this.getUuid(), this.entries());
    }

    public static <T> String clobToString(@NotNull T content) {
        String clob = "";
        return clob;
    }

    @NotNull
    public static ImmutableList<EntryInfo> loadEntries(Database db, Seq<String> uuids) {
        return (ImmutableList)Transaction.invokeInTransaction(() -> {
            ArrayList result = new ArrayList();
            for (int i = 0; i < uuids.size(); i += 1000) {
                int to = Math.min(i + 1000, uuids.size());
                StringBuilder uuidsStrings = new StringBuilder();
                for (String s : uuids.slice(i, to)) {
                    uuidsStrings.append("'").append(s).append("'").append(",");
                }
                result.addAll(db.sqlStatement("select R.UUID, R.VARIANT, R.EXTERNAL, R.URL, R.NAME, R.INFO, C.MIME_TYPE from QName(SG, RESOURCE_INDEX) R left outer join QName(SG, RESOURCE_CONTENT) C on R.URL = C.SHA where R.UUID in (%s)", new Object[]{uuidsStrings.deleteCharAt(uuidsStrings.length() - 1).toString()}).list(rs -> {
                    Clob clob;
                    InputStream stream = db.getDatabaseType().supportsLobs() ? ((clob = rs.getClob(6)) != null ? clob.getAsciiStream() : null) : rs.getBinaryStream(6);
                    try {
                        return new EntryInfo(rs.getString(1), rs.getString(2), rs.getBoolean(3), rs.getString(4), (String)Predefined.notNull((Object)rs.getString(5), (Object)"NoName"), stream, (String)Predefined.notNull((Object)rs.getString(7), (Object)""));
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                        return null;
                    }
                }));
            }
            return Colls.immutable(result);
        });
    }

    static int downloadTo(Database db, String sha, OutputStream os) {
        return (Integer)Transaction.invokeInTransaction(() -> {
            InputStream is;
            SqlStatement select = DbResource.select(db, ResourcesConstants.BINARY_DATA, sha);
            if (!db.getDatabaseType().supportsLobs()) {
                is = (InputStream)select.get(InputStream.class);
            } else {
                try {
                    Blob blob = (Blob)select.get(Blob.class);
                    assert (blob != null);
                    is = blob.getBinaryStream();
                }
                catch (SQLException e) {
                    throw ResourceException.errorLoading(sha, e);
                }
            }
            if (is == null) {
                throw ResourceException.notFound(sha);
            }
            return Files.copy((InputStream)is, (OutputStream)os, (boolean)false);
        });
    }

    static int downloadTo(Database db, String sha, Writer writer) {
        return (Integer)Transaction.invokeInTransaction(() -> {
            Reader r;
            SqlStatement select = DbResource.select(db, ResourcesConstants.TEXT_DATA, sha);
            if (!db.getDatabaseType().supportsLobs()) {
                r = (Reader)select.get(Reader.class);
            } else {
                try {
                    Clob clob = (Clob)select.get(Clob.class);
                    assert (clob != null);
                    r = clob.getCharacterStream();
                }
                catch (SQLException e) {
                    throw ResourceException.errorLoading(sha, e);
                }
            }
            if (r == null) {
                throw ResourceException.notFound(sha);
            }
            return Files.copy((Reader)r, (Writer)writer);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int downloadTo(Database db, String sha, String mimeType, OutputStream os) {
        if (!Mimes.isText((String)mimeType)) return DbResource.downloadTo(db, sha, os);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));){
            int n = DbResource.downloadTo(db, sha, writer);
            return n;
        }
        catch (IOException e) {
            throw ResourceException.errorLoading(sha, e);
        }
    }

    @Nullable
    static String mimeType(Database db, String sha) {
        return (String)Transaction.invokeInTransaction(() -> (String)DbResource.select(db, ResourcesConstants.MIME_TYPE, sha).get(String.class));
    }

    private static boolean exists(Database db, String sha) {
        return DbResource.select(db, ResourcesConstants.SHA, sha).get(String.class) != null;
    }

    @NotNull
    private static SqlStatement select(Database db, String data, String sha) {
        return db.sqlStatement("select %s from QName(SG, RESOURCE_CONTENT) where SHA = ?", new Object[]{data}).onArgs(new Object[]{sha});
    }

    public static class EntryInfo {
        private final boolean external;
        @NotNull
        private final Metadata metadata;
        @NotNull
        private final String mimeType;
        @NotNull
        private final String name;
        @NotNull
        private final String url;
        @NotNull
        private final String uuid;
        @NotNull
        private final String variant;

        EntryInfo(@NotNull String uuid, @NotNull String variant, boolean external, @NotNull String url, @NotNull String name, @Nullable InputStream metadata, @NotNull String mimeType) throws IOException {
            this.uuid = uuid;
            this.variant = variant;
            this.external = external;
            this.name = name;
            this.url = url;
            this.mimeType = mimeType;
            this.metadata = Metadata.empty();
        }

        public boolean isExternal() {
            return this.external;
        }

        @NotNull
        public Metadata getMetadata() {
            return this.metadata;
        }

        @NotNull
        public String getMimeType() {
            return this.mimeType;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getUrl() {
            return this.url;
        }

        @NotNull
        public String getUUID() {
            return this.uuid;
        }

        @NotNull
        public String getVariant() {
            return this.variant;
        }
    }

    static class DbFactory
    implements Resource.Factory {
        private final DbResource resource;
        private final String variant;

        public DbFactory(DbResource resource, String variant) {
            this.resource = resource;
            this.variant = variant;
        }

        public Resource upload(@NotNull File file) {
            String name = file.getName();
            String mimeType = Mimes.getMimeType((String)name);
            try {
                return Mimes.isText((String)mimeType) ? this.upload(name, mimeType, new FileReader(file)) : this.upload(name, mimeType, new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Resource upload(@NotNull String name, @NotNull String url) {
            return (Resource)Transaction.invokeInTransaction(() -> this.resource.upload(name, url, this.variant, true, ""));
        }

        public Resource upload(@NotNull String name, @NotNull String mimeType, @NotNull Reader reader) {
            if (!Mimes.isText((String)mimeType)) {
                throw new IllegalArgumentException("Invalid Text Type: " + mimeType);
            }
            return (Resource)Transaction.invokeInTransaction(() -> this.resource.upload(name, mimeType, ContentData.generateSha(reader), this.variant));
        }

        public Resource upload(@NotNull String name, @NotNull String mimeType, @NotNull InputStream inputStream) {
            if (Mimes.isText((String)mimeType)) {
                throw new IllegalArgumentException("Invalid Binary Type: " + mimeType);
            }
            return (Resource)Transaction.invokeInTransaction(() -> this.resource.upload(name, mimeType, ContentData.generateSha(inputStream, mimeType), this.variant));
        }

        public Resource uploadFromSha(@NotNull String name, @NotNull String sha, @NotNull String mimeType) {
            return this.resource.upload(name, sha, this.variant, false, mimeType);
        }
    }

    class DbEntry
    extends AbstractResource.EntryImpl {
        private static final long serialVersionUID = 3682132665148280917L;

        DbEntry(String variant, @NotNull boolean external, @NotNull String name, @NotNull String url, @NotNull String mimeType, Metadata metadata) {
            super(variant, external, name, url, mimeType, metadata);
        }

        public int copyTo(Writer writer) {
            return DbResource.downloadTo(DbResource.this.db, this.getSha(), writer);
        }

        public int copyTo(OutputStream os) {
            return DbResource.downloadTo(DbResource.this.db, this.getSha(), this.getMimeType(), os);
        }
    }

    static class ContentData {
        private final Lob lob;
        private final Metadata metadata;
        private final String sha;

        ContentData(String sha, char[] chars) {
            this(sha, Lob.createClob((char[])chars), Metadata.empty());
        }

        ContentData(String sha, Lob lob, Metadata metadata) {
            this.sha = sha;
            this.lob = lob;
            this.metadata = metadata;
        }

        ContentData(String sha, byte[] bytes, Metadata metadata) {
            this(sha, Lob.createBlob((InputStream)new ByteArrayInputStream(bytes), (int)bytes.length), metadata);
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public int getSize() {
            return this.lob.getSize();
        }

        static ContentData generateSha(Reader reader) {
            Sha sha = new Sha();
            char[] outChars = sha.filter(reader);
            return new ContentData(sha.getDigestAsString(), outChars);
        }

        static ContentData generateSha(InputStream inputStream, String mimeType) {
            Sha sha = new Sha();
            byte[] outBytes = sha.filter(inputStream);
            return new ContentData(sha.getDigestAsString(), outBytes, ContentData.createMetadata(mimeType, outBytes));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        static Dimension getDimension(String mimeType, byte[] bytes) {
            if (!Mimes.isImage((String)mimeType)) {
                return null;
            }
            try (ImageInputStream is = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));){
                Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(is);
                if (!imageReaders.hasNext()) return null;
                ImageReader reader = imageReaders.next();
                reader.setInput(is);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            return null;
        }

        private static Metadata createMetadata(String mimeType, byte[] outBytes) {
            Dimension dimension = ContentData.getDimension(mimeType, outBytes);
            double width = -1.0;
            double height = -1.0;
            if (dimension != null) {
                width = dimension.getWidth();
                height = dimension.getHeight();
            }
            return Metadata.create().withDimension(width, height).withSize(outBytes.length);
        }
    }
}

