/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.resource;

import java.io.OutputStream;
import java.io.Writer;
import java.util.UUID;
import mulesoft.common.core.Option;
import mulesoft.common.core.Resource;
import mulesoft.common.env.Environment;
import mulesoft.database.Database;
import mulesoft.persistence.ResourceHandler;
import mulesoft.persistence.resource.DbResource;
import mulesoft.persistence.resource.ResourcesGC;
import org.jetbrains.annotations.NotNull;

public class DbResourceHandler
implements ResourceHandler {
    @NotNull
    private final Database db;
    private final Environment env;

    public DbResourceHandler(Environment env, @NotNull Database db) {
        this.env = env;
        this.db = db;
    }

    public void collect() {
        ResourcesGC gc = new ResourcesGC(this.env, this.db);
        gc.purge();
    }

    @Override
    public Resource.Factory create() {
        String uuid = UUID.randomUUID().toString();
        return this.create(uuid);
    }

    @Override
    public Resource.Factory create(String uuid) {
        return new DbResource.DbFactory(new DbResource(this.db, uuid), "MASTER");
    }

    @Override
    public Option<Resource.Content> findContent(final String sha) {
        final String mimeType = DbResource.mimeType(this.db, sha);
        if (mimeType == null) {
            return Option.empty();
        }
        Resource.Content c = new Resource.Content(){

            public int copyTo(Writer writer) {
                return DbResource.downloadTo(DbResourceHandler.this.db, sha, writer);
            }

            public int copyTo(OutputStream os) {
                return DbResource.downloadTo(DbResourceHandler.this.db, sha, os);
            }

            public String getMimeType() {
                return mimeType;
            }
        };
        return Option.some((Object)c);
    }

    @Override
    public Option<Resource> findResource(String uuid) {
        DbResource resource = new DbResource(this.db, uuid);
        if (resource.getEntries().isEmpty()) {
            return Option.empty();
        }
        return Option.some((Object)((Object)resource));
    }
}

