/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Resource;
import mulesoft.common.env.Environment;
import mulesoft.common.logging.Logger;
import mulesoft.database.Database;
import mulesoft.database.SqlStatement;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.Sql;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableMetadata;
import mulesoft.transaction.Transaction;
import org.jetbrains.annotations.NotNull;

public class ResourcesGC {
    @NotNull
    private final Database db;
    private final Environment env;
    private final Logger logger = Logger.getLogger(ResourcesGC.class);
    private List<String> resources = Collections.emptyList();
    private static final TableField.Res[] EMPTY_RES = new TableField.Res[0];
    private static final int BATCH_SIZE = 50000;

    public ResourcesGC(Environment env, @NotNull Database db) {
        this.env = env;
        this.db = db;
    }

    public void purge() {
        List<EntityTable<?, ?>> entitiesWithResources = this.getEntitiesWithResources();
        this.readResources(" ");
        if (!this.resources.isEmpty() && entitiesWithResources.isEmpty()) {
            this.logger.error("There are resources but no entities with resources found. This may be an error an will destroy all resources. Aborting");
        } else {
            while (!this.resources.isEmpty()) {
                this.purge(entitiesWithResources);
                this.readResources(this.resources.get(this.resources.size() - 1));
            }
        }
        this.logger.info("Resources purged.");
    }

    private void purge(List<EntityTable<?, ?>> entitiesWithResources) {
        Set<String> strings = ResourcesGC.removeUsed(this.resources, entitiesWithResources);
        if (this.resources.size() == strings.size()) {
            this.logger.warning("ResourcesGCTask - Erasing all resources (" + strings.size() + "). This might be an issue");
        }
        this.db.getTransactionManager().runInTransaction(t -> {
            try (SqlStatement.Prepared deleteIndex = this.db.sqlStatement("delete from %s.RESOURCE_INDEX where UUID = ?", new Object[]{"Schema(SG)"}).prepare();){
                for (String resource : strings) {
                    deleteIndex.onArgs(new Object[]{resource}).batch();
                }
                if (!strings.isEmpty()) {
                    deleteIndex.executeBatch();
                    this.db.sqlStatement("delete from %s.RESOURCE_CONTENT where SHA not in (select URL from %s.RESOURCE_INDEX)", new Object[]{"Schema(SG)", "Schema(SG)"}).execute();
                }
            }
        });
    }

    private void readResources(@NotNull String lastUuid) {
        this.resources = (List)this.db.getTransactionManager().invokeInTransaction(t -> this.db.sqlStatement("select distinct UUID from %s.RESOURCE_INDEX where UUID > ? order by UUID", new Object[]{"Schema(SG)"}).limit(50000L).onArgs(new Object[]{lastUuid}).list(String.class));
    }

    private List<EntityTable<?, ?>> getEntitiesWithResources() {
        ArrayList entities = new ArrayList();
        block0: for (String entityName : TableMetadata.localEntities(this.env)) {
            EntityTable t = EntityTable.forName(entityName);
            for (TableField field : t.getFields()) {
                if (!field.getType().equals(Resource.class)) continue;
                entities.add(t);
                continue block0;
            }
        }
        return entities;
    }

    private static <T extends EntityInstance<T, K>, K> void removedUsed(EntityTable<?, ?> entityTable, Set<String> result) {
        EntityTable entity = (EntityTable)Predefined.cast(entityTable);
        Seq resFields = entity.getFields().filter(TableField.Res.class);
        TableField.Res first = (TableField.Res)resFields.getFirst().get();
        Criteria criteria = (Criteria)resFields.foldLeft((Object)Criteria.EMPTY, (c, res) -> c.or(res.isNotNull()));
        TableField.Res[] fields = resFields.size() > 1 ? (TableField.Res[])resFields.drop(1).toArray(TableField.Res[]::new) : EMPTY_RES;
        Transaction.runInTransaction(() -> Sql.select(first, fields).from(entity.getDbTable()).distinct().where(criteria).list().forEach(instance -> {
            for (int i = 0; i < instance.size(); ++i) {
                Object resource = instance.get(i + 1);
                if (resource == null) continue;
                result.remove(resource.toString());
            }
        }));
    }

    private static Set<String> removeUsed(List<String> resources, List<EntityTable<?, ?>> entityList) {
        HashSet<String> result = new HashSet<String>(resources);
        for (EntityTable<?, ?> entity : entityList) {
            ResourcesGC.removedUsed(entity, result);
        }
        return result;
    }
}

