/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.sql;

import java.util.function.Function;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Option;
import mulesoft.common.core.StepResult;
import mulesoft.common.util.LruCache;
import mulesoft.database.Database;
import mulesoft.database.RowHandler;
import mulesoft.database.RowMapper;
import mulesoft.database.SqlStatement;
import mulesoft.persistence.QueryTuple;
import mulesoft.persistence.Select;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.sql.SqlBaseSelectHandler;
import mulesoft.persistence.sql.StatementBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlSelectHandler<R>
extends SqlBaseSelectHandler<R> {
    @NotNull
    private final Database db;
    @NotNull
    private final RowMapper<R> entityRowMapper;
    private static final int MAX_CACHE_WEIGHT = 100000;
    private static final LruCache<CacheEntry, CacheEntry> cache = new LruCache.Builder().weigher(CacheEntry::weight).maxWeight(100000).withExpiration(CacheEntry::getExpiration).build();

    SqlSelectHandler(@NotNull Select<R> select, @NotNull Database db, @NotNull RowMapper<?> entityRowMapper) {
        super(select);
        this.db = db;
        this.entityRowMapper = (RowMapper)Predefined.cast(entityRowMapper);
    }

    @Override
    protected long count() {
        ImmutableList rs;
        String sql = this.asSql(Expr.COUNT_ALL);
        if (sql == null) {
            return 0L;
        }
        if (this.getGroupBy().length > 0) {
            sql = StatementBuilder.buildNestedSelect(StatementBuilder.convertToSql(false, false, Expr.COUNT_ALL), "(" + sql + ")");
        }
        return (rs = this.list(sql, 0L, 1L, r -> r.getLong(1))).isEmpty() ? 0L : (Long)rs.get(0);
    }

    @Override
    protected boolean exists() {
        String sql = this.asSql(Expr.constant(1));
        return sql != null && !this.list(sql, 0L, 1L, rs -> rs.getInt(1)).isEmpty();
    }

    @Override
    protected <S> Option<S> forEachReturning(Function<? super R, StepResult<S>> step, Option<S> finalValue) {
        SqlStatement sqlStatement = this.selectStatement();
        if (sqlStatement == null) {
            return Option.empty();
        }
        return sqlStatement.forEach(this.rowHandler(step, this.getExpressions()), finalValue, true);
    }

    @Override
    protected R get() {
        Expr<?>[] expressions = this.getExpressions();
        ImmutableList<R> result = this.selectStatement(0L, 1L, expressions);
        return result.isEmpty() ? null : (R)result.get(0);
    }

    @Override
    protected ImmutableList<R> list() {
        long limit = this.getLimit();
        if (limit <= 0L) {
            return Colls.emptyList();
        }
        Expr<?>[] expressions = this.getExpressions();
        return this.selectStatement(this.getOffset(), limit, expressions);
    }

    @NotNull
    private <T> ImmutableList<T> list(String sql, long offset, long limit, RowMapper<T> rowMapper) {
        if (limit == 0L) {
            return Colls.emptyList();
        }
        long cacheTime = this.getCacheTime();
        if (cacheTime <= 0L) {
            return this.listFromDb(sql, offset, limit, rowMapper);
        }
        CacheEntry e = new CacheEntry(sql, offset, limit);
        CacheEntry v = (CacheEntry)cache.get((Object)e);
        return v != null ? v.getResult() : e.cache(this.listFromDb(sql, offset, limit, rowMapper), cacheTime);
    }

    @NotNull
    private <T> ImmutableList<T> listFromDb(String sql, long offset, long limit, RowMapper<T> rowMapper) {
        return this.db.sqlStatement(sql).limit(offset, limit).list(rowMapper);
    }

    private <S> RowHandler<S> rowHandler(Function<? super R, StepResult<S>> step, Expr<?>[] expressions) {
        if (super.getType().equals(QueryTuple.class)) {
            return rs -> {
                Object o = Predefined.cast((Object)QueryTuple.fromResultSet(rs, expressions, this.db));
                return (StepResult)step.apply((R)o);
            };
        }
        RowMapper m = this.rowMapper(expressions);
        return rs -> (StepResult)step.apply((Object)m.mapRow(rs));
    }

    private RowMapper<R> rowMapper(Expr<?>[] expressions) {
        if (expressions.length == 0) {
            return this.entityRowMapper;
        }
        if (expressions.length == 1 && super.getType().equals(expressions[0].getType())) {
            Expr e = (Expr)Predefined.cast(expressions[0]);
            return rs -> e.getValueFromResultSet(rs, 1);
        }
        return QueryTuple.rowMapper(super.getType(), expressions);
    }

    @Nullable
    private SqlStatement selectStatement() {
        Expr<?>[] expressions = this.getExpressions();
        String sql = this.asSql(expressions);
        if (sql == null) {
            return null;
        }
        return this.db.sqlStatement(sql).limit(this.getOffset(), this.getLimit());
    }

    @NotNull
    private ImmutableList<R> selectStatement(long offset, long limit, Expr<?> ... expressions) {
        String sql = this.asSql(expressions);
        return sql == null ? Colls.emptyList() : this.list(sql, offset, limit, this.rowMapper(expressions));
    }

    private static final class CacheEntry {
        private long expiration;
        private final int hash;
        private final long limit;
        private final long offset;
        private ImmutableList<?> result;
        private final String sql;

        CacheEntry(String sql, long offset, long limit) {
            this.sql = sql;
            this.offset = offset;
            this.limit = limit;
            this.result = Colls.emptyList();
            this.hash = sql.hashCode() + 31 * (Long.hashCode(offset) + 31 * Long.hashCode(limit));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)o;
                return this.sql.equals(cacheEntry.sql) && this.offset == cacheEntry.offset && this.limit == cacheEntry.limit;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        int weight() {
            return this.result.size();
        }

        long getExpiration() {
            return this.expiration;
        }

        <R> ImmutableList<R> getResult() {
            return (ImmutableList)Predefined.cast(this.result);
        }

        private <R> ImmutableList<R> cache(ImmutableList<R> rs, long cacheTime) {
            this.result = rs;
            this.expiration = DateTime.currentTimeMillis() + cacheTime;
            cache.put((Object)this, (Object)this);
            return (ImmutableList)Predefined.cast(this.result);
        }
    }
}

