/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.sql;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.DateTime;
import mulesoft.common.util.Reflection;
import mulesoft.database.Database;
import mulesoft.database.DatabaseType;
import mulesoft.database.DbMacro;
import mulesoft.database.ResultHandler;
import mulesoft.database.RowMapper;
import mulesoft.database.SqlStatement;
import mulesoft.database.exception.UniqueViolationException;
import mulesoft.database.support.JdbcUtils;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.Select;
import mulesoft.persistence.SetClause;
import mulesoft.persistence.Sql;
import mulesoft.persistence.StoreHandler;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableMetadata;
import mulesoft.persistence.exception.InstanceVersionMismatchException;
import mulesoft.persistence.sql.SqlSelectHandler;
import mulesoft.persistence.sql.SqlStoreHandlerFactory;
import mulesoft.persistence.sql.StatementBuilder;
import mulesoft.persistence.sql.StatementCache;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStoreHandler<T extends EntityInstance<T, K>, K>
extends StoreHandler<T, K> {
    @NotNull
    private final Database db;
    @NotNull
    private final RowMapper<T> entityRowMapper;
    @NotNull
    private final SqlStoreHandlerFactory factory;
    @NotNull
    private final ResultHandler<T> findResultHandler;
    @Nullable
    private final TableField.Num<?, ?> keyField;
    @NotNull
    private final StatementBuilder stmtBuilder;
    private final ResultHandler<DateTime> updateTimeRetriever;
    private static final int KEY_SET_CHUNK = 1000;

    public SqlStoreHandler(@NotNull SqlStoreHandlerFactory f, @NotNull Database db, @NotNull DbTable<T, K> dbTable) {
        super(dbTable, null);
        TableMetadata<T, K> metadata = dbTable.metadata();
        TableField b = metadata.hasGeneratedKey() ? (TableField)metadata.getPrimaryKey().get(0) : null;
        this.keyField = (TableField.Num)Predefined.cast((Object)b);
        this.db = db;
        this.stmtBuilder = new StatementBuilder(db, dbTable);
        this.findResultHandler = ResultHandler.singleRowHandler(this::doMapRow);
        this.updateTimeRetriever = ResultHandler.singleRowHandler(rs -> JdbcUtils.fromTimestamp((Timestamp)rs.getTimestamp(1)));
        this.entityRowMapper = this::doMapRow;
        this.factory = f;
    }

    @Override
    public boolean checkAndLock(K key, DateTime updateTime) {
        return this.getStatementCache().checkAndLock(this.db, (StatementCache.Proto)Predefined.ensureNotNull((Object)this.stmtBuilder.checkAndLock().get()), key, updateTime);
    }

    @Override
    public void delete(T instance) {
        this.executeStatement(this.stmtBuilder.delete(), instance);
        this.updateLastDeleted();
        this.insertDeletion(instance);
    }

    @Override
    public void delete(Iterable<K> keys) {
        ArrayList<K> keySet = new ArrayList<K>();
        for (K key : keys) {
            keySet.add(key);
            if (keySet.size() != 1000) continue;
            this.stmtBuilder.delete(keySet).execute();
            keySet.clear();
        }
        if (!keySet.isEmpty()) {
            this.stmtBuilder.delete(keySet).execute();
        }
    }

    @Override
    public void deleteWhere(Criteria ... condition) {
        this.insertDeletions(condition);
        this.stmtBuilder.delete(condition);
        this.updateLastDeleted();
    }

    @Override
    public T find(K key) {
        return (T)((EntityInstance)this.getStatementCache().find(this.db, (StatementCache.Proto)Predefined.ensureNotNull((Object)this.stmtBuilder.find().get()), key, this.findResultHandler));
    }

    @Override
    @Nullable
    public T findByKey(int keyId, Object key) {
        return (T)((EntityInstance)this.getStatementCache().find(this.db, this.stmtBuilder.findByKey(keyId), key, this.findResultHandler));
    }

    @Override
    public T findPersisted(K key) {
        return this.find(key);
    }

    @Override
    public int insert(List<SetClause<?>> setClauses) {
        return this.stmtBuilder.insert(setClauses);
    }

    @Override
    public void insert(T instance, boolean generateKey) {
        this.incrementVersion(instance);
        if (generateKey) {
            this.getStatementCache().executeWithKey(this.db, instance, (StatementCache.Proto)Predefined.ensureNotNull((Object)this.stmtBuilder.insertWithKey().get()), this.keyField);
        } else {
            this.executeStatement(this.stmtBuilder.insert(), instance);
        }
    }

    @Override
    public int insertOrUpdate(List<SetClause<?>> insertSetClauses, TableField<?>[] keyColumns, List<SetClause<?>> setClauses, Criteria[] criteria) {
        return this.stmtBuilder.insertOrUpdate(insertSetClauses, keyColumns, setClauses, criteria);
    }

    @Override
    public ImmutableList<T> list(Iterable<K> keys) {
        return ImmutableList.build(b -> {
            ArrayList keySet = new ArrayList();
            for (Object key : keys) {
                keySet.add(key);
                if (keySet.size() != 1000) continue;
                b.addAll((Iterable)this.stmtBuilder.listByKeys(keySet).list(this.entityRowMapper));
                keySet.clear();
            }
            if (!keySet.isEmpty()) {
                b.addAll((Iterable)this.stmtBuilder.listByKeys(keySet).list(this.entityRowMapper));
            }
        });
    }

    @Override
    public void merge(@NotNull T instance) {
        this.executeStatement(this.stmtBuilder.merge(), instance);
    }

    @Override
    public <R> Select.Handler<R> select(Select<R> select) {
        return new SqlSelectHandler<R>(select, this.db, this.entityRowMapper);
    }

    @Override
    public boolean supportsMerge() {
        return this.getDatabase().getDatabaseType().supportsMerge();
    }

    @Override
    public void update(T instance) {
        this.incrementVersion(instance);
        this.executeStatement(this.stmtBuilder.update(), instance);
    }

    @Override
    public int update(List<SetClause<?>> setClauses, Criteria[] criteria) {
        return this.stmtBuilder.update(setClauses, criteria);
    }

    @Override
    public void updateLocking(T instance) {
        long currentVersion = this.incrementVersion(instance);
        int updated = this.executeStatement(this.stmtBuilder.locking(currentVersion), instance);
        if (updated != 1) {
            throw InstanceVersionMismatchException.mismatch(instance.metadata().getTypeName(), instance.keyAsString());
        }
    }

    @Override
    @Nullable
    public DateTime updateTime(K key) {
        return this.getStatementCache().find(this.db, (StatementCache.Proto)Predefined.ensureNotNull((Object)this.stmtBuilder.updateTime().get()), key, this.updateTimeRetriever);
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    private T doMapRow(ResultSet rs) {
        EntityInstance result = (EntityInstance)Reflection.construct(this.getType(), (Object[])new Object[0]);
        int i = 0;
        for (TableField field : this.getEntityTable().getFields()) {
            field.setFromResultSet(result, rs, ++i);
        }
        return (T)result;
    }

    private int executeStatement(Supplier<StatementCache.Proto> statement, T instance) {
        return this.getStatementCache().execute(this.db, instance, (StatementCache.Proto)Predefined.ensureNotNull((Object)statement.get()));
    }

    private long incrementVersion(T instance) {
        TableField.LongFld versionField = this.getMetadata().getVersionField();
        if (versionField == null) {
            return 0L;
        }
        Long v = (Long)versionField.getValue(instance);
        long result = v == null ? 0L : v;
        versionField.setValue(instance, result + 1L);
        return result;
    }

    private void insertDeletion(T instance) {
        if (this.getMetadata().isRemotable()) {
            SqlStatement sqlStatement = this.getDatabase().sqlStatement(this.getDatabase().getDatabaseType() == DatabaseType.POSTGRES ? "insert into %s.DELETED_INSTANCES values (?,?,%s) on conflict (ENTITY,DELETED_KEY,TS) do nothing" : "insert into %s.DELETED_INSTANCES values (?,?,%s)", new Object[]{"Schema(SG)", DbMacro.DbCurrentTime.name()});
            try {
                sqlStatement.onArgs(new Object[]{this.getEntityName(), instance.keyAsString()}).execute();
            }
            catch (UniqueViolationException uniqueViolationException) {
                // empty catch block
            }
        }
    }

    private void insertDeletions(Criteria[] condition) {
        if (this.getMetadata().isRemotable()) {
            ImmutableList toDelete = Sql.selectFrom(this.getDbTable()).where(condition).list();
            for (EntityInstance t : toDelete) {
                this.insertDeletion(t);
            }
        }
    }

    private void updateLastDeleted() {
        if (this.getMetadata().hasModifier(Modifier.REMOTABLE)) {
            this.getEntityTable().updateLastDeleted(this.db.currentTime());
        }
    }

    private StatementCache getStatementCache() {
        return (StatementCache)((Object)this.factory.getConnection(false));
    }
}

