/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.sql;

import mulesoft.database.DatabaseFactory;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.StoreHandler;
import mulesoft.persistence.sql.SqlStoreHandler;
import mulesoft.persistence.sql.StatementCache;
import mulesoft.transaction.TransactionResource;
import org.jetbrains.annotations.NotNull;

public class SqlStoreHandlerFactory
extends TransactionResource.Default<StatementCache>
implements StoreHandler.Factory {
    @NotNull
    private final DatabaseFactory<?> databaseFactory;

    public SqlStoreHandlerFactory(@NotNull DatabaseFactory<?> databaseFactory) {
        super("SQL", databaseFactory.getTransactionManager());
        this.databaseFactory = databaseFactory;
    }

    @NotNull
    public StatementCache createConnection() {
        return new StatementCache(this.databaseFactory.getTransactionManager());
    }

    @Override
    public <I extends EntityInstance<I, K>, K> StoreHandler<I, K> createHandler(String storeType, DbTable<I, K> dbTable) {
        return new SqlStoreHandler<I, K>(this, this.databaseFactory.forSchema(dbTable.metadata().getSchemaName()), dbTable);
    }

    public void endBatch(StatementCache statementCache) {
        statementCache.endBatch();
    }
}

