/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.sql;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Lazy;
import mulesoft.common.core.StrBuilder;
import mulesoft.common.core.Tuple;
import mulesoft.database.Database;
import mulesoft.database.DatabaseType;
import mulesoft.database.DbMacro;
import mulesoft.database.SqlStatement;
import mulesoft.persistence.Criteria;
import mulesoft.persistence.DbTable;
import mulesoft.persistence.EntityTable;
import mulesoft.persistence.OrderSpec;
import mulesoft.persistence.Select;
import mulesoft.persistence.SetClause;
import mulesoft.persistence.TableField;
import mulesoft.persistence.TableMetadata;
import mulesoft.persistence.expr.Alias;
import mulesoft.persistence.expr.Expr;
import mulesoft.persistence.sql.StatementCache;
import mulesoft.type.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StatementBuilder {
    private final Supplier<StatementCache.Proto> checkAndLock;
    private final Database db;
    private final Supplier<StatementCache.Proto> deleteProto;
    private final EntityTable<?, ?> et;
    private final StatementCache.Proto[] findByKeyProto;
    private final Supplier<StatementCache.Proto> findProto;
    private final Supplier<StatementCache.Proto> insertProto;
    private final Supplier<StatementCache.Proto> insertWithKeyProto;
    private final Supplier<StatementCache.Proto> mergeProto;
    private final TableMetadata<?, ?> metadata;
    private final String tableExpression;
    private final Supplier<StatementCache.Proto> updateProto;
    private final Supplier<StatementCache.Proto> updateTime;
    private final TableField.DTime updateTimeField;

    StatementBuilder(Database db, DbTable<?, ?> dbTable) {
        this.db = db;
        this.et = EntityTable.forTable(dbTable);
        this.metadata = dbTable.metadata();
        this.tableExpression = dbTable.asTableExpression();
        this.findProto = new Lazy((Supplier)new Find());
        this.checkAndLock = new Lazy((Supplier)new CheckAndLock());
        this.deleteProto = new Lazy((Supplier)new Delete());
        this.updateTimeField = this.metadata.getUpdateTimeField();
        this.updateTime = new Lazy((Supplier)new Find(){

            @Override
            @NotNull
            String fieldList() {
                return ((TableField.DTime)Predefined.ensureNotNull((Object)StatementBuilder.this.updateTimeField)).asSql(false);
            }
        });
        this.findByKeyProto = new StatementCache.Proto[this.metadata.getSecondaryKeys().size()];
        this.insertProto = new ConditionalSupplier(new Insert());
        this.insertWithKeyProto = new ConditionalSupplier(new InsertWithKey());
        this.updateProto = new ConditionalSupplier(new Update());
        this.mergeProto = new ConditionalSupplier(db.getDatabaseType() == DatabaseType.POSTGRES ? new PostgresMerge() : new Merge());
    }

    void delete(Criteria[] condition) {
        String c = StatementBuilder.criteriaToSql(condition, false);
        if (c != null) {
            this.db.sqlStatement(this.deleteWhere(c)).execute();
        }
    }

    SqlStatement delete(List<?> keys) {
        return this.db.sqlStatement(this.deleteWhere(this.listByKeysCondition(keys)));
    }

    Supplier<StatementCache.Proto> find() {
        return this.findProto;
    }

    Supplier<StatementCache.Proto> delete() {
        return this.deleteProto;
    }

    Supplier<StatementCache.Proto> insert() {
        return this.insertProto;
    }

    Supplier<StatementCache.Proto> insertWithKey() {
        return this.insertWithKeyProto;
    }

    Supplier<StatementCache.Proto> merge() {
        return this.mergeProto;
    }

    Supplier<StatementCache.Proto> locking(Long version) {
        return new ConditionalSupplier(new Update(version));
    }

    Supplier<StatementCache.Proto> update() {
        return this.updateProto;
    }

    Supplier<StatementCache.Proto> updateTime() {
        return this.updateTime;
    }

    Supplier<StatementCache.Proto> checkAndLock() {
        return this.checkAndLock;
    }

    StatementCache.Proto findByKey(int keyId) {
        StatementCache.Proto proto = this.findByKeyProto[keyId];
        return proto != null ? proto : this.makeFindByKeyProto(keyId);
    }

    int insert(List<SetClause<?>> setClauses) {
        return this.db.sqlStatement(String.format("insert into %s %s values %s", this.tableExpression, Colls.map(setClauses, SetClause::getFieldAsSql), Colls.map(setClauses, SetClause::getValueAsSql))).executeDml();
    }

    int insertOrUpdate(List<SetClause<?>> insertSetClauses, TableField<?>[] keyColumns, List<SetClause<?>> setClauses, Criteria[] condition) {
        StrBuilder aliasedValues = new StrBuilder();
        StrBuilder allFields = new StrBuilder();
        StrBuilder allValues = new StrBuilder();
        StrBuilder values = new StrBuilder();
        for (SetClause<?> s : insertSetClauses) {
            String nm = s.getFieldAsSql();
            aliasedValues.appendFormat("%s %s", new Object[]{s.getValueAsSql(), nm});
            allFields.appendElement((Object)nm);
            allValues.appendFormat("V.%s", new Object[]{nm});
            values.appendElement((Object)s.getValueAsSql());
        }
        String result = this.db.getDatabaseType() != DatabaseType.POSTGRES ? this.buildMergeStatement(this.matchCondition(keyColumns), aliasedValues.toString(), allFields.toString(), allValues.toString(), StatementBuilder.setClausesToSql(setClauses), StatementBuilder.criteriaToSql(condition, false)) : this.buildPostgresMergeStatement(ImmutableList.fromArray((Object[])keyColumns).map(f -> f.asSql(false)).mkString(","), allFields.toString(), values.toString(), StatementBuilder.setClausesToSql(setClauses), StatementBuilder.criteriaToSql(condition, true));
        return this.db.sqlStatement(result).executeDml();
    }

    SqlStatement listByKeys(List<?> keys) {
        return this.db.sqlStatement(StatementBuilder.selectFromWhere(this.tableExpression, StatementBuilder.fieldsToSql(this.et.getFields(), false), this.listByKeysCondition(keys)));
    }

    int update(List<SetClause<?>> setClauses, Criteria[] condition) {
        String c = StatementBuilder.criteriaToSql(condition, false);
        if (c == null) {
            return 0;
        }
        return this.db.sqlStatement(String.format("update %s\nset\n%s\nwhere %s", this.tableExpression, StatementBuilder.setClausesToSql(setClauses), c)).executeDml();
    }

    EntityTable<?, ?> getTable() {
        return this.et;
    }

    @NotNull
    private String buildMergeStatement(String matchCondition, String values, String allFields, String allValues, String updateSet, @Nullable String updateCondition) {
        return String.format("merge into %s\nusing Values(V, %s) on (%s)\n%s\nwhen not matched then insert (%s) values (%s)", this.tableExpression, values, matchCondition, updateCondition == null || updateSet.isEmpty() ? "" : (updateCondition.isEmpty() ? String.format("when matched then update set %s", updateSet) : String.format("when matched UpdateIf(\\(%s\\),\\(%s\\))", updateCondition, updateSet)), allFields, allValues);
    }

    @NotNull
    private String buildPostgresMergeStatement(String matchCondition, String allFields, String allValues, String setClauses, @Nullable String updateCondition) {
        return String.format("insert into %s (%s) values (%s)\non conflict (%s)\ndo %s\n", this.tableExpression, allFields, allValues, matchCondition, updateCondition == null || setClauses.isEmpty() ? "nothing " : (updateCondition.isEmpty() ? String.format("update set %s", setClauses) : String.format("update set %s where %s", setClauses, updateCondition)));
    }

    @NotNull
    private String deleteWhere(String condition) {
        StringBuilder s = new StringBuilder();
        StatementBuilder.append(s, "delete from ", this.tableExpression);
        StatementBuilder.append(s, "where ", condition);
        return s.toString();
    }

    @NotNull
    private String keyPredicate(List<TableField<?>> keyFields) {
        StrBuilder keyPredicate = new StrBuilder().startCollection(" and ");
        for (TableField<?> f : keyFields) {
            keyPredicate.appendFormat("%s = ?", new Object[]{f.getName()});
        }
        return keyPredicate.toString();
    }

    private String listByKeysCondition(List<?> keys) {
        ImmutableList<TableField<?>> pks = this.metadata.getPrimaryKey();
        if (pks.size() == 1) {
            TableField field = (TableField)Predefined.cast((Object)pks.get(0));
            StrBuilder values = new StrBuilder();
            for (Object key : keys) {
                values.appendElement((Object)field.getValueAsSqlConstant(key));
            }
            return String.format("%s in (%s)", field.getName(), values);
        }
        StrBuilder condition = new StrBuilder().startCollection(" or ");
        for (Object key : keys) {
            StrBuilder clause = new StrBuilder().startCollection(" and ");
            ImmutableList l = ((Tuple)key).asList();
            for (int i = 0; i < pks.size(); ++i) {
                TableField field = (TableField)Predefined.cast((Object)pks.get(i));
                clause.appendFormat("%s = %s", new Object[]{field.getName(), field.getValueAsSqlConstant(l.get(i))});
            }
            condition.appendElement((Object)clause);
        }
        return condition.toString();
    }

    @NotNull
    private synchronized StatementCache.Proto makeFindByKeyProto(int keyId) {
        StatementCache.Proto findByKey;
        StatementCache.Proto p = this.findByKeyProto[keyId];
        if (p != null) {
            return p;
        }
        ImmutableList keyFields = (ImmutableList)this.metadata.getSecondaryKeys().get(keyId);
        String statement = StatementBuilder.selectFromWhere(this.tableExpression, StatementBuilder.fieldsToSql(this.et.getFields(), false), this.keyPredicate((List<TableField<?>>)keyFields));
        this.findByKeyProto[keyId] = findByKey = new StatementCache.Proto(this.db.preProcess(statement), (Seq<TableField<?>>)keyFields);
        return findByKey;
    }

    @NotNull
    private String matchCondition(TableField<?>[] keyColumns) {
        StrBuilder matchCondition = new StrBuilder().startCollection(" and ");
        for (TableField<?> keyColumn : keyColumns) {
            String name = keyColumn.getName();
            matchCondition.appendElement((Object)String.format("%s = V.%s", keyColumn.asSql(true), name));
        }
        return matchCondition.toString();
    }

    @NotNull
    private String valueParameter(boolean useCurrentTime) {
        return useCurrentTime && !this.metadata.hasModifier(Modifier.REMOTE) ? DbMacro.CurrentTime.name() : "?";
    }

    private boolean isCreateOrUpdateTime(TableField<?> f) {
        return f == this.updateTimeField || f == this.metadata.getCreationTimeField();
    }

    @Nullable
    static String buildNestedSelect(String selectItems, String sql) {
        return sql == null ? null : StatementBuilder.selectFromWhere("(" + sql + ")", selectItems, "");
    }

    @Nullable
    static String buildSelect(String selectItems, String from, Seq<Select.Join> joins, Seq<Select.Union> unions, @Nullable String where, String groupBy, @Nullable String having, String orderBy, EnumSet<Select.Flag> flags) {
        return where == null || having == null ? null : StatementBuilder.selectFromWhere(from, selectItems, StatementBuilder.createJoinConditions(joins), StatementBuilder.createUnionConditions(unions), where, groupBy, having, orderBy, flags);
    }

    static String convertToSql(boolean qualify, boolean createAlias, Expr<?> ... expressions) {
        StrBuilder result = new StrBuilder().startCollection(", ");
        for (Expr<?> e : expressions) {
            String item = e.asSql(qualify);
            if (createAlias && e instanceof Alias) {
                item = item + " as " + e.getName();
            }
            result.appendElement((Object)item);
        }
        return result.toString();
    }

    @Nullable
    static String criteriaToSql(Criteria[] conditionList, boolean qualify) {
        StrBuilder result = new StrBuilder().startCollection(" and ");
        for (Criteria c : conditionList) {
            if (c == null || c == Criteria.EMPTY || c == Criteria.TRUE) continue;
            if (c == Criteria.FALSE) {
                return null;
            }
            result.appendElement((Object)c.asSql(qualify));
        }
        return result.toString();
    }

    static String fieldsToSql(Iterable<TableField<?>> fields, boolean qualify) {
        StrBuilder fieldsToSelect = new StrBuilder();
        for (TableField<?> f : fields) {
            fieldsToSelect.appendElement((Object)f.asSql(qualify));
        }
        return fieldsToSelect.toString();
    }

    static String orderSpecToSql(OrderSpec<?>[] orderSpec, boolean qualify) {
        StrBuilder result = new StrBuilder();
        for (OrderSpec<?> spec : orderSpec) {
            result.appendElement((Object)spec.asSql(qualify));
        }
        return result.toString();
    }

    private static void append(StringBuilder b, String kw, String condition) {
        if (!condition.isEmpty()) {
            b.append(kw).append(condition).append('\n');
        }
    }

    private static String createJoinConditions(Seq<Select.Join> joins) {
        StrBuilder result = new StrBuilder().startCollection("\n");
        for (Select.Join j : joins) {
            result.appendElement((Object)String.format("%s %s on (%s)", j.left ? "left outer join" : " join ", j.getTarget(), StatementBuilder.criteriaToSql(j.criteria, true)));
        }
        return result.toString();
    }

    private static String createUnionConditions(Seq<Select.Union> unions) {
        StrBuilder result = new StrBuilder().startCollection("\n");
        for (Select.Union u : unions) {
            result.appendElement((Object)String.format("%s %s", u.all ? " union all " : " union ", u.getTarget()));
        }
        return result.toString();
    }

    private static String selectFromWhere(String from, String tableFields, String condition) {
        StringBuilder b = new StringBuilder();
        StatementBuilder.append(b, "select ", tableFields);
        StatementBuilder.append(b, "from ", from);
        StatementBuilder.append(b, "where ", condition);
        return b.toString();
    }

    private static String selectFromWhere(String from, String tableFields, String joins, String unions, String condition, String groupBy, String having, String orderBy, EnumSet<Select.Flag> flags) {
        StringBuilder b = new StringBuilder();
        StatementBuilder.append(b, "select " + Select.Flag.DISTINCT.asStringIfPresent(flags), tableFields);
        StatementBuilder.append(b, "from ", from);
        StatementBuilder.append(b, "", joins);
        StatementBuilder.append(b, "where ", condition);
        StatementBuilder.append(b, "group by ", groupBy);
        StatementBuilder.append(b, "having ", having);
        StatementBuilder.append(b, "", unions);
        StatementBuilder.append(b, "order by ", orderBy);
        String forUpdate = Select.Flag.FOR_UPDATE.asStringIfPresent(flags) + Select.Flag.NO_WAIT.asStringIfPresent(flags) + Select.Flag.SKIP_LOCKED.asStringIfPresent(flags);
        if (!forUpdate.isEmpty()) {
            b.append(forUpdate).append('\n');
        }
        return b.toString();
    }

    private static String setClausesToSql(List<SetClause<?>> setClauseList) {
        StrBuilder result = new StrBuilder().startCollection(",\n");
        for (SetClause<?> s : setClauseList) {
            result.appendElement((Object)s.asSql());
        }
        return result.toString();
    }

    private class Update
    extends StatementSupplier {
        private final Long version;

        public Update() {
            this.version = null;
        }

        public Update(Long version) {
            this.version = version;
        }

        protected ImmutableList<TableField<?>> arguments() {
            return StatementBuilder.this.et.getFields().filter(this::includeField).append(StatementBuilder.this.metadata.getPrimaryKey()).toList();
        }

        @Override
        String statement() {
            StrBuilder fieldsToUpdate = new StrBuilder();
            TableField.LongFld versionFld = StatementBuilder.this.metadata.getVersionField();
            for (TableField f : StatementBuilder.this.et.getFields()) {
                if (f.isPrimaryKey()) continue;
                fieldsToUpdate.appendFormat("%s = %s", new Object[]{f.getName(), StatementBuilder.this.valueParameter(f == StatementBuilder.this.updateTimeField)});
            }
            return String.format("update %s set %s where %s", StatementBuilder.this.tableExpression, fieldsToUpdate, StatementBuilder.this.keyPredicate(StatementBuilder.this.metadata.getPrimaryKey())) + (this.version != null && versionFld != null ? " and INSTANCE_VERSION = " + versionFld.getValueAsSqlConstant(this.version) : "");
        }

        private boolean includeField(TableField<?> f) {
            return !f.isPrimaryKey() && (StatementBuilder.this.metadata.hasModifier(Modifier.REMOTE) || f != StatementBuilder.this.updateTimeField);
        }
    }

    abstract class StatementSupplier
    implements Supplier<StatementCache.Proto> {
        StatementSupplier() {
        }

        @Override
        public StatementCache.Proto get() {
            return new StatementCache.Proto(StatementBuilder.this.db.preProcess(this.statement()), (Seq<TableField<?>>)this.arguments());
        }

        ImmutableCollection<TableField<?>> arguments() {
            return StatementBuilder.this.et.getFields();
        }

        abstract String statement();
    }

    private class PostgresMerge
    extends Insert {
        private PostgresMerge() {
        }

        @Override
        ImmutableList<TableField<?>> arguments() {
            return super.arguments().append((Iterable)StatementBuilder.this.et.getFields().filter(f -> !f.isPrimaryKey())).toList();
        }

        @Override
        String statement() {
            StrBuilder values = new StrBuilder();
            StrBuilder fieldsToUpdate = new StrBuilder();
            StrBuilder allFields = new StrBuilder();
            StrBuilder keyFields = new StrBuilder();
            for (TableField f : StatementBuilder.this.et.getFields()) {
                values.appendElement((Object)this.value(f));
                String col = f.getName();
                if (f.isPrimaryKey()) {
                    keyFields.appendElement((Object)col);
                } else {
                    fieldsToUpdate.appendFormat("%s = %s", new Object[]{col, StatementBuilder.this.valueParameter(f == StatementBuilder.this.updateTimeField)});
                }
                allFields.appendElement((Object)col);
            }
            return String.format("insert into %s (%s) values (%s) on conflict (%s) do update set %s", StatementBuilder.this.tableExpression, allFields, values, keyFields, fieldsToUpdate);
        }
    }

    private class Merge
    extends Insert {
        private Merge() {
        }

        @Override
        String statement() {
            StrBuilder aliasedValues = new StrBuilder();
            StrBuilder fieldsToUpdate = new StrBuilder();
            StrBuilder allFields = new StrBuilder();
            StrBuilder allValues = new StrBuilder();
            StrBuilder keyPredicate = new StrBuilder().startCollection(" and ");
            for (TableField f : StatementBuilder.this.et.getFields()) {
                String col = f.getName();
                aliasedValues.appendFormat("%s %s", new Object[]{this.value(f), col});
                if (f.isPrimaryKey()) {
                    keyPredicate.appendFormat("T.%s = V.%s", new Object[]{col, col});
                } else {
                    fieldsToUpdate.appendFormat("T.%s = V.%s", new Object[]{col, col});
                }
                allFields.appendElement((Object)col);
                allValues.appendFormat("V.%s", new Object[]{col});
            }
            return String.format("merge into %s T using Values(V, %s)on (%s) when matched then     update set %s when not matched then     insert (%s) values (%s)", StatementBuilder.this.tableExpression, aliasedValues, keyPredicate, fieldsToUpdate, allFields, allValues);
        }
    }

    private class InsertWithKey
    extends Insert {
        private String nextVal;

        private InsertWithKey() {
            this.nextVal = "";
        }

        @Override
        public StatementCache.Proto get() {
            if (StatementBuilder.this.db.getDatabaseType().has(DbMacro.SeqNextVal)) {
                this.nextVal = String.format("SeqNextVal(QName(%s,%s))", StatementBuilder.this.metadata.getSchemaName(), StatementBuilder.this.metadata.getSequenceName());
            }
            return super.get();
        }

        @Override
        protected boolean includeField(TableField<?> f) {
            return !f.isPrimaryKey() && super.includeField(f);
        }

        @Override
        void addField(TableField<?> f, StrBuilder fieldNames, StrBuilder fieldValues) {
            if (!f.isPrimaryKey()) {
                super.addField(f, fieldNames, fieldValues);
            } else if (!this.nextVal.isEmpty()) {
                fieldNames.appendElement((Object)f.getName());
                fieldValues.appendElement((Object)this.nextVal);
            }
        }
    }

    private class Insert
    extends StatementSupplier {
        private Insert() {
        }

        protected boolean includeField(TableField<?> f) {
            return StatementBuilder.this.metadata.hasModifier(Modifier.REMOTE) || !StatementBuilder.this.isCreateOrUpdateTime(f);
        }

        void addField(TableField<?> f, StrBuilder fieldNames, StrBuilder fieldValues) {
            String col = f.getName();
            fieldNames.appendElement((Object)col);
            fieldValues.appendElement((Object)this.value(f));
        }

        ImmutableList<TableField<?>> arguments() {
            return StatementBuilder.this.et.getFields().filter(this::includeField).toList();
        }

        @Override
        String statement() {
            StrBuilder fieldNames = new StrBuilder();
            StrBuilder fieldValues = new StrBuilder();
            for (TableField f : StatementBuilder.this.et.getFields()) {
                this.addField(f, fieldNames, fieldValues);
            }
            return String.format("insert into %s (%s) values (%s)", StatementBuilder.this.tableExpression, fieldNames, fieldValues);
        }

        @NotNull
        String value(TableField<?> f) {
            return StatementBuilder.this.valueParameter(StatementBuilder.this.isCreateOrUpdateTime(f));
        }
    }

    private class Find
    extends StatementSupplier {
        private Find() {
        }

        protected ImmutableList<TableField<?>> arguments() {
            return StatementBuilder.this.metadata.getPrimaryKey();
        }

        @NotNull
        String fieldList() {
            return StatementBuilder.fieldsToSql(StatementBuilder.this.et.getFields(), false);
        }

        @Override
        String statement() {
            return StatementBuilder.selectFromWhere(StatementBuilder.this.tableExpression, this.fieldList(), StatementBuilder.this.keyPredicate(StatementBuilder.this.metadata.getPrimaryKey()));
        }
    }

    private class Delete
    extends StatementSupplier {
        private Delete() {
        }

        protected ImmutableList<TableField<?>> arguments() {
            return StatementBuilder.this.metadata.getPrimaryKey();
        }

        @Override
        String statement() {
            return StatementBuilder.this.deleteWhere(StatementBuilder.this.keyPredicate(StatementBuilder.this.metadata.getPrimaryKey()));
        }
    }

    private static class ConditionalSupplier
    implements Supplier<StatementCache.Proto> {
        private final Lazy<StatementCache.Proto> cachedSupplier;
        private final Supplier<StatementCache.Proto> statementSupplier;

        private ConditionalSupplier(Supplier<StatementCache.Proto> statementSupplier) {
            this.statementSupplier = statementSupplier;
            this.cachedSupplier = new Lazy(statementSupplier);
        }

        @Override
        @Nullable
        public StatementCache.Proto get() {
            return Database.useClientTime() ? this.statementSupplier.get() : (StatementCache.Proto)this.cachedSupplier.get();
        }
    }

    private class CheckAndLock
    extends StatementSupplier {
        private CheckAndLock() {
        }

        protected ImmutableList<TableField<?>> arguments() {
            TableField upd = (TableField)Predefined.ensureNotNull((Object)StatementBuilder.this.updateTimeField);
            return Colls.listOf((Object)upd, (Object)upd).append(StatementBuilder.this.metadata.getPrimaryKey()).toList();
        }

        @Override
        String statement() {
            return String.format("update %s set UPDATE_TIME = ? where cast(UPDATE_TIME as timestamp(3)) = ? and %s", StatementBuilder.this.tableExpression, StatementBuilder.this.keyPredicate(StatementBuilder.this.metadata.getPrimaryKey()));
        }
    }
}

