/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.persistence.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Tuple;
import mulesoft.database.Database;
import mulesoft.database.ResultHandler;
import mulesoft.database.SqlStatement;
import mulesoft.database.support.DummyConnection;
import mulesoft.persistence.EntityInstance;
import mulesoft.persistence.TableField;
import mulesoft.transaction.TransactionManager;
import org.jetbrains.annotations.Nullable;

class StatementCache
extends DummyConnection {
    private final Map<String, SqlStatement.Prepared> cache = new HashMap<String, SqlStatement.Prepared>();
    private final TransactionManager tm;

    StatementCache(TransactionManager tm) {
        this.tm = tm;
    }

    public void close() {
        for (SqlStatement.Prepared stmt : this.cache.values()) {
            stmt.close();
        }
        this.cache.clear();
    }

    public void commit() {
        this.close();
    }

    public void rollback() {
        this.close();
    }

    <K> boolean checkAndLock(Database db, Proto proto, K key, DateTime updateTime) {
        SqlStatement.Prepared stmt = this.getStatement(proto.sql, db, "");
        ImmutableList args = (ImmutableList)Predefined.cast((Object)proto.args.toList());
        ((TableField)args.get(0)).setParameter(stmt, 1, updateTime);
        ((TableField)args.get(1)).setParameter(stmt, 2, updateTime);
        this.setKeyParameters(stmt, (List<TableField<Object>>)args.subList(2, args.size()), 3, key);
        return stmt.executeDml() == 1;
    }

    void endBatch() {
        for (SqlStatement.Prepared stmt : this.cache.values()) {
            stmt.executeBatch();
        }
    }

    <I extends EntityInstance<I, K>, K> int execute(Database db, I instance, Proto proto) {
        SqlStatement.Prepared stmt = this.getStatement(proto.sql, db, "");
        int i = 0;
        for (TableField field : proto.args) {
            field.setParameterFromInstance(stmt, ++i, instance);
        }
        if (this.tm.isBatchActive()) {
            stmt.batch();
            return 1;
        }
        return stmt.executeDml();
    }

    <I extends EntityInstance<I, K>, K> void executeWithKey(Database db, I instance, Proto proto, @Nullable TableField.Num<?, ?> keyField) {
        if (keyField == null) {
            throw new UnsupportedOperationException("Insert with Key");
        }
        SqlStatement.Prepared stmt = this.getStatement(proto.sql, db, keyField.getName());
        int i = 0;
        for (TableField field : proto.args) {
            field.setParameterFromInstance(stmt, ++i, instance);
        }
        Long k = stmt.insertWithKey();
        if (k != null) {
            keyField.setValue(instance, k);
        }
    }

    @Nullable
    <T, K> T find(Database db, Proto proto, K key, ResultHandler<T> resultHandler) {
        SqlStatement.Prepared stmt = this.getStatement(proto.sql, db, "");
        this.setKeyParameters(stmt, (List)Predefined.cast((Object)proto.args.toList()), 1, key);
        return (T)stmt.run(resultHandler);
    }

    private void setKeyParameters(SqlStatement.Prepared stmt, List<TableField<Object>> keyFields, int offset, Object key) {
        if (keyFields.size() == 1) {
            keyFields.get(0).setParameter(stmt, offset, key);
        } else {
            ImmutableList l = ((Tuple)key).asList();
            for (int i = 0; i < keyFields.size(); ++i) {
                keyFields.get(i).setParameter(stmt, i + offset, l.get(i));
            }
        }
    }

    private SqlStatement.Prepared getStatement(String sql, Database db, String keyFieldName) {
        return this.cache.computeIfAbsent(sql, k -> db.nativeSql(sql).returnKeys(keyFieldName).prepare());
    }

    static class Proto {
        final Seq<TableField<?>> args;
        final String sql;

        Proto(String sql, Seq<TableField<?>> args) {
            this.sql = sql;
            this.args = args;
        }
    }
}

