/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableSet;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.core.QName;
import mulesoft.common.env.Environment;
import mulesoft.common.env.context.Context;
import mulesoft.common.env.impl.MemoryEnvironment;
import mulesoft.database.Database;
import mulesoft.database.DatabaseType;
import mulesoft.database.SchemaDefinition;
import mulesoft.database.exception.DatabaseException;
import mulesoft.database.exception.DatabaseSchemaDoesNotExistsException;
import mulesoft.database.hikari.HikariDatabaseFactory;
import mulesoft.database.introspect.MdColumn;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.TableType;
import mulesoft.database.introspect.exception.IntrospectorException;
import mulesoft.properties.SchemaProps;
import mulesoft.transaction.ConnectionReference;
import mulesoft.transaction.JDBCTransactionManager;
import mulesoft.transaction.Transaction;
import mulesoft.transaction.TransactionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbIntrospector
implements AutoCloseable {
    private ImmutableSet<String> catalogNames;
    private final Connection connection;
    private final DatabaseType dbType;
    @NotNull
    private final String identifierQuoteString;
    @NotNull
    private final DatabaseMetaData metaData;
    private final MetadataRetriever retriever;
    private final String schemaPrefix;
    private Map<String, SchemaInfo> schemas;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private EnumSet<TableType> tableTypes;

    private DbIntrospector(Connection connection, DatabaseType dbType, String schemaPrefix) throws SQLException {
        this.connection = connection;
        this.dbType = dbType;
        this.schemaPrefix = schemaPrefix;
        this.catalogNames = null;
        this.schemas = null;
        this.tableTypes = null;
        this.metaData = connection.getMetaData();
        this.supportsSchemas = this.metaData.supportsSchemasInTableDefinitions();
        this.supportsCatalogs = this.metaData.supportsCatalogsInTableDefinitions();
        this.identifierQuoteString = Predefined.notNull((String)this.getMetaData().getIdentifierQuoteString());
        this.retriever = MetadataRetriever.createRetriever(dbType, connection, this.metaData);
    }

    @Override
    public void close() {
    }

    @NotNull
    public Seq<String> listSchemaNames() {
        return this.getSchemas().map(m -> m == null ? "" : m.getName());
    }

    public boolean supportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean supportsSchemas() {
        return this.supportsSchemas;
    }

    public ImmutableSet<String> getCatalogNames() {
        if (this.catalogNames == null) {
            this.catalogNames = this.retrieveAllCatalogs();
        }
        return this.catalogNames;
    }

    public DatabaseType getDatabaseType() {
        return this.dbType;
    }

    public String getDefaultCatalog() {
        return this.dbType.getDefaultCatalog();
    }

    @NotNull
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public MetadataRetriever getRetriever() {
        return this.retriever;
    }

    public SchemaInfo getSchema(@NotNull String schemaName) {
        return this.getSchema("", schemaName);
    }

    public SchemaInfo getSchema(@NotNull String catalogName, @NotNull String schemaName) {
        SchemaInfo ret;
        String c = catalogName.isEmpty() && this.getCatalogNames().size() == 1 ? (String)this.getCatalogNames().getFirst().get() : catalogName;
        SchemaInfo s = new SchemaInfo(this, c, schemaName);
        if (this.schemas == null) {
            this.schemas = new TreeMap<String, SchemaInfo>();
        }
        if ((ret = this.schemas.get(s.getLookupKey())) != null) {
            return ret;
        }
        this.schemas.put(s.getLookupKey(), s);
        return s;
    }

    public String getSchemaPrefix() {
        return this.schemaPrefix;
    }

    @NotNull
    public ImmutableCollection<SchemaInfo> getSchemas() {
        if (this.schemas == null) {
            this.schemas = this.retrieveAllSchemas();
        }
        return Colls.immutable(this.schemas.values());
    }

    public Option<TableInfo> getTable(@NotNull QName table) {
        return this.getSchema(table.getQualification()).getTable(table.getName());
    }

    @NotNull
    public EnumSet<TableType> getTableTypes() {
        if (this.tableTypes == null) {
            this.tableTypes = this.retrieveTableTypes();
        }
        return this.tableTypes;
    }

    Connection getConnection() {
        return this.connection;
    }

    @NotNull
    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    private void addSchema(String catalogName, String schemaName, Map<String, SchemaInfo> result) {
        SchemaInfo s = this.getSchema(catalogName, schemaName);
        result.put(s.getLookupKey(), s);
    }

    private void addSchemaForAllCatalogs(String schemaName, Map<String, SchemaInfo> map) {
        if (this.getCatalogNames().isEmpty()) {
            this.addSchema("", schemaName, map);
        } else {
            for (String catalogName : this.getCatalogNames()) {
                this.addSchema(catalogName, schemaName, map);
            }
        }
    }

    private ImmutableSet<String> retrieveAllCatalogs() {
        HashSet<String> result = null;
        if (!this.supportsCatalogs) {
            try (ResultSet results = this.metaData.getCatalogs();){
                result = new HashSet<String>();
                while (results.next()) {
                    String value = Predefined.notNull((String)results.getString(1)).trim();
                    if (value.isEmpty()) continue;
                    result.add(value);
                }
            }
            catch (SQLException e) {
                throw new IntrospectorException(e);
            }
        }
        return Colls.immutable(result);
    }

    private Map<String, SchemaInfo> retrieveAllSchemas() {
        TreeMap<String, SchemaInfo> result = new TreeMap<String, SchemaInfo>();
        if (!this.supportsSchemas) {
            this.addSchemaForAllCatalogs("", result);
        } else {
            for (MdEntry e : this.retriever.getSchemas()) {
                String catalogName = this.supportsCatalogs ? e.getString(MdColumn.S_CATALOG) : null;
                String schemaName = Predefined.notNull((String)e.getString(MdColumn.S_NAME));
                if (catalogName == null) {
                    this.addSchemaForAllCatalogs(schemaName, result);
                    continue;
                }
                this.addSchema(catalogName, schemaName, result);
            }
        }
        return result;
    }

    private EnumSet<TableType> retrieveTableTypes() {
        EnumSet<TableType> result = EnumSet.noneOf(TableType.class);
        try (ResultSet rs = this.metaData.getTableTypes();){
            while (rs.next()) {
                String value = Predefined.notNull((String)rs.getString(1)).trim();
                if (value.isEmpty()) continue;
                result.add(TableType.fromString(value));
            }
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
        return result;
    }

    @NotNull
    public static DbIntrospector forConnection(Connection connection, DatabaseType databaseType) {
        try {
            return new DbIntrospector(connection, databaseType, "");
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    public static DbIntrospector forDatabase(Database db) {
        final ConnectionReference ref = db.getConnectionRef();
        try {
            return new DbIntrospector(ref.get(), db.getDatabaseType(), db.getSchemaPrefix()){

                @Override
                public void close() {
                    ref.detach();
                }
            };
        }
        catch (SQLException e) {
            ref.detach();
            throw new IntrospectorException(e);
        }
    }

    public static SchemaInfo introspectSchema(String schemaName, Seq<File> resourcesDir, File ... sqlFiles) {
        return DbIntrospector.introspectSchema(schemaName, resourcesDir, false, sqlFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaInfo introspectSchema(String schemaName, Seq<File> resourcesDir, boolean current, File ... sqlFiles) {
        MemoryEnvironment env = new MemoryEnvironment();
        HikariDatabaseFactory dbFactory = new HikariDatabaseFactory((Environment)env, (TransactionManager)new JDBCTransactionManager());
        Database db = dbFactory.open("mem");
        Context.getContext().setSingleton(TransactionManager.class, (Object)dbFactory.getTransactionManager());
        Transaction.runInTransaction(() -> DbIntrospector.lambda$introspectSchema$1(db, schemaName, (Environment)env));
        try {
            ArrayList schemas = new ArrayList();
            SchemaInfo schemaInfo = (SchemaInfo)Transaction.invokeInTransaction(() -> DbIntrospector.lambda$introspectSchema$2(db, sqlFiles, resourcesDir, schemas, (Environment)env, schemaName, current));
            return schemaInfo;
        }
        finally {
            dbFactory.shutdown();
        }
    }

    private static void executeFiles(Database db, File[] sqlFiles, Seq<File> resourcesDir, List<String> schemas, Environment env) {
        for (File sqlFile : sqlFiles) {
            try (FileReader f = new FileReader(sqlFile);){
                File dbDir = DbIntrospector.extractDbDir(sqlFile);
                db.sqlStatement((Reader)f).executeScript((Predicate)new HandleSchemaCreation(db, dbDir, schemas, resourcesDir, env));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Nullable
    private static File extractDbDir(File sqlFile) {
        for (File dir = sqlFile.getParentFile(); dir != null; dir = dir.getParentFile()) {
            if (!"db".equals(dir.getName())) continue;
            return dir.getParentFile();
        }
        return null;
    }

    @NotNull
    private static SchemaInfo schemaInfo(Database db, List<String> schemas, String schemaName, boolean current) {
        try (DbIntrospector introspector = DbIntrospector.forDatabase(db);){
            for (String s : schemas) {
                introspector.getSchema(s).loadAll();
            }
            SchemaInfo schema = introspector.getSchema(schemaName);
            if (current) {
                schema.markCurrent();
            }
            schema.loadAll();
            SchemaInfo schemaInfo = schema;
            return schemaInfo;
        }
    }

    private static /* synthetic */ SchemaInfo lambda$introspectSchema$2(Database db, File[] sqlFiles, Seq resourcesDir, List schemas, Environment env, String schemaName, boolean current) {
        DbIntrospector.executeFiles(db, sqlFiles, (Seq<File>)resourcesDir, schemas, env);
        return DbIntrospector.schemaInfo(db, schemas, schemaName, current);
    }

    private static /* synthetic */ void lambda$introspectSchema$1(Database db, String schemaName, Environment env) {
        DatabaseType dbType = db.getDatabaseType();
        dbType.createDatabase(db);
        dbType.createSchema(db, schemaName, ((SchemaProps)env.get((String)schemaName, SchemaProps.class)).tableTablespace);
    }

    private static class HandleSchemaCreation
    implements Predicate<DatabaseException> {
        private final Database db;
        private final Environment env;
        private final List<File> resourcesDir;
        private final List<String> schemas;

        HandleSchemaCreation(Database db, @Nullable File dbDir, List<String> dependencies, Seq<File> resources, Environment env) {
            this.db = db;
            this.resourcesDir = (dbDir == null ? resources : resources.append((Object)dbDir)).toList();
            this.schemas = dependencies;
            this.env = env;
        }

        @Override
        public boolean test(@Nullable DatabaseException e) {
            if (e == null) {
                return false;
            }
            if (e instanceof DatabaseSchemaDoesNotExistsException && !this.resourcesDir.isEmpty()) {
                String schema = ((DatabaseSchemaDoesNotExistsException)e).getSchema();
                new SchemaDefinition(this.db, schema, this.env).ignoreErrors().createSchema(this.resourcesDir);
                this.schemas.add(schema);
                return true;
            }
            throw e;
        }
    }
}

