/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;

class HsqlDbMetadataRetriever
extends MetadataRetriever {
    private static final int DATETIME_BASE = 20;

    public HsqlDbMetadataRetriever(Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData);
    }

    @Override
    SqlType retrieveType(String typeName, int dataType, int size, int precision) {
        SqlKind kind = SqlKind.kindFor(dataType);
        if (kind == SqlKind.VARCHAR) {
            return SqlType.sqlType(typeName, SqlKind.NVARCHAR, size, 0);
        }
        if (kind == SqlKind.DATETIME) {
            return SqlType.sqlType(typeName, SqlKind.DATETIME, 0, size - 20);
        }
        return SqlType.sqlType(typeName, kind, size, precision);
    }

    @Override
    Iterable<MdEntry> getColumns(SchemaInfo schema, String tableName) {
        return this.iterableFrom("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, DECIMAL_DIGITS, ORDINAL_POSITION, NULLABLE, COLUMN_DEF, IS_AUTOINCREMENT, IS_GENERATEDCOLUMN, S.SEQUENCE_NAME from INFORMATION_SCHEMA.SYSTEM_COLUMNS C left outer join INFORMATION_SCHEMA.SYSTEM_COLUMN_SEQUENCE_USAGE S on C.TABLE_CAT = S.TABLE_CATALOG and C.TABLE_SCHEM = S.TABLE_SCHEMA and C.TABLE_NAME = S.TABLE_NAME and S.COLUMN_NAME = C.COLUMN_NAME where C.TABLE_SCHEM = '%s' and C.TABLE_NAME = '%s'", schema, tableName);
    }
}

