/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ext.BitSet;
import mulesoft.database.introspect.MdColumn;
import mulesoft.database.introspect.exception.IntrospectorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdEntry {
    private final Map<String, Integer> columnMap;
    private final ResultSet rs;
    private final BitSet unReadColumns;

    MdEntry(ResultSet rs, Map<String, Integer> columnMap, BitSet unReadColumns) {
        this.columnMap = columnMap;
        this.rs = rs;
        this.unReadColumns = unReadColumns;
    }

    @Nullable
    public String getString(MdColumn mdc) {
        int c = this.readColumn(mdc);
        if (c == 0) {
            return null;
        }
        try {
            return this.rs.getString(c);
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Map<String, Object> getAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> e : this.columnMap.entrySet()) {
            int column = e.getValue();
            if (!this.unReadColumns.contains((Object)column)) continue;
            try {
                Object value = this.rs.getObject(column);
                if (value == null || this.rs.wasNull()) continue;
                map.put(e.getKey(), value);
            }
            catch (Exception exception) {}
        }
        return map;
    }

    boolean getBoolean(MdColumn mdc) {
        int c = this.readColumn(mdc);
        if (c == 0) {
            return false;
        }
        try {
            return this.rs.getBoolean(c);
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    BigDecimal getDecimal(MdColumn mdc) {
        int c = this.readColumn(mdc);
        if (c == 0) {
            return BigDecimal.ZERO;
        }
        try {
            BigDecimal value = this.rs.getBigDecimal(c);
            return this.rs.wasNull() ? BigDecimal.ZERO : value;
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    int getInt(MdColumn mdc) {
        return this.getInt(mdc, 0);
    }

    int getInt(MdColumn mdc, int defaultValue) {
        int c = this.readColumn(mdc);
        if (c == 0) {
            return defaultValue;
        }
        try {
            int value = this.rs.getInt(c);
            return this.rs.wasNull() ? defaultValue : value;
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    @NotNull
    String getString(MdColumn mdc, String defaultValue) {
        return (String)Predefined.notNull((Object)this.getString(mdc), (Object)defaultValue);
    }

    boolean getYesOrNo(MdColumn mdc) {
        int c = this.readColumn(mdc);
        if (c == 0) {
            return false;
        }
        try {
            String s = Predefined.notNull((String)this.rs.getString(c));
            return s.startsWith("Y");
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    private int readColumn(MdColumn c) {
        int col = Predefined.notNull((Integer)this.columnMap.get(c.getColumnName()), (int)0);
        this.unReadColumns.set(col, false);
        return col;
    }
}

