/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.Serializable;
import mulesoft.common.Predefined;
import org.jetbrains.annotations.NotNull;

public abstract class MetadataObject<This extends MetadataObject<This>>
implements Serializable,
Comparable<MetadataObject<This>> {
    @NotNull
    private final String name;
    private static final long serialVersionUID = -5346413974520029363L;

    protected MetadataObject(@NotNull String name) {
        this.name = name;
    }

    @Override
    public int compareTo(@NotNull MetadataObject<This> that) {
        return this.getFullName().compareTo(that.getFullName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetadataObject) {
            MetadataObject that = (MetadataObject)Predefined.cast((Object)obj);
            return this.name.equals(that.name) && this.getQualification().equals(that.getQualification());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.getQualification().hashCode();
    }

    public abstract boolean sameAs(This var1);

    public String toString() {
        return this.getFullName();
    }

    @NotNull
    public String getFullName() {
        String q = this.getQualification();
        return q.isEmpty() ? this.name : (this.name.isEmpty() ? q : q + "." + this.name);
    }

    @NotNull
    public String getLookupKey() {
        return this.getFullName();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    abstract String getQualification();
}

