/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableIterator;
import mulesoft.common.collections.ext.BitSet;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.database.DatabaseType;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.HsqlDbMetadataRetriever;
import mulesoft.database.introspect.MdColumn;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataObject;
import mulesoft.database.introspect.OracleMetadataRetriever;
import mulesoft.database.introspect.PostgresMetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.TableType;
import mulesoft.database.introspect.exception.IntrospectorException;
import mulesoft.database.support.JdbcUtils;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetadataRetriever {
    final DatabaseMetaData metaData;
    private final Connection connection;

    MetadataRetriever(Connection connection, DatabaseMetaData metaData) {
        this.connection = connection;
        this.metaData = metaData;
    }

    public Iterable<MdEntry> getSchemas() {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getSchemas());
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    protected ResultSet execute(@PrintFormat String sql, Object[] params) {
        ResultSet resultSet;
        try {
            Statement stmt = this.connection.createStatement();
            String format = String.format(sql, params);
            stmt.execute(format);
            resultSet = stmt.getResultSet();
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
        return resultSet;
    }

    @Nullable
    protected String translateDefault(@Nullable String value, SqlKind sqlKind) {
        if (value == null || "NULL".equalsIgnoreCase(value)) {
            return null;
        }
        switch (sqlKind) {
            case BOOLEAN: {
                return MetadataRetriever.checkMacros(value, DbMacro.False, DbMacro.True);
            }
            case DOUBLE: {
                return value.endsWith("E0") ? value.substring(0, value.length() - 2) : value.replace('E', 'e');
            }
            case VARCHAR: 
            case NVARCHAR: {
                return "''".equals(value) ? DbMacro.EmptyString.name() : value;
            }
            case DATE: {
                return MetadataRetriever.checkMacro(value, DbMacro.DbCurrentDate, DbMacro.CurrentDate);
            }
            case DATETIME: {
                return MetadataRetriever.checkMacro(value, DbMacro.DbCurrentTime, DbMacro.CurrentTime);
            }
        }
        return value;
    }

    Iterable<MdEntry> iterableFrom(@PrintFormat String sql, Object ... params) {
        return MetadataRetriever.iterableFrom(this.execute(sql, params));
    }

    Map<String, ? extends TableInfo.TableObject<?>> retrieve(TableInfo tableInfo, TableInfo.Element element) {
        switch (element) {
            case COLUMN: {
                return this.retrieveColumns(tableInfo);
            }
            case CHECK: {
                return this.retrieveChecks(tableInfo);
            }
            case FOREIGN_KEY: {
                return this.retrieveForeignKeys(tableInfo);
            }
            case INDEX: {
                LinkedHashMap<String, TableInfo.Index> indices = new LinkedHashMap<String, TableInfo.Index>();
                for (TableInfo.Index index : this.retrieveIndices(tableInfo)) {
                    if (index.isSystem()) continue;
                    indices.put(index.getName(), index);
                }
                return indices;
            }
            case UNIQUE: {
                return this.retrieveUniques(tableInfo);
            }
        }
        throw new IllegalStateException("Invalid Element" + (Object)((Object)element));
    }

    Map<String, TableInfo.Column> retrieveColumns(TableInfo table) {
        LinkedHashMap<String, TableInfo.Column> result = new LinkedHashMap<String, TableInfo.Column>();
        SchemaInfo schema = table.getSchema();
        for (MdEntry e : this.getColumns(schema, table.getName())) {
            String defaultValue = e.getString(MdColumn.C_DEFAULT);
            String schemaName = e.getString(MdColumn.C_SCHEMA);
            String tableName = e.getString(MdColumn.C_TABLE);
            String columnName = e.getString(MdColumn.C_NAME);
            if (columnName == null || !schema.getName().equals(schemaName) || !table.getName().equals(tableName)) continue;
            String typeName = e.getString(MdColumn.C_TYPE_NAME);
            SqlType type = typeName == null ? SqlType.UNKNOWN : this.retrieveType(typeName, e.getInt(MdColumn.C_DATA_TYPE), e.getInt(MdColumn.C_SIZE), e.getInt(MdColumn.C_DECIMAL_DIGITS));
            TableInfo.Column c = this.createColumn(columnName, type, e.getInt(MdColumn.C_POSITION), e.getInt(MdColumn.C_NULLABLE) == 1, this.translateDefault(defaultValue, type.getSqlKind()), e.getYesOrNo(MdColumn.C_AUTO_INCREMENT), e.getString(MdColumn.C_SEQUENCE, ""), table);
            result.put(c.getName(), c);
        }
        return result;
    }

    List<TableInfo.Index> retrieveIndices(TableInfo tableInfo) {
        ArrayList<TableInfo.Index> result = new ArrayList<TableInfo.Index>();
        SchemaInfo schema = tableInfo.getSchema();
        TreeMap<Integer, TableInfo.IndexColumn> idxColumns = new TreeMap<Integer, TableInfo.IndexColumn>();
        TableInfo.PrimaryKey pk = tableInfo.getPrimaryKey();
        String lastIndexName = "";
        boolean unique = false;
        for (MdEntry e : this.getIndices(schema, tableInfo.getName())) {
            String indexName = Predefined.notNull((String)e.getString(MdColumn.IX_NAME));
            int type = e.getInt(MdColumn.IX_TYPE);
            if (indexName.isEmpty() || pk.isPrimaryKey(indexName) || type == 0 || tableInfo.getUnique(indexName) != null) continue;
            if (!indexName.equals(lastIndexName)) {
                tableInfo.addIndex(result, lastIndexName, unique, idxColumns);
                lastIndexName = indexName;
            }
            boolean bl = unique = !e.getBoolean(MdColumn.IX_NON_UNIQUE);
            String columnName = Strings.unquote((String)Predefined.notNull((String)e.getString(MdColumn.IX_COLUMN_NAME)));
            if (columnName.isEmpty()) continue;
            idxColumns.put(e.getInt(MdColumn.IX_POSITION), new TableInfo.IndexColumn(columnName, "D".equals(e.getString(MdColumn.IX_SORT))));
        }
        tableInfo.addIndex(result, lastIndexName, unique, idxColumns);
        return result;
    }

    TableInfo.PrimaryKey retrievePrimaryKey(TableInfo tableInfo) {
        SchemaInfo schema = tableInfo.getSchema();
        TreeMap<Integer, TableInfo.Column> pkColumns = new TreeMap<Integer, TableInfo.Column>();
        String primaryKeyName = null;
        for (MdEntry rs : this.getPrimaryKeyCols(schema, tableInfo.getName())) {
            primaryKeyName = rs.getString(MdColumn.PK_NAME);
            String columnName = rs.getString(MdColumn.PK_COLUMN_NAME);
            if (columnName == null) continue;
            int seq = Integer.parseInt((String)Predefined.notNull((Object)rs.getString(MdColumn.PK_COL_SEQ), (Object)"0"));
            pkColumns.put(seq, tableInfo.getColumn(columnName));
        }
        TableInfo tableInfo2 = tableInfo;
        tableInfo2.getClass();
        return tableInfo2.new TableInfo.PrimaryKey(Predefined.notNull((String)primaryKeyName), pkColumns.values());
    }

    SqlType retrieveType(String typeName, int dataType, int size, int precision) {
        return SqlType.sqlType(typeName, SqlKind.kindFor(dataType), size, precision);
    }

    Iterable<MdEntry> getChecks(SchemaInfo schema, String tableName) {
        return Colls.emptyIterable();
    }

    Iterable<MdEntry> getColumns(SchemaInfo schema, String tableName) {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getColumns(schema.getCatalogName(), schema.getName(), tableName, null));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Iterable<MdEntry> getForeignKeys(SchemaInfo schema, String tableName) {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getImportedKeys(schema.getCatalogName(), schema.getName(), tableName));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Iterable<MdEntry> getIndices(SchemaInfo schema, String tableName) {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getIndexInfo(schema.getCatalogName(), schema.getName(), tableName, false, true));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Iterable<MdEntry> getPrimaryKeyCols(SchemaInfo schema, String tableName) {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getPrimaryKeys(schema.getCatalogName(), schema.getName(), tableName));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Iterable<MdEntry> getSequences(String schema) {
        return this.iterableFrom("select     START_WITH    as SEQ_START,   SEQUENCE_NAME as SEQ_NAME,   MINIMUM_VALUE as SEQ_MIN,   MAXIMUM_VALUE as SEQ_MAX,   INCREMENT     as SEQ_INC,   CYCLE_OPTION  as SEQ_CYCLE,   1             as SEQ_CACHE from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_SCHEMA = '%s' order by SEQUENCE_NAME ", schema);
    }

    Iterable<MdEntry> getTables(String catalog, String schemaName, String tablePattern, EnumSet<TableType> types) {
        try {
            return MetadataRetriever.iterableFrom(this.metaData.getTables(catalog, schemaName, tablePattern, TableType.setToArray(types)));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    Iterable<MdEntry> getUniques(SchemaInfo schema, String tableName) {
        return this.iterableFrom("select   T.CONSTRAINT_NAME,         C.COLUMN_NAME,         C.ORDINAL_POSITION from INFORMATION_SCHEMA.TABLE_CONSTRAINTS T join INFORMATION_SCHEMA.KEY_COLUMN_USAGE C on (   T.CONSTRAINT_NAME   = C.CONSTRAINT_NAME and   T.CONSTRAINT_SCHEMA = C.CONSTRAINT_SCHEMA and   T.CONSTRAINT_CATALOG = C.CONSTRAINT_CATALOG) where T.TABLE_CATALOG = '%s' and T.TABLE_SCHEMA = '%s' and T.TABLE_NAME = '%s' and T.CONSTRAINT_TYPE = 'UNIQUE'", schema.getCatalogName(), schema.getName(), tableName);
    }

    String getViewSql(SchemaInfo schema, String name) {
        try {
            ResultSet execute = this.execute("select COMMENT from INFORMATION_SCHEMA.SYSTEM_COMMENTS where OBJECT_CATALOG = '%s' and OBJECT_SCHEMA='%s' and OBJECT_NAME = '%s'", new Object[]{schema.getCatalogName(), schema.getName(), name});
            if (execute.next()) {
                return execute.getString(1);
            }
            return "";
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    private TableInfo.Column createColumn(String name, SqlType type, int position, boolean nullable, @Nullable String defaultValue, boolean autoIncremented, String sequenceName, TableInfo table) {
        TableInfo tableInfo = table;
        tableInfo.getClass();
        return tableInfo.new TableInfo.Column(name, type, position, nullable, autoIncremented, sequenceName, defaultValue);
    }

    private Map<String, TableInfo.Check> retrieveChecks(TableInfo tableInfo) {
        LinkedHashMap<String, TableInfo.Check> result = new LinkedHashMap<String, TableInfo.Check>();
        MetadataObject check = null;
        for (MdEntry e : this.getChecks(tableInfo.getSchema(), tableInfo.getName())) {
            String name = e.getString(MdColumn.CONSTRAINT_NAME, "");
            if (check == null || !check.getName().equals(name)) {
                TableInfo tableInfo2 = tableInfo;
                tableInfo2.getClass();
                check = tableInfo2.new TableInfo.Check(name, e.getString(MdColumn.CHECK_CONDITION, ""), e.getYesOrNo(MdColumn.CONSTRAINT_ENABLED));
                result.put(name, (TableInfo.Check)check);
            }
            ((TableInfo.Check)check).cols.add(e.getString(MdColumn.C_NAME));
        }
        return result;
    }

    private Map<String, TableInfo.ForeignKey> retrieveForeignKeys(TableInfo tableInfo) {
        LinkedHashMap<String, TableInfo.ForeignKey> result = new LinkedHashMap<String, TableInfo.ForeignKey>();
        SchemaInfo schema = tableInfo.getSchema();
        TreeMap<Integer, TableInfo.FkColumn> fkColumns = new TreeMap<Integer, TableInfo.FkColumn>();
        String lastFkName = "";
        QName references = QName.EMPTY;
        for (MdEntry rs : this.getForeignKeys(schema, tableInfo.getName())) {
            String fkName = Predefined.notNull((String)rs.getString(MdColumn.FK_NAME));
            if (fkName.isEmpty()) continue;
            if (!fkName.equals(lastFkName)) {
                tableInfo.addFk(result, lastFkName, references, fkColumns);
                lastFkName = fkName;
                references = QName.createQName((String)Predefined.notNull((String)rs.getString(MdColumn.FK_PK_SCHEMA)), (String)Predefined.notNull((String)rs.getString(MdColumn.FK_PK_TABLE)));
            }
            String columnName = Strings.unquote((String)Predefined.notNull((String)rs.getString(MdColumn.FK_COLUMN_NAME)));
            String pkColumnName = Strings.unquote((String)Predefined.notNull((String)rs.getString(MdColumn.FK_PK_COLUMN_NAME)));
            if (columnName.isEmpty() || pkColumnName.isEmpty()) continue;
            fkColumns.put(rs.getInt(MdColumn.PK_COL_SEQ), new TableInfo.FkColumn(columnName, pkColumnName));
        }
        tableInfo.addFk(result, lastFkName, references, fkColumns);
        return result;
    }

    private Map<String, TableInfo.Index> retrieveUniques(TableInfo tableInfo) {
        LinkedHashMap<String, TableInfo.Index> result = new LinkedHashMap<String, TableInfo.Index>();
        TreeMap<Integer, TableInfo.IndexColumn> idxColumns = new TreeMap<Integer, TableInfo.IndexColumn>();
        String lastName = "";
        for (MdEntry e : this.getUniques(tableInfo.getSchema(), tableInfo.getName())) {
            String columnName;
            String name = Predefined.notNull((String)e.getString(MdColumn.CONSTRAINT_NAME));
            if (name.isEmpty()) continue;
            if (!name.equals(lastName)) {
                MetadataRetriever.addUnique(result, tableInfo, lastName, idxColumns);
                lastName = name;
            }
            if ((columnName = Strings.unquote((String)Predefined.notNull((String)e.getString(MdColumn.C_NAME)))).isEmpty()) continue;
            idxColumns.put(e.getInt(MdColumn.C_POSITION), new TableInfo.IndexColumn(columnName, false));
        }
        MetadataRetriever.addUnique(result, tableInfo, lastName, idxColumns);
        return result;
    }

    public static MetadataRetriever createRetriever(DatabaseType dbType, Connection connection, DatabaseMetaData metaData) {
        switch (dbType) {
            case ORACLE: {
                return new OracleMetadataRetriever(connection, metaData);
            }
            case HSQLDB: 
            case HSQLDB_NOSEQ: {
                return new HsqlDbMetadataRetriever(connection, metaData);
            }
            case POSTGRES: {
                return new PostgresMetadataRetriever(connection, metaData);
            }
        }
        return new MetadataRetriever(connection, metaData);
    }

    static String checkMacro(String value, DbMacro macroToTest, DbMacro macroToReturn) {
        return macroToTest.getStringValue().equalsIgnoreCase(value) ? macroToReturn.name() : value;
    }

    static String checkMacros(String value, DbMacro ... macros) {
        for (DbMacro macro : macros) {
            if (!macro.getStringValue().equalsIgnoreCase(value)) continue;
            return macro.name();
        }
        return value;
    }

    static Iterable<MdEntry> iterableFrom(@NotNull ResultSet rs) {
        return new MdEntryIterable(rs);
    }

    private static void addUnique(Map<String, TableInfo.Index> result, TableInfo tableInfo, String name, Map<Integer, TableInfo.IndexColumn> idxColumns) {
        if (!name.isEmpty()) {
            TableInfo tableInfo2 = tableInfo;
            tableInfo2.getClass();
            result.put(name, tableInfo2.new TableInfo.Index(name, true, idxColumns.values()));
        }
        idxColumns.clear();
    }

    private static class MdEntryIterable
    implements Iterable<MdEntry> {
        private final Map<String, Integer> columnMap;
        private final MdEntry mdEntry;
        private final ResultSet rs;
        private final BitSet unReadColumns;

        public MdEntryIterable(@NotNull ResultSet rs) {
            try {
                rs.setFetchSize(20);
            }
            catch (NullPointerException | SQLException exception) {
                // empty catch block
            }
            this.rs = rs;
            this.columnMap = JdbcUtils.loadColumns((ResultSet)rs, (boolean)true);
            this.unReadColumns = new BitSet(this.columnMap.size() + 1);
            this.mdEntry = new MdEntry(rs, this.columnMap, this.unReadColumns);
        }

        @Override
        public Iterator<MdEntry> iterator() {
            return new ImmutableIterator<MdEntry>(){

                public boolean hasNext() {
                    try {
                        return rs.next();
                    }
                    catch (SQLException e) {
                        return false;
                    }
                }

                public MdEntry next() {
                    return mdEntry;
                }
            };
        }
    }
}

