/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.MdColumn;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.exception.IntrospectorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OracleMetadataRetriever
extends MetadataRetriever {
    private static final int INT_PRECISION = -127;
    private static final Map<String, SqlKind> kindMap = new HashMap<String, SqlKind>();
    private static final T[] ts;

    public OracleMetadataRetriever(Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData);
    }

    @Override
    public String getViewSql(SchemaInfo schema, String name) {
        try {
            ResultSet execute = this.execute("select COMMENTS from ALL_TAB_COMMENTS where OWNER = '%s' and TABLE_NAME = '%s'", new Object[]{schema.getName(), name});
            if (execute.next()) {
                return execute.getString(1);
            }
            return "";
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    @Override
    protected String translateDefault(@Nullable String v, SqlKind sqlKind) {
        if (v == null) {
            return null;
        }
        String value = v.trim();
        if (sqlKind == SqlKind.BOOLEAN) {
            return ("0".equals(value) ? DbMacro.False : DbMacro.True).name();
        }
        if ("current_timestamp".equalsIgnoreCase(value)) {
            return DbMacro.CurrentTime.name();
        }
        if ("sysdate".equalsIgnoreCase(value)) {
            return DbMacro.CurrentDate.name();
        }
        if ("nchr(160)".equalsIgnoreCase(value)) {
            return DbMacro.EmptyString.name();
        }
        return super.translateDefault(value, sqlKind);
    }

    @Override
    Map<String, TableInfo.Column> retrieveColumns(TableInfo table) {
        LinkedHashMap<String, TableInfo.Column> result = new LinkedHashMap<String, TableInfo.Column>();
        SchemaInfo schema = table.getSchema();
        for (MdEntry e : this.oraGetColumns(schema, table.getName())) {
            String columnName = e.getString(MdColumn.C_NAME);
            TableInfo.Column column = this.createColumn(table, columnName, e);
            if (column == null) continue;
            result.put(columnName, column);
        }
        return result;
    }

    @Override
    Iterable<MdEntry> getChecks(SchemaInfo schema, String tableName) {
        return this.getConstraints(schema, tableName, "C");
    }

    @Override
    Iterable<MdEntry> getColumns(SchemaInfo schema, String tableName) {
        throw new IllegalStateException();
    }

    @Override
    Iterable<MdEntry> getIndices(SchemaInfo schema, String tableName) {
        try {
            if (tableName.startsWith("_")) {
                return Colls.emptyIterable();
            }
            return OracleMetadataRetriever.iterableFrom(this.metaData.getIndexInfo(schema.getCatalogName(), schema.getName(), tableName, false, true));
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    @Override
    Iterable<MdEntry> getSequences(String schema) {
        return this.iterableFrom("SELECT  SEQUENCE_NAME as SEQ_NAME,  MIN_VALUE     as SEQ_START,  MIN_VALUE     as SEQ_MIN,  MAX_VALUE     as SEQ_MAX,  INCREMENT_BY  as SEQ_INC,  ORDER_FLAG    as SEQ_ORDER,  CACHE_SIZE    as SEQ_CACHE,  LAST_NUMBER   as SEQ_LAST,  case when CYCLE_FLAG = 'Y' then 'YES' else 'NO' end as SEQ_CYCLE from ALL_SEQUENCES where SEQUENCE_OWNER = '%s' order by SEQUENCE_NAME", schema);
    }

    @Override
    Iterable<MdEntry> getUniques(SchemaInfo schema, String tableName) {
        return this.getConstraints(schema, tableName, "U");
    }

    private boolean checkBoolean(TableInfo table, @NotNull String columnName) {
        for (TableInfo.Check check : table.getChecks()) {
            if (!check.hasColumn(columnName) || !check.getCondition().endsWith(" in (0,1)")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private TableInfo.Column createColumn(TableInfo table, @Nullable String columnName, MdEntry e) {
        String comments;
        if (columnName == null) {
            return null;
        }
        String defaultValue = e.getString(MdColumn.C_DEFAULT);
        SqlType sqlType = this.findType(table, columnName, e);
        SqlKind kind = sqlType.getSqlKind();
        boolean serial = false;
        String sequenceName = "";
        if (kind == SqlKind.INT && (serial = (comments = e.getString(MdColumn.C_REMARKS, "").trim()).contains("Serial("))) {
            String s;
            if (comments.startsWith("BigSerial")) {
                sqlType = SqlType.sqlType(sqlType.getName(), SqlKind.BIGINT);
            }
            sequenceName = (s = comments.substring(comments.indexOf(44) + 1)).endsWith(")") ? s.substring(0, s.length() - 1) : s;
        }
        TableInfo tableInfo = table;
        tableInfo.getClass();
        return tableInfo.new TableInfo.Column(columnName, sqlType, e.getInt(MdColumn.C_POSITION), e.getYesOrNo(MdColumn.C_NULLABLE), serial, sequenceName, this.translateDefault(defaultValue, kind));
    }

    private SqlType findType(TableInfo table, String columnName, MdEntry e) {
        String typeName = e.getString(MdColumn.C_TYPE_NAME, "");
        int precision = e.getInt(MdColumn.ORA_PRECISION, -1);
        int decimalDigits = e.getInt(MdColumn.C_DECIMAL_DIGITS);
        int p = typeName.indexOf(40);
        SqlKind kind = (SqlKind)((Object)Predefined.notNull((Object)((Object)kindMap.get(p == -1 ? typeName : typeName.substring(0, p))), (Object)((Object)SqlKind.OTHER)));
        SqlType sqlType = SqlType.sqlType(typeName, kind, precision, decimalDigits);
        if (kind == SqlKind.VARCHAR || kind == SqlKind.NVARCHAR) {
            sqlType = SqlType.sqlType(typeName, kind, e.getInt(MdColumn.C_SIZE), 0);
        } else if (kind == SqlKind.DECIMAL && decimalDigits == 0) {
            if (precision == -1) {
                sqlType = SqlType.sqlType(typeName, SqlKind.INT);
            } else if (precision == 1 && this.checkBoolean(table, columnName)) {
                sqlType = SqlType.BOOLEAN;
            }
        }
        return sqlType;
    }

    private Iterable<MdEntry> oraGetColumns(SchemaInfo schema, String tableName) {
        return this.iterableFrom("select C.COLUMN_NAME, C.DATA_TYPE TYPE_NAME, C.COLUMN_ID ORDINAL_POSITION, C.CHAR_LENGTH COLUMN_SIZE, C.DATA_PRECISION ORA_PRECISION, C.DATA_SCALE DECIMAL_DIGITS, C.NULLABLE, C.DATA_DEFAULT COLUMN_DEF, COM.COMMENTS REMARKS from ALL_TAB_COLUMNS C left outer join ALL_COL_COMMENTS COM on (C.OWNER = COM.OWNER and C.TABLE_NAME = COM.TABLE_NAME and C.COLUMN_NAME = COM.COLUMN_NAME)where C.OWNER = '%s' and C.TABLE_NAME = '%s'", schema, tableName);
    }

    private Iterable<MdEntry> getConstraints(SchemaInfo schema, String tableName, String type) {
        return this.iterableFrom("select   C.CONSTRAINT_NAME,         CC.COLUMN_NAME,         CC.POSITION                                          as ORDINAL_POSITION,         C.SEARCH_CONDITION                                   as CHECK_CONDITION,         case when C.STATUS = 'ENABLED' then 'Y' else 'N' end as CONSTRAINT_ENABLED from ALL_CONSTRAINTS C join ALL_CONS_COLUMNS CC on (     CC.TABLE_NAME      = C.TABLE_NAME and      CC.OWNER           = C.OWNER and      CC.CONSTRAINT_NAME = C.CONSTRAINT_NAME)where C.OWNER = '%s' and C.TABLE_NAME = '%s' and C.CONSTRAINT_TYPE = '%s'", schema.getName(), tableName, type);
    }

    static {
        for (T t : ts = new T[]{new T(SqlKind.VARCHAR, "VARCHAR2", "VARCHAR", "CHAR"), new T(SqlKind.NVARCHAR, "NVARCHAR2", "NVARCHAR", "NCHAR"), new T(SqlKind.DATETIME, "TIMESTAMP"), new T(SqlKind.DATE, "DATE"), new T(SqlKind.DECIMAL, "NUMBER"), new T(SqlKind.BINARY, "RAW", "LONG RAW"), new T(SqlKind.CLOB, "CLOB", "NCLOB", "LONG"), new T(SqlKind.BLOB, "BLOB"), new T(SqlKind.XML, "XMLType"), new T(SqlKind.ROW_ID, "ROWID"), new T(SqlKind.DOUBLE, "FLOAT", "BINARY_DOUBLE", "BINARY_FLOAT")}) {
            for (String name : t.names) {
                kindMap.put(name, t.k);
            }
        }
    }

    private static class T {
        final SqlKind k;
        final String[] names;

        T(SqlKind k, String ... names) {
            this.k = k;
            this.names = names;
        }
    }
}

