/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Tuple;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.exception.IntrospectorException;

class PostgresMetadataRetriever
extends MetadataRetriever {
    private static final Map<String, SqlKind> kindMap = Maps.hashMap((Tuple)Tuple.tuple((Object)"text", (Object)((Object)SqlKind.CLOB)), (Tuple[])new Tuple[0]);

    public PostgresMetadataRetriever(Connection connection, DatabaseMetaData metaData) {
        super(connection, metaData);
    }

    @Override
    public String getViewSql(SchemaInfo schema, String name) {
        try {
            ResultSet execute = this.execute("select description from pg_description\njoin pg_class on pg_description.objoid = pg_class.oid\njoin pg_namespace on pg_class.relnamespace = pg_namespace.oid\nwhere relname = '%s' and nspname='%s'", new Object[]{name, schema.getName()});
            if (execute.next()) {
                return execute.getString(1);
            }
            return "";
        }
        catch (SQLException e) {
            throw new IntrospectorException(e);
        }
    }

    @Override
    protected String translateDefault(String v, SqlKind sqlKind) {
        if (v == null) {
            return null;
        }
        String value = v.trim();
        if (v.startsWith("nextval")) {
            return null;
        }
        if ("now()".equalsIgnoreCase(value)) {
            return DbMacro.CurrentTime.name();
        }
        if ("('now'::text)::date".equalsIgnoreCase(value)) {
            return DbMacro.CurrentDate.name();
        }
        if ("''::character varying".equalsIgnoreCase(value)) {
            return DbMacro.EmptyString.name();
        }
        return super.translateDefault(value, sqlKind);
    }

    @Override
    SqlType retrieveType(String typeName, int dataType, int size, int precision) {
        SqlKind kind = kindMap.get(typeName);
        SqlKind sqlKind = kind = kind != null ? kind : SqlKind.kindFor(dataType);
        if (kind == SqlKind.VARCHAR) {
            return SqlType.sqlType(typeName, SqlKind.NVARCHAR, size, 0);
        }
        return SqlType.sqlType(typeName, kind, size, precision);
    }

    @Override
    Iterable<MdEntry> getSequences(String schema) {
        return this.iterableFrom("select     START_VALUE   as SEQ_START,   SEQUENCE_NAME as SEQ_NAME,   MINIMUM_VALUE as SEQ_MIN,   MAXIMUM_VALUE as SEQ_MAX,   INCREMENT     as SEQ_INC,   CYCLE_OPTION  as SEQ_CYCLE,   1             as SEQ_CACHE from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_SCHEMA = '%s' and SEQUENCE_NAME not like 'SEQUENCER_%%_seq' order by SEQUENCE_NAME ", schema);
    }
}

