/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.Option;
import mulesoft.common.util.Files;
import mulesoft.database.DbIntrospector;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.MdColumn;
import mulesoft.database.introspect.MdEntry;
import mulesoft.database.introspect.MetadataObject;
import mulesoft.database.introspect.SchemaObject;
import mulesoft.database.introspect.SequenceInfo;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.TableInfo;
import mulesoft.database.introspect.TableType;
import mulesoft.database.introspect.ViewInfo;
import org.jetbrains.annotations.NotNull;

public final class SchemaInfo
extends MetadataObject<SchemaInfo> {
    private final String catalogName;
    private boolean current;
    private final DbIntrospector introspector;
    private final String plainName;
    private final String qualification;
    private Map<String, SchemaObject<?>> schemaObjects;
    private Map<String, SequenceInfo> sequences;
    private static final long serialVersionUID = -5309848447599233878L;

    public SchemaInfo(@NotNull DbIntrospector introspector, @NotNull String catalogName, @NotNull String name) {
        super(name);
        this.introspector = introspector;
        this.catalogName = catalogName.isEmpty() ? introspector.getDefaultCatalog() : catalogName;
        this.qualification = introspector.getDefaultCatalog().equals(catalogName) ? "" : catalogName;
        this.schemaObjects = null;
        this.sequences = null;
        String schemaPrefix = introspector.getSchemaPrefix();
        this.plainName = name.startsWith(schemaPrefix) ? name.substring(schemaPrefix.length()) : name;
    }

    public void dumpSql(Writer writer, boolean lexSorted) {
        PrintWriter w = Files.printWriter((Writer)writer);
        ImmutableCollection<SequenceInfo> ss = this.getSequences();
        ImmutableList<TableInfo.Column> serials = this.collectSerials();
        if (!ss.isEmpty()) {
            SchemaInfo.generateSequences(w, ss);
        } else if (!serials.isEmpty()) {
            SchemaInfo.generateSequences(w, (Seq<SequenceInfo>)serials.map(SchemaInfo::asSequence));
        }
        for (SchemaObject t : this.getTables()) {
            ((TableInfo)t).dumpSql(w, lexSorted);
            w.println();
        }
        for (SchemaObject t : this.getViews()) {
            ((ViewInfo)t).dumpSql(w, true);
            w.println();
        }
        for (SchemaObject t : this.getTables()) {
            ((TableInfo)t).dumpForeignKeys(w);
        }
        for (SchemaObject t : this.getTables()) {
            ((TableInfo)t).dumpTableIndices(w);
        }
        if (!serials.isEmpty()) {
            this.dumpSerials((List<TableInfo.Column>)serials, w);
        }
    }

    public void loadAll() {
        this.getSequences();
        for (TableInfo t : this.getTables()) {
            t.loadAll();
        }
        for (ViewInfo v : this.getViews()) {
            v.loadAll();
        }
    }

    public void markCurrent() {
        this.current = true;
    }

    @Override
    public boolean sameAs(SchemaInfo to) {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getPlainName() {
        return this.plainName;
    }

    public Map<String, SchemaObject<?>> getSchemaObjects() {
        if (this.schemaObjects == null) {
            this.schemaObjects = this.retrieveSchemaObjects("%", EnumSet.allOf(TableType.class));
        }
        return this.schemaObjects;
    }

    public SequenceInfo getSequence(String name) {
        this.getSequences();
        return this.sequences.get(name);
    }

    public ImmutableCollection<SequenceInfo> getSequences() {
        if (this.sequences == null) {
            this.sequences = this.retrieveSequences();
        }
        return Colls.immutable(this.sequences.values());
    }

    public boolean isCurrent() {
        return this.current;
    }

    public Option<TableInfo> getTable(String name) {
        SchemaObject<?> schemaObject = this.getSchemaObjects().get(name);
        return schemaObject instanceof TableInfo ? Option.some((Object)Predefined.cast(schemaObject)) : Option.empty();
    }

    public Seq<TableInfo> getTables() {
        return Colls.immutable(this.getSchemaObjects().values()).filter(s -> s instanceof TableInfo).map(Predefined::cast);
    }

    public Option<ViewInfo> getView(String name) {
        SchemaObject<?> schemaObject = this.getSchemaObjects().get(name);
        return schemaObject instanceof ViewInfo ? Option.some((Object)Predefined.cast(schemaObject)) : Option.empty();
    }

    public Seq<ViewInfo> getViews() {
        return Colls.immutable(this.getSchemaObjects().values()).filter(s -> s instanceof ViewInfo).map(Predefined::cast);
    }

    DbIntrospector getIntrospector() {
        return this.introspector;
    }

    @Override
    @NotNull
    String getQualification() {
        return this.qualification;
    }

    private ImmutableList<TableInfo.Column> collectSerials() {
        return this.getTables().flatMap(TableInfo::getColumns).filter(TableInfo.Column::isSerial).toList();
    }

    private void dumpSerials(List<TableInfo.Column> serials, PrintWriter w) {
        w.println("-- if NeedsSerialComment");
        for (TableInfo.Column c : serials) {
            String s = (c.getType().getSqlKind() == SqlKind.INT ? DbMacro.Serial : DbMacro.BigSerial).name();
            w.printf("comment on column %s.%s is '%s(%d,%s)';;%n", c.getTable().asQName(), c.getName(), s, c.getSequenceStart(), c.getSequenceName());
        }
        w.println("-- end");
    }

    private Map<String, SchemaObject<?>> retrieveSchemaObjects(String tableNamePattern, EnumSet<TableType> tableTypes) {
        TreeMap result = new TreeMap();
        for (MdEntry e : this.introspector.getRetriever().getTables(this.getCatalogName(), this.getName(), tableNamePattern, tableTypes)) {
            TableType type;
            SchemaObject t;
            String tableName = e.getString(MdColumn.T_NAME);
            if (tableName == null || (t = (type = TableType.valueOf(e.getString(MdColumn.T_TYPE, DbMacro.TableName.name()))).isTable() ? new TableInfo(this, tableName, e.getString(MdColumn.T_REMARKS), type) : (type.isView() ? new ViewInfo(this, tableName, e.getString(MdColumn.T_REMARKS)) : null)) == null) continue;
            result.put(t.getName(), t);
        }
        return result;
    }

    private Map<String, SequenceInfo> retrieveSequences() {
        TreeMap<String, SequenceInfo> result = new TreeMap<String, SequenceInfo>();
        for (MdEntry e : this.introspector.getRetriever().getSequences(this.getName())) {
            String name = e.getString(MdColumn.SEQ_NAME);
            if (name == null) continue;
            SequenceInfo s = new SequenceInfo(this, name, e.getDecimal(MdColumn.SEQ_START), e.getDecimal(MdColumn.SEQ_MIN), e.getDecimal(MdColumn.SEQ_MAX), e.getInt(MdColumn.SEQ_INC), e.getYesOrNo(MdColumn.SEQ_CYCLE), e.getInt(MdColumn.SEQ_CACHE), e.getDecimal(MdColumn.SEQ_LAST));
            result.put(name, s);
        }
        return result;
    }

    public static void generateSequences(PrintWriter w, Runnable r) {
        w.println("-- if NeedsCreateSequence");
        w.println();
        r.run();
        w.println("-- end");
    }

    @NotNull
    private static SequenceInfo asSequence(TableInfo.Column column) {
        return new SequenceInfo(column.getTable().getSchema(), column.getSequenceName());
    }

    private static void generateSequences(PrintWriter w, Seq<SequenceInfo> ss) {
        SchemaInfo.generateSequences(w, () -> {
            for (SequenceInfo s : ss) {
                s.dumpSql(w);
                w.println();
            }
        });
    }
}

