/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.PrintWriter;
import java.math.BigDecimal;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SchemaObject;
import org.jetbrains.annotations.Nullable;

public class SequenceInfo
extends SchemaObject<SequenceInfo> {
    private final int cache;
    private final boolean cycle;
    private final int inc;
    private final BigDecimal last;
    private final BigDecimal max;
    private final BigDecimal min;
    private final BigDecimal start;
    private static final long serialVersionUID = -3741882772234848627L;

    SequenceInfo(SchemaInfo schema, String name) {
        this(schema, name, BigDecimal.ONE, BigDecimal.ONE, null, 1, false, 1, null);
    }

    SequenceInfo(SchemaInfo schema, String name, BigDecimal start, BigDecimal min, @Nullable BigDecimal max, int inc, boolean cycle, int cache, @Nullable BigDecimal last) {
        super(schema, name, "");
        this.start = start;
        this.min = min;
        this.max = max;
        this.inc = inc;
        this.cycle = cycle;
        this.cache = cache;
        this.last = last;
    }

    public void dumpSql(PrintWriter w) {
        w.printf("create sequence QName(%s, %s)%n", this.getSchema().getPlainName(), this.getName());
        w.printf("\tstart with SequenceStartValue(%d)%n", this.start.longValue());
        w.printf("\tincrement by %d SequenceCache;;%n", this.inc);
    }

    @Override
    public boolean sameAs(SequenceInfo to) {
        return super.equals(to) && this.inc == to.inc;
    }

    public int getCache() {
        return this.cache;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public int getInc() {
        return this.inc;
    }

    @Nullable
    public BigDecimal getLast() {
        return this.last;
    }

    @Nullable
    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }
}

