/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.util.HashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.IntIntTuple;
import mulesoft.common.core.Tuple;

public enum SqlKind {
    OTHER(1111),
    REFERENCE(2006),
    DATA_LINK(70),
    XML(2009),
    BINARY(-2, -4, -3),
    BOOLEAN(-7, 16),
    ROW_ID(-8),
    INT(4, 5, -6),
    BIGINT(-5),
    DOUBLE(8, 6, 7),
    BLOB(2004),
    CLOB(2005, 2011),
    OBJECT(2003, 2001, 2000, 2002),
    VARCHAR(new int[]{1, 12, -1}){

        @Override
        int fixSize(int size) {
            return size;
        }

        @Override
        public IntIntTuple fixSizes(int s, int p) {
            return Tuple.tuple((int)s, (int)0);
        }
    }
    ,
    NVARCHAR(new int[]{-15, -9, -16}){

        @Override
        int fixSize(int size) {
            return size;
        }

        @Override
        public IntIntTuple fixSizes(int s, int p) {
            return Tuple.tuple((int)s, (int)0);
        }
    }
    ,
    DECIMAL(new int[]{2, 3}){

        @Override
        int fixSize(int size) {
            return size;
        }

        @Override
        int fixPrecision(int precision) {
            return precision;
        }

        @Override
        IntIntTuple fixSizes(int s, int p) {
            return Tuple.tuple((int)s, (int)p);
        }
    }
    ,
    DATE(91),
    DATETIME(new int[]{92, 93}){

        @Override
        int fixPrecision(int precision) {
            return precision;
        }
    };

    private static final IntIntTuple ZERO_ZERO;

    private SqlKind(int ... sqlTypes) {
        for (int t : sqlTypes) {
            TTK.typeToKind.put(t, this);
        }
    }

    public boolean needsParameter() {
        return this == DATETIME || this == NVARCHAR;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    int fixPrecision(int precision) {
        return 0;
    }

    int fixSize(int size) {
        return 0;
    }

    IntIntTuple fixSizes(int size, int precision) {
        return ZERO_ZERO;
    }

    public static SqlKind kindFor(int sqlType) {
        return (SqlKind)((Object)Predefined.notNull(TTK.typeToKind.get(sqlType), (Object)((Object)OTHER)));
    }

    static {
        ZERO_ZERO = Tuple.tuple((int)0, (int)0);
    }

    private static class TTK {
        private static final Map<Integer, SqlKind> typeToKind = new HashMap<Integer, SqlKind>();

        private TTK() {
        }
    }
}

