/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import mulesoft.common.core.Tuple;
import mulesoft.common.core.Tuple4;
import mulesoft.database.introspect.SqlKind;
import org.jetbrains.annotations.NotNull;

public final class SqlType
implements Serializable,
Comparable<SqlType> {
    private final String name;
    private final int precision;
    private final int size;
    private final SqlKind sqlKind;
    private static final Map<Tuple4<SqlKind, String, Integer, Integer>, SqlType> types = new HashMap<Tuple4<SqlKind, String, Integer, Integer>, SqlType>();
    private static final long serialVersionUID = 2614819974745473431L;
    public static final SqlType UNKNOWN = SqlType.sqlType("<UNKNOWN>", SqlKind.OTHER);
    public static final SqlType BOOLEAN = SqlType.sqlType("boolean", SqlKind.BOOLEAN);

    private SqlType(String name, SqlKind kind, int size, int precision) {
        this.name = name;
        this.sqlKind = kind;
        this.size = size;
        this.precision = precision;
    }

    @Override
    public int compareTo(@NotNull SqlType that) {
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SqlType && ((SqlType)that).name.equals(this.name);
    }

    public String format() {
        boolean plain;
        int n2;
        int n1;
        String t = this.sqlKind.toString();
        if (this.size <= 0 && this.precision > 0) {
            n1 = this.precision;
            n2 = 0;
        } else {
            n1 = this.size;
            n2 = this.precision;
        }
        boolean bl = plain = n1 < 0 || n1 == 0 && !this.sqlKind.needsParameter();
        return plain ? t : (n2 <= 0 ? String.format("%s(%d)", t, n1) : String.format("%s(%d,%d)", t, n1, n2));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean sameAs(SqlType type) {
        return this.sqlKind == type.sqlKind && this.precision == type.precision && this.size == type.size;
    }

    public String toString() {
        return String.format("%s %s(%d,%d)", new Object[]{this.name, this.sqlKind, this.size, this.precision});
    }

    public String getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getSize() {
        return this.size;
    }

    public SqlKind getSqlKind() {
        return this.sqlKind;
    }

    public static SqlType sqlType(String name, SqlKind kind) {
        return SqlType.sqlType(name, kind, 0, 0);
    }

    public static SqlType sqlType(String name, SqlKind kind, int size, int precision) {
        int sz = kind.fixSize(size);
        int p = kind.fixPrecision(precision);
        Tuple4 key = Tuple.tuple((Object)((Object)kind), (Object)name, (Object)sz, (Object)p);
        return types.computeIfAbsent((Tuple4<SqlKind, String, Integer, Integer>)key, k -> new SqlType(name, kind, sz, p));
    }
}

