/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableCollection;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.QName;
import mulesoft.common.core.Strings;
import mulesoft.common.util.Files;
import mulesoft.database.DatabaseType;
import mulesoft.database.DbIntrospector;
import mulesoft.database.DbMacro;
import mulesoft.database.introspect.MetadataObject;
import mulesoft.database.introspect.MetadataRetriever;
import mulesoft.database.introspect.SchemaInfo;
import mulesoft.database.introspect.SchemaObject;
import mulesoft.database.introspect.SqlKind;
import mulesoft.database.introspect.SqlType;
import mulesoft.database.introspect.TableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableInfo
extends SchemaObject<TableInfo> {
    private final EnumMap<Element, Map<String, ? extends TableObject<?>>> elements;
    private transient boolean notLoaded;
    private PrimaryKey primaryKey;
    private final TableType tableType;
    public static final int MAX_DB_ID_LENGHT = 30;
    private static final long serialVersionUID = 3257290248802284852L;

    TableInfo(SchemaInfo schema, String tableName, @Nullable String remarks, TableType type) {
        super(schema, tableName, remarks);
        this.tableType = type;
        this.primaryKey = null;
        this.notLoaded = true;
        this.elements = new EnumMap(Element.class);
    }

    public String asQName() {
        return TableInfo.getQName(this.getSchema().getPlainName(), this.getName());
    }

    public void dropForeignKeys(PrintWriter w) {
        for (ForeignKey fk : this.getForeignKeys()) {
            fk.dropSql(w);
        }
    }

    public void dumpForeignKeys(PrintWriter w) {
        for (ForeignKey fk : this.getForeignKeys()) {
            fk.dumpSql(w);
            w.println();
        }
    }

    public void dumpSql(Writer writer, boolean lexSorted) {
        PrintWriter w = Files.printWriter((Writer)writer);
        w.printf("create table %s (%n", this.asQName());
        PrimaryKey pk = this.getPrimaryKey();
        boolean nl = false;
        for (Column column : lexSorted ? this.getColumns().sorted(Comparator.comparing(MetadataObject::getName)) : this.getColumns()) {
            if (nl) {
                w.println(",");
            }
            nl = true;
            w.print("\t");
            if (!lexSorted) {
                w.print(column.toString());
                continue;
            }
            String def = column.defaultValue;
            column.defaultValue = null;
            w.print(column.toString());
            column.defaultValue = def;
        }
        ImmutableCollection<Index> uniques = this.getUniques();
        if (!pk.isUndefined()) {
            w.printf(",%n%n\t%s", pk.generateSql());
        }
        for (Index unique : uniques) {
            w.printf(",%n\t%s", unique.generateUniqueSql());
        }
        w.println();
        w.println(");;");
    }

    public void dumpTableIndices(PrintWriter w) {
        for (Index ix : this.getIndices()) {
            if (ix.isSystem()) continue;
            ix.dumpSql(w);
            w.println();
        }
    }

    public void loadAll() {
        if (this.notLoaded) {
            this.getChecks();
            this.getUniques();
            this.getColumns();
            this.getForeignKeys();
            this.getPrimaryKey();
            this.getIndices();
            this.notLoaded = false;
        }
    }

    @Override
    public boolean sameAs(TableInfo tt) {
        this.loadAll();
        tt.loadAll();
        for (Element e : Element.values()) {
            if (!this.elementsDiffer(tt, e)) continue;
            return false;
        }
        return this.primaryKey.sameAs(tt.primaryKey);
    }

    public Check getCheck(String name) {
        return (Check)Predefined.cast(this.elementMap(Element.CHECK).get(name));
    }

    public ImmutableCollection<Check> getChecks() {
        return this.getElements(Element.CHECK);
    }

    public Column getColumn(String name) {
        return (Column)Predefined.cast(this.elementMap(Element.COLUMN).get(name));
    }

    public ImmutableCollection<Column> getColumns() {
        return this.getElements(Element.COLUMN);
    }

    public <T extends TableObject<T>> T getElement(String name, Element element) {
        return (T)((TableObject)Predefined.cast(this.elementMap(element).get(name)));
    }

    public <T extends TableObject<T>> ImmutableCollection<T> getElements(Element element) {
        return (ImmutableCollection)Predefined.cast((Object)Colls.immutable(this.elementMap(element).values()));
    }

    public ForeignKey getForeignKey(String name) {
        return (ForeignKey)Predefined.cast(this.elementMap(Element.FOREIGN_KEY).get(name));
    }

    public ImmutableCollection<ForeignKey> getForeignKeys() {
        return this.getElements(Element.FOREIGN_KEY);
    }

    public Index getIndex(String name) {
        return (Index)Predefined.cast(this.elementMap(Element.INDEX).get(name));
    }

    public ImmutableCollection<Index> getIndices() {
        return this.getElements(Element.INDEX);
    }

    @NotNull
    public PrimaryKey getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.getRetriever().retrievePrimaryKey(this);
        }
        return this.primaryKey;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public Index getUnique(String name) {
        return (Index)Predefined.cast(this.elementMap(Element.UNIQUE).get(name));
    }

    public ImmutableCollection<Index> getUniques() {
        return this.getElements(Element.UNIQUE);
    }

    void addFk(Map<String, ForeignKey> result, String name, QName references, Map<Integer, FkColumn> fkColumns) {
        if (!name.isEmpty()) {
            result.put(name, new ForeignKey(name, references, fkColumns.values()));
        }
        fkColumns.clear();
    }

    void addIndex(List<Index> result, String name, boolean unique, Map<Integer, IndexColumn> idxColumns) {
        if (!name.isEmpty()) {
            result.add(new Index(name, unique, idxColumns.values()));
        }
        idxColumns.clear();
    }

    DbIntrospector getIntrospector() {
        return this.getSchema().getIntrospector();
    }

    private <T extends TableObject<T>> Map<String, T> elementMap(Element element) {
        Map map = (Map)Predefined.cast(this.elements.get((Object)element));
        if (map == null) {
            map = (Map)Predefined.cast(this.getRetriever().retrieve(this, element));
            this.elements.put(element, map);
        }
        return map;
    }

    private <T extends TableObject<T>> boolean elementsDiffer(TableInfo tt, Element e) {
        Map<String, T> froms = this.elementMap(e);
        Map<String, T> tos = tt.elementMap(e);
        if (froms.size() != tos.size()) {
            return true;
        }
        for (TableObject from : froms.values()) {
            TableObject to = (TableObject)tos.get(from.getName());
            if (to != null && from.sameAs(to)) continue;
            return true;
        }
        return false;
    }

    private DatabaseType getDatabaseType() {
        return this.getSchema().getIntrospector().getDatabaseType().getType();
    }

    private MetadataRetriever getRetriever() {
        return this.getSchema().getIntrospector().getRetriever();
    }

    public static PrintWriter dropConstraint(PrintWriter pw, String name) {
        return pw.printf("drop constraint %s;;%n%n", name);
    }

    public static void generateAlterTable(PrintWriter pw, String name, String schema) {
        pw.printf("alter  table %s%n\t", TableInfo.getQName(schema, name));
    }

    public static String getConstrainedName(String name, String suffix) {
        return Strings.truncate((String)name, (String)suffix, (String)"_", (int)30).toUpperCase();
    }

    public static String getQName(String schema, String name) {
        return String.format("QName(%s, %s)", schema, name);
    }

    public abstract class TableObject<This extends MetadataObject<This>>
    extends MetadataObject<This> {
        private static final long serialVersionUID = -6635747157443366253L;

        protected TableObject(String name) {
            super(name);
        }

        @NotNull
        public final TableInfo getTable() {
            return TableInfo.this;
        }

        @Override
        @NotNull
        String getQualification() {
            return TableInfo.this.getFullName();
        }
    }

    public class PrimaryKey
    extends TableObject<PrimaryKey> {
        private final ImmutableList<Column> pkColumns;
        private static final long serialVersionUID = -8189328053606044845L;

        PrimaryKey(String name, Collection<Column> cols) {
            super(name);
            this.pkColumns = ImmutableList.fromIterable(cols);
            if (this.pkColumns.size() == 1) {
                Column first = (Column)this.pkColumns.get(0);
                if (!TableInfo.this.getSchema().isCurrent() && "ID".equals(first.getName()) && first.getType().getSqlKind() == SqlKind.INT && !first.isSerial() && !first.isOptional()) {
                    first.serial = true;
                }
            }
        }

        public String generateSql() {
            return String.format("constraint %s primary key(%s)", this.getName(), this.getColumnNames().mkString(", "));
        }

        @Override
        public boolean sameAs(PrimaryKey that) {
            return this.getName().equals(that.getName()) && this.getColumnNames().equals(that.getColumnNames());
        }

        public Seq<String> getColumnNames() {
            return this.pkColumns.map(MetadataObject::getName);
        }

        public ImmutableList<Column> getColumns() {
            return this.pkColumns;
        }

        public boolean isUndefined() {
            return this.getName().isEmpty() && this.pkColumns.isEmpty();
        }

        public boolean isDefault() {
            if (this.pkColumns.size() != 1) {
                return false;
            }
            Column column = (Column)this.pkColumns.get(0);
            return column.isSerial() && "id".equalsIgnoreCase(column.getName()) && column.getType().getSqlKind() == SqlKind.INT;
        }

        boolean isPrimaryKey(String indexName) {
            return indexName.equals(this.getName()) || TableInfo.this.getDatabaseType() == DatabaseType.HSQLDB && indexName.startsWith("SYS_IDX_" + this.getName());
        }
    }

    public static class IndexColumn {
        private final boolean descending;
        private final String name;

        IndexColumn(String columnName, boolean descending) {
            this.name = columnName;
            this.descending = descending;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof IndexColumn && this.descending == ((IndexColumn)obj).descending && this.name.equals(((IndexColumn)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode() + (this.descending ? 31 : 0);
        }

        public String toString() {
            return this.name + (this.descending ? "desc" : "");
        }

        public boolean isDescending() {
            return this.descending;
        }

        public String getName() {
            return this.name;
        }
    }

    public class Index
    extends TableObject<Index> {
        private final ImmutableList<IndexColumn> ixColumns;
        private final boolean unique;
        private static final long serialVersionUID = -8740103403688021348L;

        Index(String name, boolean unique, Collection<IndexColumn> cols) {
            super(name);
            this.ixColumns = ImmutableList.fromIterable(cols);
            this.unique = unique;
        }

        public void dumpSql(PrintWriter w) {
            w.printf("create %s IndexName(%s, %s)%n", this.unique ? "unique index" : "index", TableInfo.this.getSchema().getPlainName(), this.getName());
            w.printf("\ton %s (%s);;%n%n", TableInfo.this.asQName(), this.getColumns().toStrings().mkString(", "));
        }

        public String generateUniqueSql() {
            return String.format("constraint %s unique (%s)", this.getName(), this.getColumns().mkString(", "));
        }

        @Override
        public boolean sameAs(Index to) {
            return this.unique == to.unique && this.ixColumns.equals(to.ixColumns);
        }

        public ImmutableList<IndexColumn> getColumns() {
            return this.ixColumns;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public boolean isSystem() {
            return this.getName().contains("SYS_IDX");
        }
    }

    public class ForeignKey
    extends TableObject<ForeignKey> {
        private final ImmutableList<FkColumn> fkColumns;
        private final QName references;
        private static final long serialVersionUID = -8740103403688021348L;

        private ForeignKey(String name, QName referencedTable, Collection<FkColumn> cols) {
            super(name);
            this.references = referencedTable;
            this.fkColumns = ImmutableList.fromIterable(cols);
        }

        public void dropSql(PrintWriter w) {
            TableInfo.generateAlterTable(w, this.getTable().getName(), this.getTable().getSchema().getPlainName());
            TableInfo.dropConstraint(w, this.getName());
        }

        public void dumpSql(PrintWriter w) {
            TableInfo referencedTable = this.getReferencedTableInfo();
            String schema = TableInfo.this.getSchema().getName();
            if (!schema.equals(referencedTable.getSchema().getName())) {
                w.printf("-- if %s%n", DbMacro.NeedsGrantReference);
                w.printf("grant references on %s to SchemaOrUser(%s);;%n", referencedTable.asQName(), schema);
                w.println("-- end");
            }
            w.printf("alter table %s add constraint %s%n", TableInfo.this.asQName(), this.getName());
            w.printf("\tforeign key(%s)%n", this.getFkColumns().mkString(", "));
            w.printf("\treferences %s(%s);;%n%n", referencedTable.asQName(), this.getPkColumns().mkString(", "));
        }

        @Override
        public boolean sameAs(ForeignKey to) {
            return this.references.equals((Object)to.references) && this.fkColumns.equals(to.fkColumns);
        }

        public ImmutableList<FkColumn> getColumns() {
            return this.fkColumns;
        }

        public Seq<String> getFkColumns() {
            return this.fkColumns.map(FkColumn::getName);
        }

        public Seq<String> getPkColumns() {
            return this.fkColumns.map(FkColumn::getPkName);
        }

        public QName getReferencedTable() {
            return this.references;
        }

        public TableInfo getReferencedTableInfo() {
            SchemaInfo refS = TableInfo.this.getSchema().getIntrospector().getSchema(this.references.getQualification());
            return (TableInfo)refS.getTable(this.references.getName()).get();
        }
    }

    public static class FkColumn {
        @NotNull
        private final String name;
        @NotNull
        private final String pkName;

        FkColumn(@NotNull String name, @NotNull String pkName) {
            this.name = name;
            this.pkName = pkName;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FkColumn && this.name.equals(((FkColumn)o).name) && this.pkName.equals(((FkColumn)o).pkName);
        }

        public int hashCode() {
            return this.name.hashCode() + this.pkName.hashCode() * 31;
        }

        public String toString() {
            return this.pkName + "=" + this.name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPkName() {
            return this.pkName;
        }
    }

    public class Column
    extends TableObject<Column> {
        private String defaultValue;
        private final boolean nullable;
        private final int ordinal;
        private final String sequenceName;
        private final int sequenceStart;
        private boolean serial;
        private final SqlType sqlType;
        private static final long serialVersionUID = -6855385762977224678L;

        Column(String name, SqlType sqlType, int ordinal, boolean nullable, boolean serial, @Nullable String sequenceName, String defaultValue) {
            super(name);
            this.sqlType = sqlType;
            this.ordinal = ordinal;
            this.sequenceName = sequenceName;
            this.defaultValue = defaultValue;
            this.serial = serial;
            this.nullable = nullable && !serial;
            this.sequenceStart = 1;
        }

        public String formatType() {
            return this.serial ? String.format("%s(%d,%s)", this.sqlType.getSqlKind() == SqlKind.INT ? DbMacro.Serial : DbMacro.BigSerial, this.getSequenceStart(), this.getSequenceName()) : this.sqlType.format();
        }

        @Override
        public boolean sameAs(Column tc) {
            return this.sqlType == tc.sqlType && this.nullable == tc.nullable && Predefined.equal((Object)this.defaultValue, (Object)tc.defaultValue) && this.serial == tc.serial;
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append(String.format("%-33s ", this.getName()));
            if (this.nullable && this.defaultValue == null) {
                r.append(this.formatType());
            } else {
                r.append(String.format("%-16s", this.formatType()));
                if (this.defaultValue != null) {
                    r.append(" default ").append(this.defaultValue);
                }
                if (this.sqlType.getSqlKind() == SqlKind.BOOLEAN) {
                    r.append(" CheckBoolConstraint(").append(TableInfo.getConstrainedName(this.getTable().getName() + "_" + this.getName(), "B")).append(", ").append(this.getName()).append(")");
                }
                if (!this.nullable) {
                    r.append(" not null");
                }
            }
            return r.toString();
        }

        @Nullable
        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isOptional() {
            return this.nullable;
        }

        public boolean isSerial() {
            return this.serial;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getSequenceName() {
            return this.sequenceName.isEmpty() && this.serial ? this.getTable().getName() + "_SEQ" : this.sequenceName;
        }

        public int getSequenceStart() {
            return this.sequenceStart;
        }

        public SqlType getType() {
            return this.sqlType;
        }
    }

    public class Check
    extends TableObject<Check> {
        final List<String> cols;
        private final String condition;
        private final boolean enabled;
        private static final long serialVersionUID = -8135833449976813163L;

        Check(String name, String condition, boolean enabled) {
            super(name);
            this.condition = condition;
            this.enabled = enabled;
            this.cols = new ArrayList<String>();
        }

        public boolean hasColumn(String name) {
            return this.cols.contains(name);
        }

        @Override
        public boolean sameAs(Check to) {
            return this.condition.equals(to.condition) && this.getName().equals(to.getName());
        }

        @Override
        public String toString() {
            return this.getCondition();
        }

        public ImmutableList<String> getColumns() {
            return Colls.immutable(this.cols);
        }

        public String getCondition() {
            return this.condition;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static enum Element {
        COLUMN,
        INDEX,
        CHECK,
        FOREIGN_KEY,
        UNIQUE;

    }
}

