/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.database.introspect;

import java.util.EnumSet;
import mulesoft.common.logging.Logger;
import org.jetbrains.annotations.Nullable;

public enum TableType {
    TABLE,
    VIEW,
    ALIAS,
    SYNONYM,
    SYSTEM_TABLE,
    GLOBAL_TEMPORARY,
    FOREIGN_TABLE,
    INDEX,
    SEQUENCE,
    SYSTEM_INDEX,
    SYSTEM_TOAST_INDEX,
    SYSTEM_TOAST_TABLE,
    SYSTEM_VIEW,
    TEMPORARY_INDEX,
    TEMPORARY_SEQUENCE,
    TEMPORARY_TABLE,
    TEMPORARY_VIEW,
    TYPE,
    OTHER;

    private static final Logger logger;

    public boolean isTable() {
        return this == TABLE || this == SYSTEM_TABLE || this == SYSTEM_TOAST_TABLE || this == TEMPORARY_TABLE;
    }

    public boolean isView() {
        return this == VIEW || this == SYSTEM_VIEW || this == TEMPORARY_VIEW;
    }

    public static TableType fromString(String value) {
        try {
            return TableType.valueOf(value.trim().replace(' ', '_').toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.warning("Unknown " + value + " using OTHER.");
            return OTHER;
        }
    }

    @Nullable
    static String[] setToArray(EnumSet<TableType> set) {
        if (EnumSet.allOf(TableType.class).equals(set)) {
            return null;
        }
        String[] result = new String[set.size()];
        int i = 0;
        for (TableType t : set) {
            result[i++] = t.name().replace('_', ' ');
        }
        return result;
    }

    static {
        logger = Logger.getLogger(TableType.class);
    }
}

